"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .gender import Gender
from apideck_unify.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from datetime import date
from pydantic import model_serializer
from typing import Any, Dict
from typing_extensions import NotRequired, TypedDict


class PersonTypedDict(TypedDict):
    id: NotRequired[Nullable[str]]
    r"""A unique identifier for an object."""
    first_name: NotRequired[Nullable[str]]
    r"""The first name of the person."""
    last_name: NotRequired[Nullable[str]]
    r"""The last name of the person."""
    middle_name: NotRequired[Nullable[str]]
    r"""Middle name of the person."""
    gender: NotRequired[Nullable[Gender]]
    r"""The gender represents the gender identity of a person."""
    initials: NotRequired[Nullable[str]]
    r"""Initials of the person"""
    birthday: NotRequired[Nullable[date]]
    r"""Date of birth"""
    deceased_on: NotRequired[Nullable[date]]
    r"""Date of death"""
    custom_mappings: NotRequired[Nullable[Dict[str, Any]]]
    r"""When custom mappings are configured on the resource, the result is included here."""


class Person(BaseModel):
    id: OptionalNullable[str] = UNSET
    r"""A unique identifier for an object."""

    first_name: OptionalNullable[str] = UNSET
    r"""The first name of the person."""

    last_name: OptionalNullable[str] = UNSET
    r"""The last name of the person."""

    middle_name: OptionalNullable[str] = UNSET
    r"""Middle name of the person."""

    gender: OptionalNullable[Gender] = UNSET
    r"""The gender represents the gender identity of a person."""

    initials: OptionalNullable[str] = UNSET
    r"""Initials of the person"""

    birthday: OptionalNullable[date] = UNSET
    r"""Date of birth"""

    deceased_on: OptionalNullable[date] = UNSET
    r"""Date of death"""

    custom_mappings: OptionalNullable[Dict[str, Any]] = UNSET
    r"""When custom mappings are configured on the resource, the result is included here."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "first_name",
            "last_name",
            "middle_name",
            "gender",
            "initials",
            "birthday",
            "deceased_on",
            "custom_mappings",
        ]
        nullable_fields = [
            "id",
            "first_name",
            "last_name",
            "middle_name",
            "gender",
            "initials",
            "birthday",
            "deceased_on",
            "custom_mappings",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
