"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .currency import Currency
from .passthroughbody import PassThroughBody, PassThroughBodyTypedDict
from apideck_unify.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from datetime import datetime
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class StagesTypedDict(TypedDict):
    id: NotRequired[Nullable[str]]
    r"""The unique identifier of the Pipeline Stage."""
    name: NotRequired[Nullable[str]]
    r"""The name of the Pipeline Stage."""
    value: NotRequired[Nullable[str]]
    r"""The value of the Pipeline Stage."""
    win_probability: NotRequired[Nullable[int]]
    r"""The expected probability of winning an Opportunity in this Pipeline Stage. Valid values are [0-100]."""
    display_order: NotRequired[Nullable[int]]
    r"""The order in which the Pipeline Stage is displayed in the UI."""
    archived: NotRequired[Nullable[bool]]
    r"""Whether the Pipeline Stage is archived or not."""
    created_at: NotRequired[Nullable[datetime]]
    r"""The date and time when the Pipeline Stage was created."""
    updated_at: NotRequired[Nullable[datetime]]
    r"""The date and time when the Pipeline Stage was last updated."""


class Stages(BaseModel):
    id: OptionalNullable[str] = UNSET
    r"""The unique identifier of the Pipeline Stage."""

    name: OptionalNullable[str] = UNSET
    r"""The name of the Pipeline Stage."""

    value: OptionalNullable[str] = UNSET
    r"""The value of the Pipeline Stage."""

    win_probability: OptionalNullable[int] = UNSET
    r"""The expected probability of winning an Opportunity in this Pipeline Stage. Valid values are [0-100]."""

    display_order: OptionalNullable[int] = UNSET
    r"""The order in which the Pipeline Stage is displayed in the UI."""

    archived: OptionalNullable[bool] = UNSET
    r"""Whether the Pipeline Stage is archived or not."""

    created_at: OptionalNullable[datetime] = UNSET
    r"""The date and time when the Pipeline Stage was created."""

    updated_at: OptionalNullable[datetime] = UNSET
    r"""The date and time when the Pipeline Stage was last updated."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "name",
            "value",
            "win_probability",
            "display_order",
            "archived",
            "created_at",
            "updated_at",
        ]
        nullable_fields = [
            "id",
            "name",
            "value",
            "win_probability",
            "display_order",
            "archived",
            "created_at",
            "updated_at",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PipelineTypedDict(TypedDict):
    name: str
    r"""The name of the Pipeline."""
    id: NotRequired[str]
    r"""The unique identifier of the Pipeline."""
    currency: NotRequired[Nullable[Currency]]
    r"""Indicates the associated currency for an amount of money. Values correspond to [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217)."""
    archived: NotRequired[bool]
    r"""Whether the Pipeline is archived or not."""
    active: NotRequired[bool]
    r"""Whether the Pipeline is active or not."""
    display_order: NotRequired[Nullable[int]]
    r"""The order in which the Pipeline is displayed in the UI."""
    win_probability_enabled: NotRequired[bool]
    r"""Whether the Pipeline has win probability enabled or not."""
    stages: NotRequired[List[StagesTypedDict]]
    r"""The Pipeline Stages."""
    updated_at: NotRequired[Nullable[datetime]]
    r"""The date and time when the object was last updated."""
    created_at: NotRequired[Nullable[datetime]]
    r"""The date and time when the object was created."""
    pass_through: NotRequired[List[PassThroughBodyTypedDict]]
    r"""The pass_through property allows passing service-specific, custom data or structured modifications in request body when creating or updating resources."""


class Pipeline(BaseModel):
    name: str
    r"""The name of the Pipeline."""

    id: Optional[str] = None
    r"""The unique identifier of the Pipeline."""

    currency: OptionalNullable[Currency] = UNSET
    r"""Indicates the associated currency for an amount of money. Values correspond to [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217)."""

    archived: Optional[bool] = None
    r"""Whether the Pipeline is archived or not."""

    active: Optional[bool] = None
    r"""Whether the Pipeline is active or not."""

    display_order: OptionalNullable[int] = UNSET
    r"""The order in which the Pipeline is displayed in the UI."""

    win_probability_enabled: Optional[bool] = None
    r"""Whether the Pipeline has win probability enabled or not."""

    stages: Optional[List[Stages]] = None
    r"""The Pipeline Stages."""

    updated_at: OptionalNullable[datetime] = UNSET
    r"""The date and time when the object was last updated."""

    created_at: OptionalNullable[datetime] = UNSET
    r"""The date and time when the object was created."""

    pass_through: Optional[List[PassThroughBody]] = None
    r"""The pass_through property allows passing service-specific, custom data or structured modifications in request body when creating or updating resources."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "currency",
            "archived",
            "active",
            "display_order",
            "win_probability_enabled",
            "stages",
            "updated_at",
            "created_at",
            "pass_through",
        ]
        nullable_fields = ["currency", "display_order", "updated_at", "created_at"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
