"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from apideck_unify.types import BaseModel
from apideck_unify.utils import FieldMetadata
from datetime import datetime
from enum import Enum
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ProjectStatus(str, Enum):
    r"""Status of projects to filter by"""

    ACTIVE = "active"
    COMPLETED = "completed"
    ON_HOLD = "on_hold"
    CANCELLED = "cancelled"
    DRAFT = "draft"


class ProjectsFilterTypedDict(TypedDict):
    name: NotRequired[str]
    r"""Name of project to search for"""
    status: NotRequired[ProjectStatus]
    r"""Status of projects to filter by"""
    customer_id: NotRequired[str]
    r"""Filter projects by customer ID"""
    updated_since: NotRequired[datetime]
    r"""Return projects modified after this date"""


class ProjectsFilter(BaseModel):
    name: Annotated[Optional[str], FieldMetadata(query=True)] = None
    r"""Name of project to search for"""

    status: Annotated[Optional[ProjectStatus], FieldMetadata(query=True)] = None
    r"""Status of projects to filter by"""

    customer_id: Annotated[Optional[str], FieldMetadata(query=True)] = None
    r"""Filter projects by customer ID"""

    updated_since: Annotated[Optional[datetime], FieldMetadata(query=True)] = None
    r"""Return projects modified after this date"""
