"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .passthroughbody import PassThroughBody, PassThroughBodyTypedDict
from .sharedlinktarget import SharedLinkTarget, SharedLinkTargetTypedDict
from apideck_unify.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from datetime import datetime
from enum import Enum
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class Scope(str, Enum):
    r"""The scope of the shared link."""

    PUBLIC = "public"
    COMPANY = "company"


class SharedLinkTypedDict(TypedDict):
    url: NotRequired[Nullable[str]]
    r"""The URL that can be used to view the file."""
    download_url: NotRequired[Nullable[str]]
    r"""The URL that can be used to download the file."""
    target: NotRequired[SharedLinkTargetTypedDict]
    scope: NotRequired[Nullable[Scope]]
    r"""The scope of the shared link."""
    password_protected: NotRequired[Nullable[bool]]
    r"""Indicated if the shared link is password protected."""
    expires_at: NotRequired[Nullable[datetime]]
    updated_at: NotRequired[Nullable[datetime]]
    r"""The date and time when the object was last updated."""
    created_at: NotRequired[Nullable[datetime]]
    r"""The date and time when the object was created."""
    pass_through: NotRequired[List[PassThroughBodyTypedDict]]
    r"""The pass_through property allows passing service-specific, custom data or structured modifications in request body when creating or updating resources."""


class SharedLink(BaseModel):
    url: OptionalNullable[str] = UNSET
    r"""The URL that can be used to view the file."""

    download_url: OptionalNullable[str] = UNSET
    r"""The URL that can be used to download the file."""

    target: Optional[SharedLinkTarget] = None

    scope: OptionalNullable[Scope] = UNSET
    r"""The scope of the shared link."""

    password_protected: OptionalNullable[bool] = UNSET
    r"""Indicated if the shared link is password protected."""

    expires_at: OptionalNullable[datetime] = UNSET

    updated_at: OptionalNullable[datetime] = UNSET
    r"""The date and time when the object was last updated."""

    created_at: OptionalNullable[datetime] = UNSET
    r"""The date and time when the object was created."""

    pass_through: Optional[List[PassThroughBody]] = None
    r"""The pass_through property allows passing service-specific, custom data or structured modifications in request body when creating or updating resources."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "url",
            "download_url",
            "target",
            "scope",
            "password_protected",
            "expires_at",
            "updated_at",
            "created_at",
            "pass_through",
        ]
        nullable_fields = [
            "url",
            "download_url",
            "scope",
            "password_protected",
            "expires_at",
            "updated_at",
            "created_at",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class SharedLinkInputTypedDict(TypedDict):
    target_id: Nullable[str]
    r"""The ID of the file or folder to link."""
    download_url: NotRequired[Nullable[str]]
    r"""The URL that can be used to download the file."""
    scope: NotRequired[Nullable[Scope]]
    r"""The scope of the shared link."""
    password: NotRequired[Nullable[str]]
    r"""Optional password for the shared link."""
    pass_through: NotRequired[List[PassThroughBodyTypedDict]]
    r"""The pass_through property allows passing service-specific, custom data or structured modifications in request body when creating or updating resources."""


class SharedLinkInput(BaseModel):
    target_id: Nullable[str]
    r"""The ID of the file or folder to link."""

    download_url: OptionalNullable[str] = UNSET
    r"""The URL that can be used to download the file."""

    scope: OptionalNullable[Scope] = UNSET
    r"""The scope of the shared link."""

    password: OptionalNullable[str] = UNSET
    r"""Optional password for the shared link."""

    pass_through: Optional[List[PassThroughBody]] = None
    r"""The pass_through property allows passing service-specific, custom data or structured modifications in request body when creating or updating resources."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["download_url", "scope", "password", "pass_through"]
        nullable_fields = ["download_url", "target_id", "scope", "password"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
