"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .assignee import Assignee, AssigneeTypedDict
from .assignee_input import AssigneeInput, AssigneeInputTypedDict
from .collectiontag import CollectionTag, CollectionTagTypedDict
from .collectiontag_input import CollectionTagInput, CollectionTagInputTypedDict
from .passthroughbody import PassThroughBody, PassThroughBodyTypedDict
from apideck_unify.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from datetime import datetime
from enum import Enum
from pydantic import model_serializer
from typing import Any, Dict, List, Optional
from typing_extensions import NotRequired, TypedDict


class TicketPriority(str, Enum):
    r"""Priority of the ticket"""

    LOW = "low"
    NORMAL = "normal"
    HIGH = "high"
    URGENT = "urgent"


class TicketTypedDict(TypedDict):
    id: str
    r"""A unique identifier for an object."""
    parent_id: NotRequired[Nullable[str]]
    r"""The ticket's parent ID"""
    collection_id: NotRequired[Nullable[str]]
    r"""The ticket's collection ID"""
    type: NotRequired[Nullable[str]]
    r"""The ticket's type"""
    subject: NotRequired[Nullable[str]]
    r"""Subject of the ticket"""
    description: NotRequired[Nullable[str]]
    r"""The ticket's description. HTML version of description is mapped if supported by the third-party platform"""
    status: NotRequired[Nullable[str]]
    r"""The current status of the ticket. Possible values include: open, in_progress, closed, or - in cases where there is no clear mapping - the original value passed through."""
    priority: NotRequired[Nullable[TicketPriority]]
    r"""Priority of the ticket"""
    assignees: NotRequired[List[AssigneeTypedDict]]
    updated_at: NotRequired[Nullable[datetime]]
    r"""The date and time when the object was last updated."""
    created_at: NotRequired[Nullable[datetime]]
    r"""The date and time when the object was created."""
    created_by: NotRequired[Nullable[str]]
    r"""The user who created the object."""
    due_date: NotRequired[Nullable[datetime]]
    r"""Due date of the ticket"""
    completed_at: NotRequired[Nullable[datetime]]
    r"""When the ticket was completed"""
    tags: NotRequired[List[CollectionTagTypedDict]]
    custom_mappings: NotRequired[Nullable[Dict[str, Any]]]
    r"""When custom mappings are configured on the resource, the result is included here."""
    pass_through: NotRequired[List[PassThroughBodyTypedDict]]
    r"""The pass_through property allows passing service-specific, custom data or structured modifications in request body when creating or updating resources."""


class Ticket(BaseModel):
    id: str
    r"""A unique identifier for an object."""

    parent_id: OptionalNullable[str] = UNSET
    r"""The ticket's parent ID"""

    collection_id: OptionalNullable[str] = UNSET
    r"""The ticket's collection ID"""

    type: OptionalNullable[str] = UNSET
    r"""The ticket's type"""

    subject: OptionalNullable[str] = UNSET
    r"""Subject of the ticket"""

    description: OptionalNullable[str] = UNSET
    r"""The ticket's description. HTML version of description is mapped if supported by the third-party platform"""

    status: OptionalNullable[str] = UNSET
    r"""The current status of the ticket. Possible values include: open, in_progress, closed, or - in cases where there is no clear mapping - the original value passed through."""

    priority: OptionalNullable[TicketPriority] = UNSET
    r"""Priority of the ticket"""

    assignees: Optional[List[Assignee]] = None

    updated_at: OptionalNullable[datetime] = UNSET
    r"""The date and time when the object was last updated."""

    created_at: OptionalNullable[datetime] = UNSET
    r"""The date and time when the object was created."""

    created_by: OptionalNullable[str] = UNSET
    r"""The user who created the object."""

    due_date: OptionalNullable[datetime] = UNSET
    r"""Due date of the ticket"""

    completed_at: OptionalNullable[datetime] = UNSET
    r"""When the ticket was completed"""

    tags: Optional[List[CollectionTag]] = None

    custom_mappings: OptionalNullable[Dict[str, Any]] = UNSET
    r"""When custom mappings are configured on the resource, the result is included here."""

    pass_through: Optional[List[PassThroughBody]] = None
    r"""The pass_through property allows passing service-specific, custom data or structured modifications in request body when creating or updating resources."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "parent_id",
            "collection_id",
            "type",
            "subject",
            "description",
            "status",
            "priority",
            "assignees",
            "updated_at",
            "created_at",
            "created_by",
            "due_date",
            "completed_at",
            "tags",
            "custom_mappings",
            "pass_through",
        ]
        nullable_fields = [
            "parent_id",
            "collection_id",
            "type",
            "subject",
            "description",
            "status",
            "priority",
            "updated_at",
            "created_at",
            "created_by",
            "due_date",
            "completed_at",
            "custom_mappings",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class TicketInputTypedDict(TypedDict):
    parent_id: NotRequired[Nullable[str]]
    r"""The ticket's parent ID"""
    type: NotRequired[Nullable[str]]
    r"""The ticket's type"""
    subject: NotRequired[Nullable[str]]
    r"""Subject of the ticket"""
    description: NotRequired[Nullable[str]]
    r"""The ticket's description. HTML version of description is mapped if supported by the third-party platform"""
    status: NotRequired[Nullable[str]]
    r"""The current status of the ticket. Possible values include: open, in_progress, closed, or - in cases where there is no clear mapping - the original value passed through."""
    priority: NotRequired[Nullable[TicketPriority]]
    r"""Priority of the ticket"""
    assignees: NotRequired[List[AssigneeInputTypedDict]]
    due_date: NotRequired[Nullable[datetime]]
    r"""Due date of the ticket"""
    tags: NotRequired[List[CollectionTagInputTypedDict]]
    pass_through: NotRequired[List[PassThroughBodyTypedDict]]
    r"""The pass_through property allows passing service-specific, custom data or structured modifications in request body when creating or updating resources."""


class TicketInput(BaseModel):
    parent_id: OptionalNullable[str] = UNSET
    r"""The ticket's parent ID"""

    type: OptionalNullable[str] = UNSET
    r"""The ticket's type"""

    subject: OptionalNullable[str] = UNSET
    r"""Subject of the ticket"""

    description: OptionalNullable[str] = UNSET
    r"""The ticket's description. HTML version of description is mapped if supported by the third-party platform"""

    status: OptionalNullable[str] = UNSET
    r"""The current status of the ticket. Possible values include: open, in_progress, closed, or - in cases where there is no clear mapping - the original value passed through."""

    priority: OptionalNullable[TicketPriority] = UNSET
    r"""Priority of the ticket"""

    assignees: Optional[List[AssigneeInput]] = None

    due_date: OptionalNullable[datetime] = UNSET
    r"""Due date of the ticket"""

    tags: Optional[List[CollectionTagInput]] = None

    pass_through: Optional[List[PassThroughBody]] = None
    r"""The pass_through property allows passing service-specific, custom data or structured modifications in request body when creating or updating resources."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "parent_id",
            "type",
            "subject",
            "description",
            "status",
            "priority",
            "assignees",
            "due_date",
            "tags",
            "pass_through",
        ]
        nullable_fields = [
            "parent_id",
            "type",
            "subject",
            "description",
            "status",
            "priority",
            "due_date",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
