"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from apideck_unify.types import BaseModel
from apideck_unify.utils import FieldMetadata
from enum import Enum
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class TimeOffRequestStatus(str, Enum):
    r"""Time off request status to filter on"""

    REQUESTED = "requested"
    APPROVED = "approved"
    DECLINED = "declined"
    CANCELLED = "cancelled"
    DELETED = "deleted"
    OTHER = "other"


class TimeOffRequestsFilterTypedDict(TypedDict):
    start_date: NotRequired[str]
    r"""Start date of the date range to filter time off requests. When used with end_date, filters for requests within the specified date range."""
    end_date: NotRequired[str]
    r"""End date of the date range to filter time off requests. When used with start_date, filters for requests within the specified date range."""
    updated_since: NotRequired[str]
    r"""Minimum date the time off request was last created or modified"""
    employee_id: NotRequired[str]
    r"""Employee ID"""
    time_off_request_status: NotRequired[TimeOffRequestStatus]
    r"""Time off request status to filter on"""
    company_id: NotRequired[str]
    r"""Company ID"""


class TimeOffRequestsFilter(BaseModel):
    start_date: Annotated[Optional[str], FieldMetadata(query=True)] = None
    r"""Start date of the date range to filter time off requests. When used with end_date, filters for requests within the specified date range."""

    end_date: Annotated[Optional[str], FieldMetadata(query=True)] = None
    r"""End date of the date range to filter time off requests. When used with start_date, filters for requests within the specified date range."""

    updated_since: Annotated[Optional[str], FieldMetadata(query=True)] = None
    r"""Minimum date the time off request was last created or modified"""

    employee_id: Annotated[Optional[str], FieldMetadata(query=True)] = None
    r"""Employee ID"""

    time_off_request_status: Annotated[
        Optional[TimeOffRequestStatus], FieldMetadata(query=True)
    ] = None
    r"""Time off request status to filter on"""

    company_id: Annotated[Optional[str], FieldMetadata(query=True)] = None
    r"""Company ID"""
