"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from apideck_unify.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from datetime import datetime
from pydantic import model_serializer
from typing_extensions import NotRequired, TypedDict


class TrackingItemTypedDict(TypedDict):
    r"""Represents the tracking information associated with an ecommerce order."""

    provider: Nullable[str]
    r"""The name or code of the carrier or shipping company that is handling the shipment."""
    number: Nullable[str]
    r"""The tracking number associated with the shipment, which can be used to track the progress of the delivery."""
    url: NotRequired[Nullable[str]]
    r"""The URL of the carrier's tracking page, which can be used to view detailed information about the shipment's progress."""
    updated_at: NotRequired[Nullable[datetime]]
    r"""The date and time when the object was last updated."""


class TrackingItem(BaseModel):
    r"""Represents the tracking information associated with an ecommerce order."""

    provider: Nullable[str]
    r"""The name or code of the carrier or shipping company that is handling the shipment."""

    number: Nullable[str]
    r"""The tracking number associated with the shipment, which can be used to track the progress of the delivery."""

    url: OptionalNullable[str] = UNSET
    r"""The URL of the carrier's tracking page, which can be used to view detailed information about the shipment's progress."""

    updated_at: OptionalNullable[datetime] = UNSET
    r"""The date and time when the object was last updated."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["url", "updated_at"]
        nullable_fields = ["provider", "number", "url", "updated_at"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
