"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from apideck_unify.models import ApideckError
from apideck_unify.types import BaseModel
from dataclasses import dataclass, field
import httpx
from typing import Any, Dict, Optional, Union
from typing_extensions import TypeAliasType


UnprocessableResponseDetailTypedDict = TypeAliasType(
    "UnprocessableResponseDetailTypedDict", Union[str, Dict[str, Any]]
)
r"""Contains parameter or domain specific information related to the error and why it occurred."""


UnprocessableResponseDetail = TypeAliasType(
    "UnprocessableResponseDetail", Union[str, Dict[str, Any]]
)
r"""Contains parameter or domain specific information related to the error and why it occurred."""


class UnprocessableResponseData(BaseModel):
    status_code: Optional[float] = None
    r"""HTTP status code"""

    error: Optional[str] = None
    r"""Contains an explanation of the status_code as defined in HTTP/1.1 standard (RFC 7231)"""

    type_name: Optional[str] = None
    r"""The type of error returned"""

    message: Optional[str] = None
    r"""A human-readable message providing more details about the error."""

    detail: Optional[UnprocessableResponseDetail] = None
    r"""Contains parameter or domain specific information related to the error and why it occurred."""

    ref: Optional[str] = None
    r"""Link to documentation of error type"""


@dataclass(unsafe_hash=True)
class UnprocessableResponse(ApideckError):
    r"""Unprocessable"""

    data: UnprocessableResponseData = field(hash=False)

    def __init__(
        self,
        data: UnprocessableResponseData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        fallback = body or raw_response.text
        message = str(data.message) or fallback
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)
