"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .status import Status
from .unifiedapiid import UnifiedAPIID
from .webhookeventtype import WebhookEventType
from apideck_unify.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from datetime import datetime
from enum import Enum
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class DisabledReason(str, Enum):
    r"""Indicates why the webhook has been disabled. `retry_limit`: webhook reached its retry limit. `usage_limit`: account is over its usage limit. `delivery_url_validation_failed`: delivery URL failed validation during webhook creation or update."""

    NONE = "none"
    RETRY_LIMIT = "retry_limit"
    USAGE_LIMIT = "usage_limit"
    DELIVERY_URL_VALIDATION_FAILED = "delivery_url_validation_failed"


class WebhookTypedDict(TypedDict):
    unified_api: UnifiedAPIID
    r"""Name of Apideck Unified API"""
    status: Status
    r"""The status of the webhook."""
    delivery_url: str
    r"""The delivery url of the webhook endpoint."""
    execute_base_url: str
    r"""The Unify Base URL events from connectors will be sent to after service id is appended."""
    events: List[WebhookEventType]
    r"""The list of subscribed events for this webhook. [`*`] indicates that all events are enabled."""
    id: NotRequired[str]
    description: NotRequired[Nullable[str]]
    r"""A description of the object."""
    disabled_reason: NotRequired[DisabledReason]
    r"""Indicates why the webhook has been disabled. `retry_limit`: webhook reached its retry limit. `usage_limit`: account is over its usage limit. `delivery_url_validation_failed`: delivery URL failed validation during webhook creation or update."""
    updated_at: NotRequired[Nullable[datetime]]
    r"""The date and time when the object was last updated."""
    created_at: NotRequired[Nullable[datetime]]
    r"""The date and time when the object was created."""


class Webhook(BaseModel):
    unified_api: UnifiedAPIID
    r"""Name of Apideck Unified API"""

    status: Status
    r"""The status of the webhook."""

    delivery_url: str
    r"""The delivery url of the webhook endpoint."""

    execute_base_url: str
    r"""The Unify Base URL events from connectors will be sent to after service id is appended."""

    events: List[WebhookEventType]
    r"""The list of subscribed events for this webhook. [`*`] indicates that all events are enabled."""

    id: Optional[str] = None

    description: OptionalNullable[str] = UNSET
    r"""A description of the object."""

    disabled_reason: Optional[DisabledReason] = None
    r"""Indicates why the webhook has been disabled. `retry_limit`: webhook reached its retry limit. `usage_limit`: account is over its usage limit. `delivery_url_validation_failed`: delivery URL failed validation during webhook creation or update."""

    updated_at: OptionalNullable[datetime] = UNSET
    r"""The date and time when the object was last updated."""

    created_at: OptionalNullable[datetime] = UNSET
    r"""The date and time when the object was created."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "description",
            "disabled_reason",
            "updated_at",
            "created_at",
        ]
        nullable_fields = ["description", "updated_at", "created_at"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
