"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .unifiedapiid import UnifiedAPIID
from apideck_unify.types import BaseModel
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class WebhookEventLogServiceTypedDict(TypedDict):
    r"""Apideck service provider associated with event."""

    id: str
    r"""Apideck service provider id."""
    name: str
    r"""Apideck service provider name."""


class WebhookEventLogService(BaseModel):
    r"""Apideck service provider associated with event."""

    id: str
    r"""Apideck service provider id."""

    name: str
    r"""Apideck service provider name."""


class AttemptsTypedDict(TypedDict):
    timestamp: NotRequired[str]
    r"""ISO Date and time when the request was made."""
    execution_attempt: NotRequired[float]
    r"""Number of attempts webhook endpoint was called before a success was returned or eventually failed"""
    status_code: NotRequired[int]
    r"""HTTP Status code that was returned."""
    success: NotRequired[bool]
    r"""Whether or not the request was successful."""


class Attempts(BaseModel):
    timestamp: Optional[str] = None
    r"""ISO Date and time when the request was made."""

    execution_attempt: Optional[float] = None
    r"""Number of attempts webhook endpoint was called before a success was returned or eventually failed"""

    status_code: Optional[int] = None
    r"""HTTP Status code that was returned."""

    success: Optional[bool] = None
    r"""Whether or not the request was successful."""


class WebhookEventLogTypedDict(TypedDict):
    id: NotRequired[str]
    status_code: NotRequired[int]
    r"""HTTP Status code that was returned."""
    success: NotRequired[bool]
    r"""Whether or not the request was successful."""
    application_id: NotRequired[str]
    r"""ID of your Apideck Application"""
    consumer_id: NotRequired[str]
    r"""Unique consumer identifier. You can freely choose a consumer ID yourself. Most of the time, this is an ID of your internal data model that represents a user or account in your system (for example account:12345). If the consumer doesn't exist yet, Vault will upsert a consumer based on your ID."""
    unified_api: NotRequired[UnifiedAPIID]
    r"""Name of Apideck Unified API"""
    service: NotRequired[WebhookEventLogServiceTypedDict]
    r"""Apideck service provider associated with event."""
    endpoint: NotRequired[str]
    r"""The URL of the webhook endpoint."""
    event_type: NotRequired[str]
    r"""Name of source event that webhook is subscribed to."""
    execution_attempt: NotRequired[float]
    r"""Number of attempts webhook endpoint was called before a success was returned or eventually failed"""
    http_method: NotRequired[str]
    r"""HTTP Method of request to endpoint."""
    timestamp: NotRequired[str]
    r"""ISO Date and time when the request was made."""
    entity_type: NotRequired[str]
    r"""Name of the Entity described by the attributes delivered within payload"""
    request_body: NotRequired[str]
    r"""The JSON stringified payload that was delivered to the webhook endpoint."""
    response_body: NotRequired[str]
    r"""The JSON stringified response that was returned from the webhook endpoint."""
    retry_scheduled: NotRequired[bool]
    r"""If the request has not hit the max retry limit and will be retried."""
    attempts: NotRequired[List[AttemptsTypedDict]]
    r"""record of each attempt to call webhook endpoint"""


class WebhookEventLog(BaseModel):
    id: Optional[str] = None

    status_code: Optional[int] = None
    r"""HTTP Status code that was returned."""

    success: Optional[bool] = None
    r"""Whether or not the request was successful."""

    application_id: Optional[str] = None
    r"""ID of your Apideck Application"""

    consumer_id: Optional[str] = None
    r"""Unique consumer identifier. You can freely choose a consumer ID yourself. Most of the time, this is an ID of your internal data model that represents a user or account in your system (for example account:12345). If the consumer doesn't exist yet, Vault will upsert a consumer based on your ID."""

    unified_api: Optional[UnifiedAPIID] = None
    r"""Name of Apideck Unified API"""

    service: Optional[WebhookEventLogService] = None
    r"""Apideck service provider associated with event."""

    endpoint: Optional[str] = None
    r"""The URL of the webhook endpoint."""

    event_type: Optional[str] = None
    r"""Name of source event that webhook is subscribed to."""

    execution_attempt: Optional[float] = None
    r"""Number of attempts webhook endpoint was called before a success was returned or eventually failed"""

    http_method: Optional[str] = None
    r"""HTTP Method of request to endpoint."""

    timestamp: Optional[str] = None
    r"""ISO Date and time when the request was made."""

    entity_type: Optional[str] = None
    r"""Name of the Entity described by the attributes delivered within payload"""

    request_body: Optional[str] = None
    r"""The JSON stringified payload that was delivered to the webhook endpoint."""

    response_body: Optional[str] = None
    r"""The JSON stringified response that was returned from the webhook endpoint."""

    retry_scheduled: Optional[bool] = None
    r"""If the request has not hit the max retry limit and will be retried."""

    attempts: Optional[List[Attempts]] = None
    r"""record of each attempt to call webhook endpoint"""
