"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IotRepublishMqttAction = exports.MqttQualityOfService = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const role_1 = require("./private/role");
/**
 * MQTT Quality of Service (QoS) indicates the level of assurance for delivery of an MQTT Message.
 *
 * @see https://docs.aws.amazon.com/iot/latest/developerguide/mqtt.html#mqtt-qos
 */
var MqttQualityOfService;
(function (MqttQualityOfService) {
    /**
     * QoS level 0. Sent zero or more times.
     * This level should be used for messages that are sent over reliable communication links or that can be missed without a problem.
     */
    MqttQualityOfService[MqttQualityOfService["ZERO_OR_MORE_TIMES"] = 0] = "ZERO_OR_MORE_TIMES";
    /**
     * QoS level 1. Sent at least one time, and then repeatedly until a PUBACK response is received.
     * The message is not considered complete until the sender receives a PUBACK response to indicate successful delivery.
     */
    MqttQualityOfService[MqttQualityOfService["AT_LEAST_ONCE"] = 1] = "AT_LEAST_ONCE";
})(MqttQualityOfService = exports.MqttQualityOfService || (exports.MqttQualityOfService = {}));
/**
 * The action to put the record from an MQTT message to republish another MQTT topic.
 */
class IotRepublishMqttAction {
    /**
     * @param topic The MQTT topic to which to republish the message.
     * @param props Optional properties to not use default.
     */
    constructor(topic, props = {}) {
        this.topic = topic;
        jsiiDeprecationWarnings._aws_cdk_aws_iot_actions_IotRepublishMqttActionProps(props);
        this.qualityOfService = props.qualityOfService;
        this.role = props.role;
    }
    bind(rule) {
        var _b;
        const role = (_b = this.role) !== null && _b !== void 0 ? _b : role_1.singletonActionRole(rule);
        role.addToPrincipalPolicy(new iam.PolicyStatement({
            actions: ['iot:Publish'],
            resources: ['*'],
        }));
        return {
            configuration: {
                republish: {
                    topic: this.topic,
                    qos: this.qualityOfService,
                    roleArn: role.roleArn,
                },
            },
        };
    }
}
exports.IotRepublishMqttAction = IotRepublishMqttAction;
_a = JSII_RTTI_SYMBOL_1;
IotRepublishMqttAction[_a] = { fqn: "@aws-cdk/aws-iot-actions.IotRepublishMqttAction", version: "1.151.0" };
//# sourceMappingURL=data:application/json;base64,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