# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables

class AccountTeamMember(pulumi.CustomResource):
    accepted: pulumi.Output[bool]
    """
    Team member invitation status
    """
    account_id: pulumi.Output[str]
    """
    Account id
    """
    create_time: pulumi.Output[str]
    """
    Time of creation
    """
    invited_by_user_email: pulumi.Output[str]
    """
    Team invited by user email
    """
    team_id: pulumi.Output[str]
    """
    Account team id
    """
    user_email: pulumi.Output[str]
    """
    Team invite user email
    """
    def __init__(__self__, resource_name, opts=None, accepted=None, account_id=None, create_time=None, invited_by_user_email=None, team_id=None, user_email=None, __props__=None, __name__=None, __opts__=None):
        """
        During the creation of `.AccountTeamMember` resource, an email invitation will be sent
        to a user using `user_email` address. If the user accepts an invitation, he or she will become a member of the account team. 
        The deletion of `.AccountTeamMember` will not only delete invitation if one was sent but not yet accepted by the 
        user, and it will also eliminate an account team member if one has accepted an invitation previously.

        ## Example Usage



        ```python
        import pulumi
        import pulumi_aiven as aiven

        foo = aiven.AccountTeamMember("foo",
            account_id=aiven_account["developers"]["account_id"],
            team_id=aiven_account["developers"]["account_id"],
            user_email="user+1@example.com")
        ```


        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] accepted: Team member invitation status
        :param pulumi.Input[str] account_id: Account id
        :param pulumi.Input[str] create_time: Time of creation
        :param pulumi.Input[str] invited_by_user_email: Team invited by user email
        :param pulumi.Input[str] team_id: Account team id
        :param pulumi.Input[str] user_email: Team invite user email
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['accepted'] = accepted
            if account_id is None:
                raise TypeError("Missing required property 'account_id'")
            __props__['account_id'] = account_id
            __props__['create_time'] = create_time
            __props__['invited_by_user_email'] = invited_by_user_email
            if team_id is None:
                raise TypeError("Missing required property 'team_id'")
            __props__['team_id'] = team_id
            if user_email is None:
                raise TypeError("Missing required property 'user_email'")
            __props__['user_email'] = user_email
        super(AccountTeamMember, __self__).__init__(
            'aiven:index/accountTeamMember:AccountTeamMember',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, accepted=None, account_id=None, create_time=None, invited_by_user_email=None, team_id=None, user_email=None):
        """
        Get an existing AccountTeamMember resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] accepted: Team member invitation status
        :param pulumi.Input[str] account_id: Account id
        :param pulumi.Input[str] create_time: Time of creation
        :param pulumi.Input[str] invited_by_user_email: Team invited by user email
        :param pulumi.Input[str] team_id: Account team id
        :param pulumi.Input[str] user_email: Team invite user email
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["accepted"] = accepted
        __props__["account_id"] = account_id
        __props__["create_time"] = create_time
        __props__["invited_by_user_email"] = invited_by_user_email
        __props__["team_id"] = team_id
        __props__["user_email"] = user_email
        return AccountTeamMember(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

