# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables

class Project(pulumi.CustomResource):
    account_id: pulumi.Output[str]
    """
    Account ID
    """
    billing_address: pulumi.Output[str]
    """
    Billing name and address of the project
    """
    billing_emails: pulumi.Output[list]
    """
    Billing contact emails of the project
    """
    ca_cert: pulumi.Output[str]
    """
    Project root CA. This is used by some services like Kafka to sign service certificate
    """
    card_id: pulumi.Output[str]
    """
    Credit card ID
    """
    copy_from_project: pulumi.Output[str]
    """
    Copy properties from another project. Only has effect when a new project is created.
    """
    country_code: pulumi.Output[str]
    """
    Billing country code of the project
    """
    project: pulumi.Output[str]
    """
    Project name
    """
    technical_emails: pulumi.Output[list]
    """
    Technical contact emails of the project
    """
    def __init__(__self__, resource_name, opts=None, account_id=None, billing_address=None, billing_emails=None, ca_cert=None, card_id=None, copy_from_project=None, country_code=None, project=None, technical_emails=None, __props__=None, __name__=None, __opts__=None):
        """
        ## Example Usage



        ```python
        import pulumi
        import pulumi_aiven as aiven

        myproject = aiven.Project("myproject",
            card_id="<FULL_CARD_ID/LAST4_DIGITS>",
            project="<PROJECT_NAME>")
        ```


        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: Account ID
        :param pulumi.Input[str] billing_address: Billing name and address of the project
        :param pulumi.Input[list] billing_emails: Billing contact emails of the project
        :param pulumi.Input[str] ca_cert: Project root CA. This is used by some services like Kafka to sign service certificate
        :param pulumi.Input[str] card_id: Credit card ID
        :param pulumi.Input[str] copy_from_project: Copy properties from another project. Only has effect when a new project is created.
        :param pulumi.Input[str] country_code: Billing country code of the project
        :param pulumi.Input[str] project: Project name
        :param pulumi.Input[list] technical_emails: Technical contact emails of the project
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['account_id'] = account_id
            __props__['billing_address'] = billing_address
            __props__['billing_emails'] = billing_emails
            __props__['ca_cert'] = ca_cert
            __props__['card_id'] = card_id
            __props__['copy_from_project'] = copy_from_project
            __props__['country_code'] = country_code
            if project is None:
                raise TypeError("Missing required property 'project'")
            __props__['project'] = project
            __props__['technical_emails'] = technical_emails
        super(Project, __self__).__init__(
            'aiven:index/project:Project',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, account_id=None, billing_address=None, billing_emails=None, ca_cert=None, card_id=None, copy_from_project=None, country_code=None, project=None, technical_emails=None):
        """
        Get an existing Project resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: Account ID
        :param pulumi.Input[str] billing_address: Billing name and address of the project
        :param pulumi.Input[list] billing_emails: Billing contact emails of the project
        :param pulumi.Input[str] ca_cert: Project root CA. This is used by some services like Kafka to sign service certificate
        :param pulumi.Input[str] card_id: Credit card ID
        :param pulumi.Input[str] copy_from_project: Copy properties from another project. Only has effect when a new project is created.
        :param pulumi.Input[str] country_code: Billing country code of the project
        :param pulumi.Input[str] project: Project name
        :param pulumi.Input[list] technical_emails: Technical contact emails of the project
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["account_id"] = account_id
        __props__["billing_address"] = billing_address
        __props__["billing_emails"] = billing_emails
        __props__["ca_cert"] = ca_cert
        __props__["card_id"] = card_id
        __props__["copy_from_project"] = copy_from_project
        __props__["country_code"] = country_code
        __props__["project"] = project
        __props__["technical_emails"] = technical_emails
        return Project(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

