# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables

class ServiceUser(pulumi.CustomResource):
    access_cert: pulumi.Output[str]
    """
    Access certificate for the user if applicable for the service in question
    """
    access_key: pulumi.Output[str]
    """
    Access certificate key for the user if applicable for the service in question
    """
    password: pulumi.Output[str]
    """
    Password of the user
    """
    project: pulumi.Output[str]
    """
    Project to link the user to
    """
    service_name: pulumi.Output[str]
    """
    Service to link the user to
    """
    type: pulumi.Output[str]
    """
    Type of the user account
    """
    username: pulumi.Output[str]
    """
    Name of the user account
    """
    def __init__(__self__, resource_name, opts=None, project=None, service_name=None, username=None, __props__=None, __name__=None, __opts__=None):
        """
        ## Example Usage



        ```python
        import pulumi
        import pulumi_aiven as aiven

        myserviceuser = aiven.ServiceUser("myserviceuser",
            project=aiven_project["myproject"]["project"],
            service_name=aiven_service["myservice"]["service_name"],
            username="<USERNAME>")
        ```


        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] project: Project to link the user to
        :param pulumi.Input[str] service_name: Service to link the user to
        :param pulumi.Input[str] username: Name of the user account
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if project is None:
                raise TypeError("Missing required property 'project'")
            __props__['project'] = project
            if service_name is None:
                raise TypeError("Missing required property 'service_name'")
            __props__['service_name'] = service_name
            if username is None:
                raise TypeError("Missing required property 'username'")
            __props__['username'] = username
            __props__['access_cert'] = None
            __props__['access_key'] = None
            __props__['password'] = None
            __props__['type'] = None
        super(ServiceUser, __self__).__init__(
            'aiven:index/serviceUser:ServiceUser',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, access_cert=None, access_key=None, password=None, project=None, service_name=None, type=None, username=None):
        """
        Get an existing ServiceUser resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_cert: Access certificate for the user if applicable for the service in question
        :param pulumi.Input[str] access_key: Access certificate key for the user if applicable for the service in question
        :param pulumi.Input[str] password: Password of the user
        :param pulumi.Input[str] project: Project to link the user to
        :param pulumi.Input[str] service_name: Service to link the user to
        :param pulumi.Input[str] type: Type of the user account
        :param pulumi.Input[str] username: Name of the user account
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["access_cert"] = access_cert
        __props__["access_key"] = access_key
        __props__["password"] = password
        __props__["project"] = project
        __props__["service_name"] = service_name
        __props__["type"] = type
        __props__["username"] = username
        return ServiceUser(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

