"""Output formatting functions."""

import json

from . import tree
from .misc import printlog


def tree_to_json(obj_tree):
    """Create a JSON object with a given format from a tree.

    Parameters
    ----------
    obj_tree : list(dict)
        The object tree as generated by `hrm_omero.tree.gen_children()`.

    Returns
    -------
    str
        The JSON-formatted representation of the object tree.
    """
    return json.dumps(obj_tree, sort_keys=True, indent=4, separators=(",", ": "))


def print_children_json(conn, omero_id):
    """Print the child nodes of the given ID in JSON format.

    Parameters
    ----------
    conn : omero.gateway.BlitzGateway
        The OMERO connection object.
    omero_id : hrm_omero.misc.OmeroId
        An object denoting an OMERO target.

    Returns
    -------
    bool
        True in case printing the nodes was successful, False otherwise.
    """
    try:
        children = tree.gen_children(conn, omero_id)
    except:  # pylint: disable-msg=bare-except
        printlog("ERROR", "ERROR generating OMERO tree / node!")
        return False
    print(tree_to_json(children))
    return True
