#!/usr/bin/python
from __future__ import absolute_import, division, print_function
# Copyright 2019-2020 Fortinet, Inc.
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.

__metaclass__ = type

ANSIBLE_METADATA = {'status': ['preview'],
                    'supported_by': 'community',
                    'metadata_version': '1.1'}

DOCUMENTATION = '''
---
module: fmgr_system_admin_ldap
short_description: LDAP server entry configuration.
description:
    - This module is able to configure a FortiManager device.
    - Examples include all parameters and values which need to be adjusted to data sources before usage.

version_added: "2.10"
author:
    - Link Zheng (@chillancezen)
    - Jie Xue (@JieX19)
    - Frank Shen (@fshen01)
    - Hongbin Lu (@fgtdev-hblu)
notes:
    - Running in workspace locking mode is supported in this FortiManager module, the top
      level parameters workspace_locking_adom and workspace_locking_timeout help do the work.
    - To create or update an object, use state present directive.
    - To delete an object, use state absent directive.
    - Normally, running one module can fail when a non-zero rc is returned. you can also override
      the conditions to fail or succeed with parameters rc_failed and rc_succeeded

options:
    bypass_validation:
        description: only set to True when module schema diffs with FortiManager API structure, module continues to execute without validating parameters
        required: false
        type: bool
        default: false
    workspace_locking_adom:
        description: the adom to lock for FortiManager running in workspace mode, the value can be global and others including root
        required: false
        type: str
    workspace_locking_timeout:
        description: the maximum time in seconds to wait for other user to release the workspace lock
        required: false
        type: int
        default: 300
    state:
        description: the directive to create, update or delete an object
        type: str
        required: true
        choices:
          - present
          - absent
    rc_succeeded:
        description: the rc codes list with which the conditions to succeed will be overriden
        type: list
        required: false
    rc_failed:
        description: the rc codes list with which the conditions to fail will be overriden
        type: list
        required: false
    system_admin_ldap:
        description: the top level parameters set
        required: false
        type: dict
        suboptions:
            adom:
                description: no description
                type: list
                suboptions:
                    adom-name:
                        type: str
                        description: 'Admin domain names.'
            adom-attr:
                type: str
                description: 'Attribute used to retrieve adom'
            attributes:
                type: str
                default: 'member,uniquemember,memberuid'
                description: 'Attributes used for group searching.'
            ca-cert:
                type: str
                description: 'CA certificate name.'
            cnid:
                type: str
                default: 'cn'
                description: 'Common Name Identifier (default = CN).'
            connect-timeout:
                type: int
                default: 500
                description: 'LDAP connection timeout (msec).'
            dn:
                type: str
                description: 'Distinguished Name.'
            filter:
                type: str
                default: '(objectclass=*)'
                description: 'Filter used for group searching.'
            group:
                type: str
                description: 'Full base DN used for group searching.'
            memberof-attr:
                type: str
                description: 'Attribute used to retrieve memeberof.'
            name:
                type: str
                description: 'LDAP server entry name.'
            password:
                description: no description
                type: str
            port:
                type: int
                default: 389
                description: 'Port number of LDAP server (default = 389).'
            profile-attr:
                type: str
                description: 'Attribute used to retrieve admin profile.'
            secondary-server:
                type: str
                description: '{<name_str|ip_str>} secondary LDAP server domain name or IP.'
            secure:
                type: str
                default: 'disable'
                description:
                 - 'SSL connection.'
                 - 'disable - No SSL.'
                 - 'starttls - Use StartTLS.'
                 - 'ldaps - Use LDAPS.'
                choices:
                    - 'disable'
                    - 'starttls'
                    - 'ldaps'
            server:
                type: str
                description: '{<name_str|ip_str>} LDAP server domain name or IP.'
            tertiary-server:
                type: str
                description: '{<name_str|ip_str>} tertiary LDAP server domain name or IP.'
            type:
                type: str
                default: 'simple'
                description:
                 - 'Type of LDAP binding.'
                 - 'simple - Simple password authentication without search.'
                 - 'anonymous - Bind using anonymous user search.'
                 - 'regular - Bind using username/password and then search.'
                choices:
                    - 'simple'
                    - 'anonymous'
                    - 'regular'
            username:
                type: str
                description: 'Username (full DN) for initial binding.'

'''

EXAMPLES = '''
 - hosts: fortimanager-inventory
   collections:
     - fortinet.fortimanager
   connection: httpapi
   vars:
      ansible_httpapi_use_ssl: True
      ansible_httpapi_validate_certs: False
      ansible_httpapi_port: 443
   tasks:
    - name: LDAP server entry configuration.
      fmgr_system_admin_ldap:
         bypass_validation: False
         workspace_locking_adom: <value in [global, custom adom including root]>
         workspace_locking_timeout: 300
         rc_succeeded: [0, -2, -3, ...]
         rc_failed: [-2, -3, ...]
         state: <value in [present, absent]>
         system_admin_ldap:
            adom:
              -
                  adom-name: <value of string>
            adom-attr: <value of string>
            attributes: <value of string>
            ca-cert: <value of string>
            cnid: <value of string>
            connect-timeout: <value of integer>
            dn: <value of string>
            filter: <value of string>
            group: <value of string>
            memberof-attr: <value of string>
            name: <value of string>
            password: <value of string>
            port: <value of integer>
            profile-attr: <value of string>
            secondary-server: <value of string>
            secure: <value in [disable, starttls, ldaps]>
            server: <value of string>
            tertiary-server: <value of string>
            type: <value in [simple, anonymous, regular]>
            username: <value of string>

'''

RETURN = '''
request_url:
    description: The full url requested
    returned: always
    type: str
    sample: /sys/login/user
response_code:
    description: The status of api request
    returned: always
    type: int
    sample: 0
response_message:
    description: The descriptive message of the api response
    type: str
    returned: always
    sample: OK.

'''
from ansible.module_utils.basic import AnsibleModule
from ansible.module_utils.connection import Connection
from ansible_collections.fortinet.fortimanager.plugins.module_utils.napi import NAPIManager
from ansible_collections.fortinet.fortimanager.plugins.module_utils.napi import check_galaxy_version
from ansible_collections.fortinet.fortimanager.plugins.module_utils.napi import check_parameter_bypass


def main():
    jrpc_urls = [
        '/cli/global/system/admin/ldap'
    ]

    perobject_jrpc_urls = [
        '/cli/global/system/admin/ldap/{ldap}'
    ]

    url_params = []
    module_primary_key = 'name'
    module_arg_spec = {
        'bypass_validation': {
            'type': 'bool',
            'required': False,
            'default': False
        },
        'workspace_locking_adom': {
            'type': 'str',
            'required': False
        },
        'workspace_locking_timeout': {
            'type': 'int',
            'required': False,
            'default': 300
        },
        'rc_succeeded': {
            'required': False,
            'type': 'list'
        },
        'rc_failed': {
            'required': False,
            'type': 'list'
        },
        'state': {
            'type': 'str',
            'required': True,
            'choices': [
                'present',
                'absent'
            ]
        },
        'system_admin_ldap': {
            'required': False,
            'type': 'dict',
            'options': {
                'adom': {
                    'required': False,
                    'type': 'list',
                    'options': {
                        'adom-name': {
                            'required': False,
                            'type': 'str'
                        }
                    }
                },
                'adom-attr': {
                    'required': False,
                    'type': 'str'
                },
                'attributes': {
                    'required': False,
                    'type': 'str'
                },
                'ca-cert': {
                    'required': False,
                    'type': 'str'
                },
                'cnid': {
                    'required': False,
                    'type': 'str'
                },
                'connect-timeout': {
                    'required': False,
                    'type': 'int'
                },
                'dn': {
                    'required': False,
                    'type': 'str'
                },
                'filter': {
                    'required': False,
                    'type': 'str'
                },
                'group': {
                    'required': False,
                    'type': 'str'
                },
                'memberof-attr': {
                    'required': False,
                    'type': 'str'
                },
                'name': {
                    'required': True,
                    'type': 'str'
                },
                'password': {
                    'required': False,
                    'type': 'str'
                },
                'port': {
                    'required': False,
                    'type': 'int'
                },
                'profile-attr': {
                    'required': False,
                    'type': 'str'
                },
                'secondary-server': {
                    'required': False,
                    'type': 'str'
                },
                'secure': {
                    'required': False,
                    'choices': [
                        'disable',
                        'starttls',
                        'ldaps'
                    ],
                    'type': 'str'
                },
                'server': {
                    'required': False,
                    'type': 'str'
                },
                'tertiary-server': {
                    'required': False,
                    'type': 'str'
                },
                'type': {
                    'required': False,
                    'choices': [
                        'simple',
                        'anonymous',
                        'regular'
                    ],
                    'type': 'str'
                },
                'username': {
                    'required': False,
                    'type': 'str'
                }
            }

        }
    }

    params_validation_blob = []
    check_galaxy_version(module_arg_spec)
    module = AnsibleModule(argument_spec=check_parameter_bypass(module_arg_spec, 'system_admin_ldap'),
                           supports_check_mode=False)

    fmgr = None
    if module._socket_path:
        connection = Connection(module._socket_path)
        fmgr = NAPIManager(jrpc_urls, perobject_jrpc_urls, module_primary_key, url_params, module, connection, top_level_schema_name='data')
        fmgr.validate_parameters(params_validation_blob)
        fmgr.process_curd()
    else:
        module.fail_json(msg='MUST RUN IN HTTPAPI MODE')
    module.exit_json(meta=module.params)


if __name__ == '__main__':
    main()
