# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pysentimiento', 'pysentimiento.baselines', 'pysentimiento.lince']

package_data = \
{'': ['*']}

install_requires = \
['datasets>=1.13.3',
 'emoji>=1.6.1,<2.0.0',
 'spacy>=3.5.0,<4.0.0',
 'torch>=1.13.1,<2.0.0',
 'transformers>=4.13.0']

setup_kwargs = {
    'name': 'pysentimiento',
    'version': '0.6.3',
    'description': 'A Transformer-based library for SocialNLP tasks',
    'long_description': '# pysentimiento: A Python toolkit for Sentiment Analysis and Social NLP tasks\n\n![Tests](https://github.com/finiteautomata/pysentimiento/workflows/run_tests/badge.svg)\n\n[![Test it in Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/pysentimiento/pysentimiento/blob/master/notebooks/examples/pysentimiento_sentiment_analysis_in_spanish.ipynb)\n\n<p>\n<a href="https://console.tiyaro.ai/explore?q=pysentimiento/robertuito-&pub=pysentimiento"> <img src="https://tiyaro-public-docs.s3.us-west-2.amazonaws.com/assets/try_on_tiyaro_badge.svg"></a>\n</p>\n\n\n\n\nA Transformer-based library for SocialNLP tasks.\n\nCurrently supports:\n\n\n| Task                 | Languages                             |\n|:---------------------|:---------------------------------------|\n| Sentiment Analysis   | es, en, it, pt                        |\n| Hate Speech Detection| es, en, it, pt                        |\n| Irony Detection      | es, en, it, pt                        |\n| Emotion Analysis     | es, en, it                            |\n| NER & POS tagging    | es, en                                |\n\n\nJust do `pip install pysentimiento` and start using it:\n\n## Getting Started\n\n```python\nfrom pysentimiento import create_analyzer\nanalyzer = create_analyzer(task="sentiment", lang="es")\n\nanalyzer.predict("Qué gran jugador es Messi")\n# returns AnalyzerOutput(output=POS, probas={POS: 0.998, NEG: 0.002, NEU: 0.000})\nanalyzer.predict("Esto es pésimo")\n# returns AnalyzerOutput(output=NEG, probas={NEG: 0.999, POS: 0.001, NEU: 0.000})\nanalyzer.predict("Qué es esto?")\n# returns AnalyzerOutput(output=NEU, probas={NEU: 0.993, NEG: 0.005, POS: 0.002})\n\nanalyzer.predict("jejeje no te creo mucho")\n# AnalyzerOutput(output=NEG, probas={NEG: 0.587, NEU: 0.408, POS: 0.005})\n"""\nEmotion Analysis in English\n"""\n\nemotion_analyzer = create_analyzer(task="emotion", lang="en")\n\nemotion_analyzer.predict("yayyy")\n# returns AnalyzerOutput(output=joy, probas={joy: 0.723, others: 0.198, surprise: 0.038, disgust: 0.011, sadness: 0.011, fear: 0.010, anger: 0.009})\nemotion_analyzer.predict("fuck off")\n# returns AnalyzerOutput(output=anger, probas={anger: 0.798, surprise: 0.055, fear: 0.040, disgust: 0.036, joy: 0.028, others: 0.023, sadness: 0.019})\n\n"""\nHate Speech (misogyny & racism)\n"""\nhate_speech_analyzer = create_analyzer(task="hate_speech", lang="es")\n\nhate_speech_analyzer.predict("Esto es una mierda pero no es odio")\n# returns AnalyzerOutput(output=[], probas={hateful: 0.022, targeted: 0.009, aggressive: 0.018})\nhate_speech_analyzer.predict("Esto es odio porque los inmigrantes deben ser aniquilados")\n# returns AnalyzerOutput(output=[\'hateful\'], probas={hateful: 0.835, targeted: 0.008, aggressive: 0.476})\n\nhate_speech_analyzer.predict("Vaya guarra barata y de poca monta es XXXX!")\n# returns AnalyzerOutput(output=[\'hateful\', \'targeted\', \'aggressive\'], probas={hateful: 0.987, targeted: 0.978, aggressive: 0.969})\n```\n\nSee [TASKS](docs/TASKS.md) for more details on the supported tasks and languages, and also for reported performance for each benchmarked model.\n\nAlso, check these notebooks with examples of how to use `pysentimiento` for each language:\n\n- [Spanish + English](https://colab.research.google.com/github/pysentimiento/pysentimiento/blob/master/notebooks/examples/pysentimiento_sentiment_analysis_in_spanish.ipynb)\n- [Italian](https://colab.research.google.com/github/pysentimiento/pysentimiento/blob/master/notebooks/examples/sentiment_analysis_in_italian.ipynb)\n- [Portuguese](https://colab.research.google.com/github/pysentimiento/pysentimiento/blob/master/notebooks/examples/sentiment_analysis_in_portuguese.ipynb)\n\n## Preprocessing\n\n`pysentimiento` features a tweet preprocessor specially suited for tweet classification with transformer-based models.\n\n```python\nfrom pysentimiento.preprocessing import preprocess_tweet\n\n# Replaces user handles and URLs by special tokens\npreprocess_tweet("@perezjotaeme debería cambiar esto http://bit.ly/sarasa") # "@usuario debería cambiar esto url"\n\n# Shortens repeated characters\npreprocess_tweet("no entiendo naaaaaaaadaaaaaaaa", shorten=2) # "no entiendo naadaa"\n\n# Normalizes laughters\npreprocess_tweet("jajajajaajjajaajajaja no lo puedo creer ajajaj") # "jaja no lo puedo creer jaja"\n\n# Handles hashtags\npreprocess_tweet("esto es #UnaGenialidad")\n# "esto es una genialidad"\n\n# Handles emojis\npreprocess_tweet("🎉🎉", lang="en")\n# \'emoji party popper emoji emoji party popper emoji\'\n```\n\n\n## Instructions for developers\n\n0. Clone and install\n\n```\ngit clone https://github.com/pysentimiento/pysentimiento\npip install poetry\npoetry shell\npoetry install\n```\n\n1. Run script to train models\n\nCheck [TRAIN.md](docs/TRAIN.md) for further information on how to train your models\n\nNote: you need access to the datasets, which are not public for the time being. Send us an email to get access to them.\n\n2. Upload models to Huggingface\'s Model Hub\n\nCheck ["Model sharing and upload"](https://huggingface.co/transformers/model_sharing.html) instructions in `huggingface` docs.\n\n## License\n\n`pysentimiento` is an open-source library. However, please be aware that models are trained with third-party datasets and are subject to their respective licenses, many of which are for non-commercial use\n\n1. [TASS Dataset license](http://tass.sepln.org/tass_data/download.php) (License for Sentiment Analysis in Spanish, Emotion Analysis in Spanish & English)\n2. [SEMEval 2017 Dataset license](https://www.dropbox.com/s/byzr8yoda6bua1b/2017_English_final.zip?file_subpath=%2F2017_English_final%2FDOWNLOAD%2FREADME.txt) (Sentiment Analysis in English)\n\n3. [LinCE Datasets](https://ritual.uh.edu/lince/datasets) (License for NER & POS tagging)\n\n## Suggestions and bugfixes\n\nPlease use the repository [issue tracker](https://github.com/pysentimiento/pysentimiento/issues) to point out bugs and make suggestions (new models, use another datasets, some other languages, etc)\n\n\n## Citation\n\nIf you use `pysentimiento` in your work, please cite [this paper](https://arxiv.org/abs/2106.09462)\n\n```\n@misc{perez2021pysentimiento,\n      title={pysentimiento: A Python Toolkit for Sentiment Analysis and SocialNLP tasks},\n      author={Juan Manuel Pérez and Juan Carlos Giudici and Franco Luque},\n      year={2021},\n      eprint={2106.09462},\n      archivePrefix={arXiv},\n      primaryClass={cs.CL}\n}\n```\n\nAlso, pleace cite related pre-trained models and datasets for the specific models you use. Check [REFERENCES](docs/REFERENCES.md) for details.\n\n',
    'author': 'Juan Manuel Pérez',
    'author_email': 'jmperez@dc.uba.ar',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/pysentimiento/pysentimiento/',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
