"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsIntegration = void 0;
const cdk = require("@aws-cdk/core");
const integration_1 = require("../integration");
const util_1 = require("../util");
/**
 * This type of integration lets an API expose AWS service actions. It is
 * intended for calling all AWS service actions, but is not recommended for
 * calling a Lambda function, because the Lambda custom integration is a legacy
 * technology.
 */
class AwsIntegration extends integration_1.Integration {
    constructor(props) {
        const backend = props.subdomain ? `${props.subdomain}.${props.service}` : props.service;
        const type = props.proxy ? integration_1.IntegrationType.AWS_PROXY : integration_1.IntegrationType.AWS;
        const { apiType, apiValue } = util_1.parseAwsApiCall(props.path, props.action, props.actionParameters);
        super({
            type,
            integrationHttpMethod: props.integrationHttpMethod || 'POST',
            uri: cdk.Lazy.stringValue({ produce: () => {
                    if (!this.scope) {
                        throw new Error('AwsIntegration must be used in API');
                    }
                    return cdk.Stack.of(this.scope).formatArn({
                        service: 'apigateway',
                        account: backend,
                        resource: apiType,
                        sep: '/',
                        resourceName: apiValue,
                    });
                } }),
            options: props.options,
        });
    }
    bind(method) {
        const bindResult = super.bind(method);
        this.scope = method;
        return bindResult;
    }
}
exports.AwsIntegration = AwsIntegration;
//# sourceMappingURL=data:application/json;base64,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