"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/// !cdk-integ pragma:ignore-assets
const iam = require("@aws-cdk/aws-iam");
const lambda = require("@aws-cdk/aws-lambda");
const core_1 = require("@aws-cdk/core");
const path = require("path");
const lib_1 = require("../../lib");
/*
 * Stack verification steps:
 * * `curl -s -o /dev/null -w "%{http_code}" <url>` should return 401
 * * `curl -s -o /dev/null -w "%{http_code}" -H 'Authorization: deny' <url>` should return 403
 * * `curl -s -o /dev/null -w "%{http_code}" -H 'Authorization: allow' <url>` should return 200
 */
const app = new core_1.App();
const stack = new core_1.Stack(app, 'TokenAuthorizerIAMRoleInteg');
const authorizerFn = new lambda.Function(stack, 'MyAuthorizerFunction', {
    runtime: lambda.Runtime.NODEJS_10_X,
    handler: 'index.handler',
    code: lambda.AssetCode.fromAsset(path.join(__dirname, 'integ.token-authorizer.handler')),
});
const role = new iam.Role(stack, 'authorizerRole', {
    assumedBy: new iam.ServicePrincipal('apigateway.amazonaws.com'),
});
const authorizer = new lib_1.TokenAuthorizer(stack, 'MyAuthorizer', {
    handler: authorizerFn,
    assumeRole: role,
});
const restapi = new lib_1.RestApi(stack, 'MyRestApi');
restapi.root.addMethod('ANY', new lib_1.MockIntegration({
    integrationResponses: [
        { statusCode: '200' },
    ],
    passthroughBehavior: lib_1.PassthroughBehavior.NEVER,
    requestTemplates: {
        'application/json': '{ "statusCode": 200 }',
    },
}), {
    methodResponses: [
        { statusCode: '200' },
    ],
    authorizer,
    authorizationType: lib_1.AuthorizationType.CUSTOM,
});
//# sourceMappingURL=data:application/json;base64,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