"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_lambda_1 = require("@aws-cdk/aws-lambda");
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
class LateBoundDeploymentStageStack extends core_1.Stack {
    constructor(scope) {
        super(scope, 'LateBoundDeploymentStageStack');
        const fn = new aws_lambda_1.Function(this, 'myfn', {
            code: aws_lambda_1.Code.fromInline('foo'),
            runtime: aws_lambda_1.Runtime.NODEJS_10_X,
            handler: 'index.handler',
        });
        const api = new lib_1.LambdaRestApi(this, 'lambdarestapi', {
            deploy: false,
            handler: fn,
        });
        api.deploymentStage = new lib_1.Stage(this, 'stage', {
            deployment: new lib_1.Deployment(this, 'deployment', {
                api,
            }),
        });
    }
}
const app = new core_1.App();
new LateBoundDeploymentStageStack(app);
//# sourceMappingURL=data:application/json;base64,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