"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const lambda = require("@aws-cdk/aws-lambda");
const cdk = require("@aws-cdk/core");
const apigw = require("../lib");
class MultiStack extends cdk.Stack {
    constructor(scope, id) {
        super(scope, id);
        const hello = new apigw.LambdaIntegration(new lambda.Function(this, 'Hello', {
            runtime: lambda.Runtime.NODEJS_10_X,
            handler: 'index.handler',
            code: lambda.Code.inline(`exports.handler = ${helloCode}`),
        }));
        const api = new apigw.RestApi(this, 'hello-api');
        api.root.resourceForPath('/hello').addMethod('GET', hello);
        const api2 = new apigw.RestApi(this, 'second-api');
        api2.root.resourceForPath('/hello').addMethod('GET', hello);
    }
}
class MultiApp extends cdk.App {
    constructor() {
        super();
        new MultiStack(this, 'restapi-multiuse-example');
    }
}
function helloCode(_event, _context, callback) {
    return callback(undefined, {
        statusCode: 200,
        body: 'hello, world!',
    });
}
new MultiApp().synth();
//# sourceMappingURL=data:application/json;base64,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