import * as cdk from 'aws-cdk-lib';
import { CustomResource } from 'aws-cdk-lib';
import * as lambda from 'aws-cdk-lib/aws-lambda';
import { AwsCustomResource } from 'aws-cdk-lib/custom-resources';
import { Construct } from 'constructs';
/**
 * @stability stable
 */
export interface ChimeResourceProps extends cdk.ResourceProps {
    /**
     * @stability stable
     */
    readonly properties: {
        [propname: string]: any;
    };
    /**
     * @stability stable
     */
    readonly resourceType: 'PhoneNumber' | 'VoiceConnector' | 'SMA' | 'SMARule' | 'PhoneAssociation';
    /**
     * @stability stable
     */
    readonly uid: string;
}
/**
 * @stability stable
 */
export declare class ChimeResources extends Construct {
    /**
     * @stability stable
     */
    readonly lambda: lambda.IFunction;
    /**
     * @stability stable
     */
    readonly chimeCustomResource: CustomResource;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: ChimeResourceProps);
    private ensureLambda;
}
/**
 * @stability stable
 */
export interface PhoneAssociationProps extends cdk.ResourceProps {
    /**
     * @stability stable
     */
    readonly voiceConnectorId: string;
    /**
     * @stability stable
     */
    readonly e164PhoneNumber: string;
}
/**
 * @stability stable
 */
export declare class PhoneAssociation extends Construct {
    /**
     * @stability stable
     */
    readonly phoneAssociationResource: AwsCustomResource;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: PhoneAssociationProps);
}
