import { Construct } from 'constructs';
import { ChimeVoiceConnector } from '.';
import { PhoneAssociation } from './customResource';
/**
 * @stability stable
 */
export declare enum PhoneNumberType {
    /**
     * @stability stable
     */
    LOCAL = "Local",
    /**
     * @stability stable
     */
    TOLLFREE = "TollFree"
}
/**
 * @stability stable
 */
export declare enum PhoneCountry {
    /**
     * @stability stable
     */
    AU = "AU",
    /**
     * @stability stable
     */
    AT = "AT",
    /**
     * @stability stable
     */
    CA = "CA",
    /**
     * @stability stable
     */
    DK = "DK",
    /**
     * @stability stable
     */
    DE = "DE",
    /**
     * @stability stable
     */
    IE = "IE",
    /**
     * @stability stable
     */
    IT = "IT",
    /**
     * @stability stable
     */
    NZ = "NZ",
    /**
     * @stability stable
     */
    NG = "NG",
    /**
     * @stability stable
     */
    PR = "PR",
    /**
     * @stability stable
     */
    KR = "KR",
    /**
     * @stability stable
     */
    SE = "SE",
    /**
     * @stability stable
     */
    CH = "CH",
    /**
     * @stability stable
     */
    UK = "UK",
    /**
     * @stability stable
     */
    US = "US"
}
/**
 * @stability stable
 */
export declare enum PhoneProductType {
    /**
     * @stability stable
     */
    SMA = "SipMediaApplicationDialIn",
    /**
     * @stability stable
     */
    VC = "VoiceConnector"
}
/**
 * Props for `PhoneNumber`.
 *
 * @stability stable
 */
export interface PhoneNumberProps {
    /**
     * Area Code for phone number request (optional)  - Usable only with US Country.
     *
     * @default - None
     * @stability stable
     */
    readonly phoneAreaCode?: number;
    /**
     * City for phone number request (optional) - Usable only with US Country.
     *
     * @default - None
     * @stability stable
     */
    readonly phoneCity?: string;
    /**
     * State for phone number request (optional) - Usable only with US Country.
     *
     * @default - None
     * @stability stable
     */
    readonly phoneState?: string;
    /**
     * Toll Free Prefix for phone number request (optional).
     *
     * @default - None
     * @stability stable
     */
    readonly phoneNumberTollFreePrefix?: number;
    /**
     * Phone Number Type for phone number request (optional) - Local or TollFree - Required with non-US country.
     *
     * @default - None
     * @stability stable
     */
    readonly phoneNumberType?: PhoneNumberType;
    /**
     * Country for phone number request (optional) - See https://docs.aws.amazon.com/chime/latest/ag/phone-country-reqs.html for more details.
     *
     * @default - US
     * @stability stable
     */
    readonly phoneCountry?: PhoneCountry;
    /**
     * Phone Product Type (required) - SipMediaApplicationDialIn or VoiceConnector.
     *
     * @default - None
     * @stability stable
     */
    readonly phoneProductType: PhoneProductType;
}
/**
 * @stability stable
 */
export declare class ChimePhoneNumber extends Construct {
    /**
     * @stability stable
     */
    readonly phoneNumber: string;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: PhoneNumberProps);
    /**
     * @stability stable
     */
    associateWithVoiceConnector(voiceConnectorId: ChimeVoiceConnector): PhoneAssociation;
    private associateNumber;
}
