import { Function } from 'aws-cdk-lib/aws-lambda';
import { Construct } from 'constructs';
/**
 * Props for `SipMediaApplication`.
 *
 * @stability stable
 */
export interface SipMediaAppProps {
    /**
     * region for SipMediaApplication(required) - Must us-east-1 or us-west-2 and in the same region as the SipMediaApplication Lambda handler.
     *
     * @default - same region as stack deployment
     * @stability stable
     */
    readonly region?: string;
    /**
     * endpoint for SipMediaApplication(required).
     *
     * @default - none
     * @stability stable
     */
    readonly endpoint: Function['functionArn'];
    /**
     * name for SipMediaApplication (optional).
     *
     * @default - unique ID for resource
     * @stability stable
     */
    readonly name?: string;
}
/**
 * @stability stable
 */
export declare class ChimeSipMediaApp extends Construct {
    /**
     * @stability stable
     */
    readonly sipMediaAppId: string;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: SipMediaAppProps);
}
