"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChimeSipMediaApp = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const customResource_1 = require("./customResource");
const sipMediaApplicationValidator_1 = require("./sipMediaApplicationValidator");
/**
 * @stability stable
 */
class ChimeSipMediaApp extends constructs_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id);
        const uid = cdk.Names.uniqueId(this);
        const { name, endpoint, region } = props;
        sipMediaApplicationValidator_1.sipMediaApplicationValidator(props);
        const sipMediaAppRequest = new customResource_1.ChimeResources(this, 'sipMediaAppRequest', {
            resourceType: 'SMA',
            uid: uid,
            properties: {
                region: region || cdk.Stack.of(this).region,
                name: name !== null && name !== void 0 ? name : uid,
                endpoint: endpoint,
            },
        });
        this.sipMediaAppId =
            sipMediaAppRequest.chimeCustomResource.getAttString('sipMediaAppId');
    }
}
exports.ChimeSipMediaApp = ChimeSipMediaApp;
_a = JSII_RTTI_SYMBOL_1;
ChimeSipMediaApp[_a] = { fqn: "cdk-amazon-chime-resources.ChimeSipMediaApp", version: "0.0.7" };
//# sourceMappingURL=data:application/json;base64,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