import { Construct } from 'constructs';
/**
 * @stability stable
 */
export declare enum TriggerType {
    /**
     * @stability stable
     */
    TO_PHONE_NUMBER = "ToPhoneNumber",
    /**
     * @stability stable
     */
    REQUEST_URI_HOSTNAME = "RequestUriHostname"
}
/**
 * @stability stable
 */
export interface TargetApplications {
    /**
     * SipMediaApplicationId for SipRule (required).
     *
     * @default - none
     * @stability stable
     */
    readonly sipMediaApplicationId: string;
    /**
     * Priority for SipRule (required) - 1 to 25.
     *
     * @default - none
     * @stability stable
     */
    readonly priority: number;
    /**
     * Region for SipRule (optional).
     *
     * @default - same region as stack deployment
     * @stability stable
     */
    readonly region?: string;
}
/**
 * Props for `SipRule`.
 *
 * @stability stable
 */
export interface SipRuleProps {
    /**
     * Trigger Type for SipRule (required) - TO_PHONE_NUMBER or REQUEST_URI_HOSTNAME.
     *
     * @default - none
     * @stability stable
     */
    readonly triggerType: TriggerType;
    /**
     * Trigger Value for SipRule (required) - EE.164 Phone Number or Voice Connector URI.
     *
     * @default - none
     * @stability stable
     */
    readonly triggerValue: string;
    /**
     * name for SipRule (optional).
     *
     * @default - unique ID for resource
     * @stability stable
     */
    readonly name?: string;
    /**
     * @stability stable
     */
    readonly targetApplications: Array<TargetApplications>;
}
/**
 * @stability stable
 */
export declare class ChimeSipRule extends Construct {
    /**
     * @stability stable
     */
    readonly sipRuleId: string;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: SipRuleProps);
}
