"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChimeSipRule = exports.TriggerType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const customResource_1 = require("./customResource");
const sipRuleValidator_1 = require("./sipRuleValidator");
/**
 * @stability stable
 */
var TriggerType;
(function (TriggerType) {
    TriggerType["TO_PHONE_NUMBER"] = "ToPhoneNumber";
    TriggerType["REQUEST_URI_HOSTNAME"] = "RequestUriHostname";
})(TriggerType = exports.TriggerType || (exports.TriggerType = {}));
/**
 * @stability stable
 */
class ChimeSipRule extends constructs_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id);
        const uid = cdk.Names.uniqueId(this);
        const { name, triggerType, triggerValue, targetApplications } = props;
        sipRuleValidator_1.sipRuleValidator(props);
        const sipRuleRequest = new customResource_1.ChimeResources(this, 'sipRuleRequest', {
            resourceType: 'SMARule',
            uid: uid,
            properties: {
                name: name !== null && name !== void 0 ? name : uid,
                triggerType: triggerType,
                triggerValue: triggerValue,
                targetApplications: targetApplications,
            },
        });
        this.sipRuleId =
            sipRuleRequest.chimeCustomResource.getAttString('sipRuleId');
    }
}
exports.ChimeSipRule = ChimeSipRule;
_a = JSII_RTTI_SYMBOL_1;
ChimeSipRule[_a] = { fqn: "cdk-amazon-chime-resources.ChimeSipRule", version: "0.0.7" };
//# sourceMappingURL=data:application/json;base64,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