import { Construct } from 'constructs';
/**
 * @stability stable
 */
export declare enum NotificationTargetType {
    /**
     * @stability stable
     */
    EVENTBRIDGE = "EventBridge",
    /**
     * @stability stable
     */
    SNS = "SNS",
    /**
     * @stability stable
     */
    SQS = "SQS"
}
/**
 * @stability stable
 */
export declare enum Protocol {
    /**
     * @stability stable
     */
    TCP = "TCP",
    /**
     * @stability stable
     */
    UDP = "UDP"
}
/**
 * @stability stable
 */
export interface Termination {
    /**
     * Calling Regions for VoiceConnector (optional).
     *
     * @default - ['US']
     * @stability stable
     */
    readonly callingRegions: Array<string>;
    /**
     * termination IP for VoiceConnector (optional).
     *
     * @default - none
     * @stability stable
     */
    readonly terminationCidrs: Array<string>;
}
/**
 * @stability stable
 */
export interface Routes {
    /**
     * @stability stable
     */
    readonly host: string;
    /**
     * @stability stable
     */
    readonly port: number;
    /**
     * @stability stable
     */
    readonly protocol: Protocol;
    /**
     * @stability stable
     */
    readonly priority: number;
    /**
     * @stability stable
     */
    readonly weight: number;
}
/**
 * @stability stable
 */
export interface Streaming {
    /**
     * @stability stable
     */
    readonly enabled: boolean;
    /**
     * Streaming data retention for VoiceConnector.
     *
     * @default - 0
     * @stability stable
     */
    readonly dataRetention: number;
    /**
     * Streaming data retention for VoiceConnector.
     *
     * @default - 0
     * @stability stable
     */
    readonly notificationTargets: Array<NotificationTargetType>;
}
/**
 * Props for `SipMediaApplication`.
 *
 * @stability stable
 */
export interface VoiceConnectorProps {
    /**
     * region for SipMediaApplication(required) - Must us-east-1 or us-west-2 and in the same region as the SipMediaApplication Lambda handler.
     *
     * @default - same region as stack deployment
     * @stability stable
     */
    readonly region?: string;
    /**
     * name for VoiceConnector.
     *
     * @default - unique ID for resource
     * @stability stable
     */
    readonly name?: string;
    /**
     * Encryption boolean for VoiceConnector.
     *
     * @default - False
     * @stability stable
     */
    readonly encryption?: boolean;
    /**
     * @stability stable
     */
    readonly termination?: Termination;
    /**
     * @stability stable
     */
    readonly origination?: Array<Routes>;
    /**
     * @stability stable
     */
    readonly streaming?: Streaming;
}
/**
 * @stability stable
 */
export declare class ChimeVoiceConnector extends Construct {
    /**
     * @stability stable
     */
    readonly voiceConnectorId: string;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: VoiceConnectorProps);
}
