# Generated by Django 2.2.12 on 2022-05-31 15:58

from django.db import migrations, models
import django.db.models.deletion
import otree.db.idmap
import otree.db.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('otree', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Group',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('id_in_subsession', otree.db.models.PositiveIntegerField(db_index=True, null=True)),
                ('round_number', otree.db.models.PositiveIntegerField(db_index=True, null=True)),
                ('session', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='qvsr_group', to='otree.Session')),
            ],
            options={
                'db_table': 'qvsr_group',
            },
            bases=(models.Model, otree.db.idmap.GroupIDMapMixin),
        ),
        migrations.CreateModel(
            name='Subsession',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('round_number', otree.db.models.PositiveIntegerField(db_index=True, null=True)),
                ('session', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='qvsr_subsession', to='otree.Session')),
            ],
            options={
                'db_table': 'qvsr_subsession',
            },
            bases=(models.Model, otree.db.idmap.SubsessionIDMapMixin),
        ),
        migrations.CreateModel(
            name='Player',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('id_in_group', otree.db.models.PositiveIntegerField(db_index=True, null=True)),
                ('_payoff', otree.db.models.CurrencyField(default=0, null=True)),
                ('round_number', otree.db.models.PositiveIntegerField(db_index=True, null=True)),
                ('_role', otree.db.models.StringField(max_length=10000, null=True)),
                ('participant_name', otree.db.models.StringField(max_length=10000, null=True, verbose_name='What is your name?')),
                ('participant_age', otree.db.models.IntegerField(null=True, verbose_name='How old are you?')),
                ('location', otree.db.models.StringField(max_length=10000, null=True, verbose_name='What is your location?')),
                ('q_5', otree.db.models.IntegerField(default=0, null=True, verbose_name='Agricultural products and veterinary services')),
                ('q_1', otree.db.models.IntegerField(default=0, null=True, verbose_name='Job opportunities for youths')),
                ('q_4', otree.db.models.IntegerField(default=0, null=True, verbose_name='Road network')),
                ('q_3', otree.db.models.IntegerField(default=0, null=True, verbose_name='Social Amenities')),
                ('q_2', otree.db.models.IntegerField(default=0, null=True, verbose_name='Water supply in your location')),
                ('group', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='qvsr.Group')),
                ('participant', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='qvsr_player', to='otree.Participant')),
                ('session', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='qvsr_player', to='otree.Session')),
                ('subsession', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='qvsr.Subsession')),
            ],
            options={
                'db_table': 'qvsr_player',
            },
            bases=(models.Model, otree.db.idmap.PlayerIDMapMixin),
        ),
        migrations.AddField(
            model_name='group',
            name='subsession',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='qvsr.Subsession'),
        ),
    ]
