"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.copyDirectory = void 0;
const fs = require("fs");
const path = require("path");
const options_1 = require("./options");
const utils_1 = require("./utils");
function copyDirectory(srcDir, destDir, options = {}, rootDir) {
    const follow = options.follow !== undefined ? options.follow : options_1.SymlinkFollowMode.EXTERNAL;
    const exclude = options.exclude || [];
    rootDir = rootDir || srcDir;
    if (!fs.statSync(srcDir).isDirectory()) {
        throw new Error(`${srcDir} is not a directory`);
    }
    const files = fs.readdirSync(srcDir);
    for (const file of files) {
        const sourceFilePath = path.join(srcDir, file);
        if (utils_1.shouldExclude(exclude, path.relative(rootDir, sourceFilePath))) {
            continue;
        }
        const destFilePath = path.join(destDir, file);
        let stat = follow === options_1.SymlinkFollowMode.ALWAYS
            ? fs.statSync(sourceFilePath)
            : fs.lstatSync(sourceFilePath);
        if (stat && stat.isSymbolicLink()) {
            const target = fs.readlinkSync(sourceFilePath);
            // determine if this is an external link (i.e. the target's absolute path
            // is outside of the root directory).
            const targetPath = path.normalize(path.resolve(srcDir, target));
            if (utils_1.shouldFollow(follow, rootDir, targetPath)) {
                stat = fs.statSync(sourceFilePath);
            }
            else {
                fs.symlinkSync(target, destFilePath);
                stat = undefined;
            }
        }
        if (stat && stat.isDirectory()) {
            fs.mkdirSync(destFilePath);
            copyDirectory(sourceFilePath, destFilePath, options, rootDir);
            stat = undefined;
        }
        if (stat && stat.isFile()) {
            fs.copyFileSync(sourceFilePath, destFilePath);
            stat = undefined;
        }
    }
}
exports.copyDirectory = copyDirectory;
//# sourceMappingURL=data:application/json;base64,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