import os
import shutil
import sys
import tempfile
from contextlib import contextmanager
import shutil 

from scrapy.utils.misc import load_object

from scrapyd import Config
from scrapyd.eggutils import activate_egg , activate_scrapycfg


@contextmanager
def project_environment(project):
    eggversion = os.environ.get('SCRAPY_EGG_VERSION', None)
    config = Config()
    eggstorage_path = config.get(
        'eggstorage', 'scrapyd.eggstorage.FilesystemEggStorage'
    )
    eggstorage_cls = load_object(eggstorage_path)
    eggstorage = eggstorage_cls(config)

    version, eggfile = eggstorage.get(project, eggversion)
    if eggfile:
        prefix = '%s-%s-' % (project, version)
        fd, eggpath = tempfile.mkstemp(prefix=prefix, suffix='.egg')
        lf = os.fdopen(fd, 'wb')
        extrpath = os.path.dirname(eggpath) + '%s-%s' % (project, version)

        shutil.copyfileobj(eggfile, lf)
        lf.close()
        activate_egg(eggpath)
        activate_scrapycfg(eggpath,extrpath)
    else:
        eggpath = None
    try:
        assert 'scrapy.conf' not in sys.modules, "Scrapy settings already loaded"
        yield
    finally:
        # pass
        if eggpath:
            os.remove(eggpath)
        if extrpath:
            shutil.rmtree(extrpath)



def main():
    # project = os.environ['SCRAPY_PROJECT']
    project = "de-xccnews"
    with project_environment(project):
        from scrapy.cmdline import execute
        execute()


if __name__ == '__main__':
    main()
