# Generated by Django 3.2.3 on 2021-05-30 11:57

from django.db import migrations, models
import django.db.models.deletion
import pgcrypto.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Database',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('handle', models.SlugField(help_text='Set a unique name for this database', max_length=200)),
                ('source', models.IntegerField(choices=[(0, 'PostgreSQL'), (1, 'Microsoft SQL'), (2, 'MySQL/MariaDB'), (3, 'SQLite'), (4, 'FireBird')], help_text='Select what kind of SQL database this is')),
                ('config', pgcrypto.fields.EncryptedTextField(charset='utf-8', check_armor=True, cipher='aes', help_text='Set connection information and credentials', max_length=1000, versioned=False)),
                ('description', models.CharField(help_text='Describe what this database is all about', max_length=200)),
            ],
        ),
        migrations.CreateModel(
            name='SourceTable',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('source_table', models.CharField(max_length=200)),
                ('description', models.CharField(blank=True, max_length=500)),
                ('source_database', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='reflector.database')),
            ],
        ),
        migrations.CreateModel(
            name='Reflection',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('description', models.CharField(max_length=500)),
                ('destination_table', models.CharField(max_length=500)),
                ('last_commit', models.IntegerField(blank=True, help_text='id of last pdr_event executed', null=True)),
                ('last_updated', models.DateTimeField(blank=True, null=True)),
                ('active', models.BooleanField(default=True, help_text='Means that the reflection will be updated whenever the source table is updated', verbose_name='Active')),
                ('ignore_delete_events', models.BooleanField(default=True, help_text="Don't delete records in the reflection when they're deleted in the source.", verbose_name='Ignore Delete Events')),
                ('source_fields', models.CharField(help_text='json representation of the structure of thesource table (read only)', max_length=10000)),
                ('destination_fields', models.CharField(help_text='json configuration that represents the translation from source data to destination structure', max_length=10000)),
                ('reflection_statment', models.CharField(help_text='SQL statment that will be used to input the data into the destination table whenever the source changes', max_length=10000)),
                ('destination_database', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='reflector.database')),
                ('source_table', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='reflector.sourcetable')),
            ],
        ),
    ]
