"""
Задание 4: Алгоритмы и структуры данных
Функция, которая принимает список чисел и сортирует его 
по убыванию, используя алгоритм сортировки пузырьком.
"""

def bubble_sort_descending(numbers):
    """
    Сортировка списка чисел по убыванию с помощью алгоритма пузырька
    
    Алгоритм:
    1. Проходим по списку n-1 раз, где n - длина списка
    2. На каждой итерации сравниваем соседние элементы
    3. Если левый элемент меньше правого, меняем их местами
    4. После первой итерации самый маленький элемент оказывается в конце
    5. Повторяем, пока весь список не будет отсортирован
    """
    n = len(numbers)
    
    # Выводим исходный список
    print(f"Исходный список: {numbers}")
    
    # Внешний цикл - количество проходов
    for i in range(n):
        # Флаг, который показывает, были ли перестановки на текущем проходе
        swapped = False
        
        # Внутренний цикл - сравнение пар элементов
        # С каждым проходом уменьшаем диапазон, т.к. последние i элементов уже отсортированы
        for j in range(0, n - i - 1):
            # Для сортировки по убыванию меняем знак сравнения на <
            if numbers[j] < numbers[j + 1]:
                # Меняем элементы местами
                numbers[j], numbers[j + 1] = numbers[j + 1], numbers[j]
                swapped = True
                print(f"Замена: {numbers}")
        
        # Если на текущем проходе не было перестановок, список уже отсортирован
        if not swapped:
            break
    
    return numbers

def main():
    print("Программа для сортировки списка чисел по убыванию")
    
    # Ввод списка чисел
    try:
        input_str = input("Введите числа через пробел: ")
        numbers = [int(x) for x in input_str.split()]
        
        if not numbers:
            print("Список пуст.")
            return
        
        # Сортировка списка
        sorted_numbers = bubble_sort_descending(numbers)
        
        # Вывод результата
        print(f"\nОтсортированный список по убыванию: {sorted_numbers}")
        
    except ValueError:
        print("Ошибка! Введите только числа, разделенные пробелами.")

# Запускаем программу
if __name__ == "__main__":
    main() 