from django.contrib import admin

# Register your models here.
from bigsansar.contrib.sites.forms import create_domainform, customaddpageform, custompageform
from bigsansar.contrib.sites.models import domains, pages


class domainadmin(admin.ModelAdmin):
    form = create_domainform
    list_display = ['domain', 'publish_date', 'visitor']


class pageadmin(admin.ModelAdmin):
    add_form = customaddpageform
    form = custompageform
    prepopulated_fields = {"slug": ("title",)}
    list_display = ['title', 'domain', 'publish_date', 'visitor']

    def get_form(self, request, obj=None, **kwargs):
        """
        Use special form during foo creation
        """
        defaults = {}
        if obj is None:
            defaults['form'] = self.add_form
        defaults.update(kwargs)
        return super().get_form(request, obj, **defaults)


admin.site.register(domains, domainadmin)
admin.site.register(pages, pageadmin)