import os

from django.contrib.auth.models import User
from django.db import models

# Create your models here.
from django.urls import reverse


class domains(models.Model):
    user = models.ForeignKey(User, on_delete=models.CASCADE)
    domain = models.CharField(max_length=100, unique=True)
    publish_date = models.DateField(auto_now_add=True)
    visitor = models.IntegerField(default=1)

    def __str__(self):
        return self.domain

    class Meta:
        verbose_name = 'Domain'
        verbose_name_plural = 'Custom Domain'

    def get_absolute_url(self):
        return "http://%s" % (self.domain,)



class pages(models.Model):
    domain = models.ForeignKey(domains, on_delete=models.CASCADE)
    title = models.CharField(max_length=50)
    slug = models.SlugField()
    body = models.TextField()
    visitor = models.IntegerField(default=0)
    publish_date = models.DateField(auto_now_add=True)

    class Meta:
        verbose_name = 'Pages'
        verbose_name_plural = 'Pages'

    def __str__(self):
        return self.domain.domain

    def get_absolute_url(self):
        path = reverse('path', args=[self.slug])
        return "http://%s%s" % (self.domain, path)

    def delete(self, using=None, keep_parents=False):
        getdir = 'home'
        filename = getdir + '/' + str(self.domain.user) + '/' + str(self.domain) + '/' + self.slug + '.html'
        print(filename)

        try:
            os.remove(filename)

        except OSError:
            pass

        super().delete()

