import os

def initsetup():

    if os.path.isdir('www') == True:

        print('Folder www already exits. please delete first www folder and manage.py file.')

    else:
        cmd = 'django-admin startproject www .'
        print('creating a server .............')
        os.system(cmd)
        print('please wait...')

        createfile = 'VirtualHost.py'
        get_content = "virtual_hosts = {" \
                      "\n   'test.com:8000': 'www.urls'," \
                      "\n   'example.com:8000': 'ex.urls'," \
                      "\n}"

        print('we are creating files...')
        f = open(createfile, "w")
        print(f)
        f.write(get_content)
        f.close()

        word = 'INSTALLED_APPS'
        middletext = 'MIDDLEWARE = ['
        hostallow = 'ALLOWED_HOSTS = []'
        ROOT_Url = "ROOT_URLCONF = 'www.urls'"
        home_dirs = "'DIRS': [],"
        with open('www/settings.py', 'r') as fp:
            # read all lines in a list
            lines = fp.readlines()
            count = 0
            f = open('www/settings.py', 'w')

            for line in lines:
                # check if string present on a current line
                if line.find(word) != -1:
                    count += 1
                    print('Installing Module in to', word)
                    x = lines.index(line) + count
                    print('Finding the Line Number:', x)
                    print('Inserting bigsansar module in to', line)

                    code = "    'bigsansar.apps.BigsansarConfig'," \
                           "\n" \
                           "    'bigsansar.contrib.account.apps.AccountConfig'," \
                           "\n" \
                           "    'bigsansar.contrib.sites.apps.SitesConfig'," \
                           "\n"

                    lines.insert(x, code)

                elif line.find(middletext) != -1:

                    print('Reading the lines', middletext)
                    xy = lines.index(line) + 1
                    print('Finding the Line Number:', xy)
                    print('Inserting bigsansar virtualhost middleware  in to', line)

                    middlecode = "    'bigsansar.core.host.VirtualHostMiddleware'," \
                                 "\n"
                    lines.insert(xy, middlecode)

                elif line.find(hostallow) != -1:
                    xyz = lines.index(line)

                    # delete lines
                    del lines[xyz]

                    hostcode = "ALLOWED_HOSTS = ['*']" \
                               "\n" \
                               "\n" \
                               "# this is only for development mode" \
                               "\n" \
                               "EMAIL_BACKEND = 'django.core.mail.backends.console.EmailBackend'" \
                               "\n" \
                               "\n" \
                               "ROOT_URLCONF = 'bigsansar.urls'" \
                               "\n" \
                               "\n" \
                               "#SECURE_SSL_REDIRECT = True" \
                               "\n"

                    lines.insert(xyz, hostcode)

                elif line.find(ROOT_Url) != -1:
                    rooturlindex = lines.index(line)

                    #delete lines
                    del lines[rooturlindex]

                elif line.find(home_dirs) != -1:
                    getlinetemplate = lines.index(line)

                    # delete line for new setup
                    del lines[getlinetemplate]

                    newhomedirs = "        'DIRS': ['home']," \
                                  "\n"

                    lines.insert(getlinetemplate, newhomedirs)

            contents = "".join(lines)
            f.write(contents)
            f.close()

        # Open a file with access mode 'a'
        with open("www/urls.py", "a") as file_object:
            # Append 'hello' at the end of file
            file_object.write(''
                              '\n'
                              'admin.site.site_header = "BIGSANSAR"'
                              '\n'
                              'admin.site.site_title = "Bigsansar"'
                              '\n'
                              'admin.site.index_title = "This is a admin panel"'
                              '\n')
            # Close the file
            file_object.close()

        migrate = 'python3 manage.py migrate'
        os.system(migrate)

        print('Finished')
