import datetime
from django.contrib.sites.shortcuts import get_current_site
from django.http import HttpResponse
from django.shortcuts import render
from django.template import loader

from bigsansar.contrib.sites.models import domains, pages

DEFAULT_TEMPLATE = 'default.html'


def index(request):
    try:
        current_site = get_current_site(request)
        db = domains.objects.get(domain=current_site)
        get_visitor_count = db.visitor
        total = get_visitor_count + 1
        domains.objects.filter(pk=db.id).update(visitor=total)


    except:
        current_site = get_current_site(request)
        time = datetime.datetime.now()
        return render(request, 'parking.html', {'domain': current_site, 'time': time})

    else:
        asp = str(db.user) + '/' + str(current_site) + '/' + 'index.html'
        template = loader.select_template((asp, DEFAULT_TEMPLATE))

        return HttpResponse(template.render({}, request))


def pathviews(request, url):
    default_page = 'defaultpage.html'

    try:
        current_site = get_current_site(request)
        db = domains.objects.get(domain=current_site)
        get_pagename = url.strip('/')
        page = pages.objects.get(domain=db, slug=get_pagename)
        total = db.visitor + 1
        pagetotal = page.visitor + 1
        domains.objects.filter(pk=db.id).update(visitor=total)
        pages.objects.filter(domain=db, slug=get_pagename).update(visitor=pagetotal)

    except:

        return render(request, '404.html')

    else:
        asp = str(db.user) + '/' + str(current_site) + '/' + page.slug + '.html'
        template = loader.select_template((asp, default_page))
        return HttpResponse(template.render({'path': url}, request))
