import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataSnowflakeTasksConfig extends cdktf.TerraformMetaArguments {
    /**
    * The database from which to return the schemas from.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/d/tasks#database DataSnowflakeTasks#database}
    */
    readonly database: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/d/tasks#id DataSnowflakeTasks#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The schema from which to return the tasks from.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/d/tasks#schema DataSnowflakeTasks#schema}
    */
    readonly schema: string;
}
export interface DataSnowflakeTasksTasks {
}
export declare function dataSnowflakeTasksTasksToTerraform(struct?: DataSnowflakeTasksTasks): any;
export declare class DataSnowflakeTasksTasksOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeTasksTasks | undefined;
    set internalValue(value: DataSnowflakeTasksTasks | undefined);
    get comment(): string;
    get database(): string;
    get name(): string;
    get schema(): string;
    get warehouse(): string;
}
export declare class DataSnowflakeTasksTasksList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeTasksTasksOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/d/tasks snowflake_tasks}
*/
export declare class DataSnowflakeTasks extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "snowflake_tasks";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/d/tasks snowflake_tasks} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataSnowflakeTasksConfig
    */
    constructor(scope: Construct, id: string, config: DataSnowflakeTasksConfig);
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    get schemaInput(): string | undefined;
    private _tasks;
    get tasks(): DataSnowflakeTasksTasksList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
