import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TaskConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies the predecessor task in the same database and schema of the current task. When a run of the predecessor task finishes successfully, it triggers this task (after a brief lag). (Conflict with schedule)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/task#after Task#after}
    */
    readonly after?: string;
    /**
    * Specifies a comment for the task.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/task#comment Task#comment}
    */
    readonly comment?: string;
    /**
    * The database in which to create the task.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/task#database Task#database}
    */
    readonly database: string;
    /**
    * Specifies if the task should be started (enabled) after creation or should remain suspended (default).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/task#enabled Task#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Specifies the name of the notification integration used for error notifications.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/task#error_integration Task#error_integration}
    */
    readonly errorIntegration?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/task#id Task#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specifies the identifier for the task; must be unique for the database and schema in which the task is created.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/task#name Task#name}
    */
    readonly name: string;
    /**
    * The schedule for periodically running the task. This can be a cron or interval in minutes. (Conflict with after)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/task#schedule Task#schedule}
    */
    readonly schedule?: string;
    /**
    * The schema in which to create the task.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/task#schema Task#schema}
    */
    readonly schema: string;
    /**
    * Specifies session parameters to set for the session when the task runs. A task supports all session parameters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/task#session_parameters Task#session_parameters}
    */
    readonly sessionParameters?: {
        [key: string]: string;
    };
    /**
    * Any single SQL statement, or a call to a stored procedure, executed when the task runs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/task#sql_statement Task#sql_statement}
    */
    readonly sqlStatement: string;
    /**
    * Specifies the size of the compute resources to provision for the first run of the task, before a task history is available for Snowflake to determine an ideal size. Once a task has successfully completed a few runs, Snowflake ignores this parameter setting. (Conflicts with warehouse)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/task#user_task_managed_initial_warehouse_size Task#user_task_managed_initial_warehouse_size}
    */
    readonly userTaskManagedInitialWarehouseSize?: string;
    /**
    * Specifies the time limit on a single run of the task before it times out (in milliseconds).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/task#user_task_timeout_ms Task#user_task_timeout_ms}
    */
    readonly userTaskTimeoutMs?: number;
    /**
    * The warehouse the task will use. Omit this parameter to use Snowflake-managed compute resources for runs of this task. (Conflicts with user_task_managed_initial_warehouse_size)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/task#warehouse Task#warehouse}
    */
    readonly warehouse?: string;
    /**
    * Specifies a Boolean SQL expression; multiple conditions joined with AND/OR are supported.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/task#when Task#when}
    */
    readonly when?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/task snowflake_task}
*/
export declare class Task extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_task";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/task snowflake_task} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TaskConfig
    */
    constructor(scope: Construct, id: string, config: TaskConfig);
    private _after?;
    get after(): string;
    set after(value: string);
    resetAfter(): void;
    get afterInput(): string | undefined;
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _errorIntegration?;
    get errorIntegration(): string;
    set errorIntegration(value: string);
    resetErrorIntegration(): void;
    get errorIntegrationInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _schedule?;
    get schedule(): string;
    set schedule(value: string);
    resetSchedule(): void;
    get scheduleInput(): string | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    get schemaInput(): string | undefined;
    private _sessionParameters?;
    get sessionParameters(): {
        [key: string]: string;
    };
    set sessionParameters(value: {
        [key: string]: string;
    });
    resetSessionParameters(): void;
    get sessionParametersInput(): {
        [key: string]: string;
    } | undefined;
    private _sqlStatement?;
    get sqlStatement(): string;
    set sqlStatement(value: string);
    get sqlStatementInput(): string | undefined;
    private _userTaskManagedInitialWarehouseSize?;
    get userTaskManagedInitialWarehouseSize(): string;
    set userTaskManagedInitialWarehouseSize(value: string);
    resetUserTaskManagedInitialWarehouseSize(): void;
    get userTaskManagedInitialWarehouseSizeInput(): string | undefined;
    private _userTaskTimeoutMs?;
    get userTaskTimeoutMs(): number;
    set userTaskTimeoutMs(value: number);
    resetUserTaskTimeoutMs(): void;
    get userTaskTimeoutMsInput(): number | undefined;
    private _warehouse?;
    get warehouse(): string;
    set warehouse(value: string);
    resetWarehouse(): void;
    get warehouseInput(): string | undefined;
    private _when?;
    get when(): string;
    set when(value: string);
    resetWhen(): void;
    get whenInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
