"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SecureLogBucket = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const s3 = require("aws-cdk-lib/aws-s3");
const aws_secure_bucket_1 = require("aws-secure-bucket");
class SecureLogBucket extends aws_secure_bucket_1.SecureBucket {
    constructor(scope, id, props) {
        super(scope, id, {
            bucketName: props?.bucketName,
            encryption: aws_secure_bucket_1.SecureBucketEncryption.KMS_MANAGED,
            lifecycleRules: [{
                    id: 'archive-step-lifecycle-rule',
                    enabled: true,
                    transitions: [
                        {
                            storageClass: s3.StorageClass.INFREQUENT_ACCESS,
                            transitionAfter: cdk.Duration.days(props?.changeClassTransition?.infrequentAccessDays ?? 60),
                        },
                        {
                            storageClass: s3.StorageClass.INTELLIGENT_TIERING,
                            transitionAfter: cdk.Duration.days(props?.changeClassTransition?.intelligentTieringDays ?? 120),
                        },
                        {
                            storageClass: s3.StorageClass.GLACIER,
                            transitionAfter: cdk.Duration.days(props?.changeClassTransition?.glacierDays ?? 180),
                        },
                        {
                            storageClass: s3.StorageClass.DEEP_ARCHIVE,
                            transitionAfter: cdk.Duration.days(props?.changeClassTransition?.deepArchiveDays ?? 360),
                        },
                    ],
                }],
        });
    }
}
exports.SecureLogBucket = SecureLogBucket;
_a = JSII_RTTI_SYMBOL_1;
SecureLogBucket[_a] = { fqn: "aws-secure-log-bucket.SecureLogBucket", version: "0.8.3" };
//# sourceMappingURL=data:application/json;base64,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