"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BaseListener = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cxschema = require("@aws-cdk/cloud-assembly-schema");
const core_1 = require("@aws-cdk/core");
const elasticloadbalancingv2_generated_1 = require("../elasticloadbalancingv2.generated");
const util_1 = require("./util");
/**
 * Base class for listeners.
 *
 * @stability stable
 */
class BaseListener extends core_1.Resource {
    /**
     * @stability stable
     */
    constructor(scope, id, additionalProps) {
        super(scope, id);
        const resource = new elasticloadbalancingv2_generated_1.CfnListener(this, 'Resource', {
            ...additionalProps,
            defaultActions: core_1.Lazy.any({ produce: () => { var _b, _c; return (_c = (_b = this.defaultAction) === null || _b === void 0 ? void 0 : _b.renderActions()) !== null && _c !== void 0 ? _c : []; } }),
        });
        this.listenerArn = resource.ref;
    }
    /**
     * Queries the load balancer listener context provider for load balancer
     * listener info.
     * @internal
     */
    static _queryContextProvider(scope, options) {
        var _b;
        if (core_1.Token.isUnresolved(options.userOptions.loadBalancerArn)
            || Object.values((_b = options.userOptions.loadBalancerTags) !== null && _b !== void 0 ? _b : {}).some(core_1.Token.isUnresolved)
            || core_1.Token.isUnresolved(options.userOptions.listenerPort)) {
            throw new Error('All arguments to look up a load balancer listener must be concrete (no Tokens)');
        }
        let cxschemaTags;
        if (options.userOptions.loadBalancerTags) {
            cxschemaTags = util_1.mapTagMapToCxschema(options.userOptions.loadBalancerTags);
        }
        const props = core_1.ContextProvider.getValue(scope, {
            provider: cxschema.ContextProvider.LOAD_BALANCER_LISTENER_PROVIDER,
            props: {
                listenerArn: options.listenerArn,
                listenerPort: options.userOptions.listenerPort,
                listenerProtocol: options.listenerProtocol,
                loadBalancerArn: options.userOptions.loadBalancerArn,
                loadBalancerTags: cxschemaTags,
                loadBalancerType: options.loadBalancerType,
            },
            dummyValue: {
                listenerArn: `arn:aws:elasticloadbalancing:us-west-2:123456789012:listener/${options.loadBalancerType}/my-load-balancer/50dc6c495c0c9188/f2f7dc8efc522ab2`,
                listenerPort: 80,
                securityGroupIds: ['sg-123456789012'],
            },
        }).value;
        return props;
    }
    /**
     * Validate this listener.
     *
     * @stability stable
     */
    validate() {
        if (!this.defaultAction) {
            return ['Listener needs at least one default action or target group (call addTargetGroups or addAction)'];
        }
        return [];
    }
    /**
     * Configure the default action
     *
     * @internal
     */
    _setDefaultAction(action) {
        // It might make sense to 'throw' here.
        //
        // However, programs may already exist out there which configured an action twice,
        // in which case the second action accidentally overwrite the initial action, and in some
        // way ended up with a program that did what the author intended. If we were to add throw now,
        // the previously working program would be broken.
        //
        // Instead, signal this through a warning.
        // @deprecate: upon the next major version bump, replace this with a `throw`
        if (this.defaultAction) {
            core_1.Annotations.of(this).addWarning('A default Action already existed on this Listener and was replaced. Configure exactly one default Action.');
        }
        this.defaultAction = action;
    }
}
exports.BaseListener = BaseListener;
_a = JSII_RTTI_SYMBOL_1;
BaseListener[_a] = { fqn: "@aws-cdk/aws-elasticloadbalancingv2.BaseListener", version: "1.142.0" };
//# sourceMappingURL=data:application/json;base64,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