# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['granite', 'granite.lib']

package_data = \
{'': ['*']}

install_requires = \
['bitarray>=1.2.0',
 'h5py>=2.10.0',
 'matplotlib==3.3.4',
 'numpy>=1.18.0',
 'pysam>=0.15.0',
 'pytabix>=0.0.2']

entry_points = \
{'console_scripts': ['granite = granite.granite:main']}

setup_kwargs = {
    'name': 'granite-suite',
    'version': '0.2.0',
    'description': 'granite is a collection of software to call, filter and work with genomic variants.',
    'long_description': '# granite\n\n[![Python 3.6+](https://img.shields.io/badge/Python-3.6+-blue.svg)](https://www.python.org) ![License MIT](https://img.shields.io/badge/License-MIT-green)\n\ngranite is a collection of software to work with genomic variants. The suite provides inheritance mode callers and utilities to filter and refine variants called by other methods in VCF format.\n\ngranite library can also be used through an API to manipulate files in VCF format.\n\nFor more details, see granite [*documentation*](https://granite-suite.readthedocs.io/en/latest/ "granite documentation").\n\n## Availability and requirements\nA ready-to-use docker image is available to download.\n\n    docker pull b3rse/granite:<version>\n\nTo run locally, install the following libraries:\n\n    pip install numpy pysam bitarray h5py matplotlib\n    pip install --user pytabix\n\nAdditional software needs to be available in the environment:\n\n  - [*samtools*](http://www.htslib.org/ "samtools documentation")\n  - [*bgzip*](http://www.htslib.org/doc/bgzip.1.html "bgzip documentation")\n  - [*tabix*](http://www.htslib.org/doc/tabix.1.html "tabix documentation")\n\nTo install the program from source, run the following commands:\n\n    git clone https://github.com/dbmi-bgm/granite\n    cd granite\n    make configure && make build\n\nTo install the program with pip:\n\n    pip install granite-suite\n\n## File formats\nThe program is compatible with standard BED, BAM and VCF formats (`VCFv4.x`).\n\n### ReadCountKeeper (.rck)\nRCK is a tabular format that allows to efficiently store counts by strand (ForWard-ReVerse) for reads that support REFerence allele, ALTernate alleles, INSertions or DELetions at CHRomosome and POSition. RCK files can be further compressed with *bgzip* and indexed with *tabix* for storage, portability and faster random access. 1-based.\n\nTabular format structure:\n\n    #CHR   POS   COVERAGE   REF_FW   REF_RV   ALT_FW   ALT_RV   INS_FW   INS_RV   DEL_FW   DEL_REV\n    13     1     23         0        0        11       12       0        0        0        0\n    13     2     35         18       15       1        1        0        0        0        0\n\nCommands to compress and index files:\n\n    bgzip PATH/TO/FILE\n    tabix -b 2 -s 1 -e 0 -c "#" PATH/TO/FILE.gz\n\n### BinaryIndexGenome (.big)\nBIG is a hdf5-based binary format that stores boolean values for each genomic position as bit arrays. Each position is represented in three complementary arrays that account for SNVs (Single-Nucleotide Variants), insertions and deletions respectively. 1-based.\n\nhdf5 format structure:\n\n    e.g.\n    chr1_snv: array(bool)\n    chr1_ins: array(bool)\n    chr1_del: array(bool)\n    chr2_snv: array(bool)\n    ...\n    ...\n    chrM_del: array(bool)\n\n*note*: hdf5 keys are built as the chromosome name based on reference (e.g. chr1) plus the suffix specifying whether the array represents SNVs (_snv), insertions (_ins) or deletions (_del).\n\n### Pedigree in JSON format\nWhen the program requires pedigree information, the expected format is as follow:\n\n    [\n      {\n        "individual": "NA12877",\n        "sample_name": "NA12877_sample",\n        "gender": "M",\n        "parents": []\n      },\n      {\n        "individual": "NA12878",\n        "sample_name": "NA12878_sample",\n        "gender": "F",\n        "parents": []\n      },\n      {\n        "individual": "NA12879",\n        "sample_name": "NA12879_sample",\n        "gender": "F",\n        "parents": ["NA12878", "NA12877"]\n      }\n    ]\n\nwhere `individual` is the unique identifier for member inside the pedigree, `sample_name` is the corresponding sample ID in VCF file, and `parents` is the list of unique identifiers for member parents if any.\n\n## Usage\n```text\n    granite <command> ...\n\n    positional arguments:\n      <command>\n        novoCaller   Bayesian de novo variant caller\n        comHet       compound heterozygous variant caller\n        mpileupCounts\n                     samtools wrapper to calculate reads statistics for pileup at\n                     each position\n        blackList    utility to blacklist and filter out variants from input VCF\n                     file based on positions set in BIG format file and/or\n                     population allele frequency\n        whiteList    utility to whitelist and select a subset of variants from\n                     input VCF file based on specified annotations and positions\n        cleanVCF     utility to clean INFO field of input VCF file\n        geneList     utility to clean VEP annotations of input VCF file using a\n                     list of genes\n        toBig        utility that converts counts from bgzip and tabix indexed RCK\n                     format into BIG format. Positions are "called" by reads\n                     counts or allelic balance for single or multiple files (joint\n                     calls) in specified regions\n        rckTar       utility to create a tar archive from bgzip and tabix indexed\n                     RCK files. Creates an index file for the archive\n        qcVCF        utility to create a report of different metrics calculated\n                     for input VCF file\n        validateVCF  utility to calculate error models for input VCF file using\n                     pedigree information\n```\n\n### novoCaller\nnovoCaller is a Bayesian calling algorithm for *de novo* mutations. The model uses read-level information both in pedigree (trio) and unrelated samples to rank and assign a probabilty to each call. The software represents an updated and improved implementation of the original algorithm described in [Mohanty et al. 2019](https://academic.oup.com/bioinformatics/advance-article/doi/10.1093/bioinformatics/bty749/5087716).\n\n### comHet\ncomHet is a calling algorithm for *compound heterozygous* mutations. The model uses genotype-level information in pedigree (trio) and VEP-based annotations to call possible compound heterozygous pairs. VEP annotations are used to assign variants to genes and transcripts, genotype information allows to refine calls based on inheritance mode. Calls are further flagged as "Phased" or "Unphased", where "Phased" means that genotype information supports in-trans inheritance for alternate alleles from parents.\n\n### blackList\nblackList allows to filter-out variants from input VCF file based on positions set in BIG format file and/or provided population allele frequency.\n\n### whiteList\nwhiteList allows to select and filter-in a subset of variants from input VCF file based on specified annotations and positions. The software can use provided VEP, ClinVar or SpliceAI annotations. Positions can be also specfied as a BED format file.\n\n### cleanVCF\ncleanVCF allows to clean INFO field of input VCF file. The software can remove a list of TAG from INFO field, or can be used to clean VEP annotations.\n\n### geneList\ngeneList allows to clean VEP annotations by applyng a list of genes. The software removes all the transcripts that do not map to a gene on the list.\n\n### qcVCF\nqcVCF produces a report in JSON format with different quality metrics calculated for input VCF file. Both single sample and family-based metrics are available.\n\n### mpileupCounts\nmpileupCounts uses *samtools* to access input BAM and calculates statistics for reads pileup at each position in the specified region, returns counts in RCK format.\n\n### toBig\ntoBig converts counts from bgzip and tabix indexed RCK format into BIG format. Positions are "called" by read counts or allelic balance for single or multiple files (joint calls) in specified regions. Positions "called" are set to True (or 1) in BIG binary structure.\n\n### rckTar\nrckTar creates a tar archive from bgzip and tabix indexed RCK files. Creates an index file for the archive.\n\n### validateVCF\nvalidateVCF allows to calculate error models for different inheritance modes for input VCF file using pedigree information.\n\n## WARNINGS\n\n!! starting from 0.1.12, novoCaller `--triofiles` expected order changed. Now PROBAND must be listed as first.\n',
    'author': 'Michele Berselli',
    'author_email': 'berselli.michele@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/dbmi-bgm/granite',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
