# Generated by Django 3.1.12 on 2021-06-25 23:35

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('sites', '0002_alter_domain_unique'),
    ]

    operations = [
        migrations.CreateModel(
            name='SiteConfigKeyModel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('label', models.CharField(max_length=120, unique=True, verbose_name='Key Label')),
                ('key', models.SlugField(blank=True, editable=False, unique=True, verbose_name='Key')),
                ('schema', models.JSONField(blank=True, default=dict, null=True, verbose_name='Schema')),
                ('deleted', models.BooleanField(default=False, help_text='Soft Deleted?', verbose_name='Deleted')),
                ('multiples', models.BooleanField(help_text='Are multiple setting values allowed?', verbose_name='Multiples')),
                ('admin_only', models.BooleanField(help_text='Are these only allowed for people with Django Admin privilages?', verbose_name='Django Admin Only')),
                ('setting_type', models.IntegerField(choices=[(1, 'Common'), (2, 'Response Meta Tag')], verbose_name='Setting Type')),
            ],
            options={
                'verbose_name': 'Site Setting Key',
                'verbose_name_plural': 'Site Setting Keys',
            },
        ),
        migrations.CreateModel(
            name='SiteConfigModel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('deleted', models.BooleanField(default=False, help_text='Soft Delete the Setting value', verbose_name='Deleted')),
                ('value', models.JSONField(default=dict, verbose_name='Value')),
                ('key', models.ForeignKey(help_text='What setting is this value for?', on_delete=django.db.models.deletion.CASCADE, to='siteconfigs.siteconfigkeymodel', verbose_name='Site Setting Key Name')),
                ('site', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='settings', to='sites.site')),
            ],
            options={
                'verbose_name': 'Site Setting',
                'verbose_name_plural': 'Site Settings',
            },
        ),
    ]
