# Generated by ../generate_parser.py
"""
# Grammar definition:
```
import textwrap
```

ignore Space = /[ \\t]+/
ignore Comment = /#[^\\r\\n]*/

Newline = /[\\r\\n][\\s]*/
LineSep = Some(Newline | ";")
Name = /[_a-zA-Z][_a-zA-Z0-9]*/
QualifiedName = (Name // ".") |> `lambda x: '.'.join(x)`

Comma = wrap(",")

wrap(x) => Skip(Newline) >> x << Skip(Newline)

# Parse a full word, then see if it matches our keyword. The point is to make
# sure that we don't simply match the first part of a word. (For example, if
# the input string is "classify", we wouldn't want to match the keyword "class".)
kw(word) => Name where `lambda x: x == word`

Params = wrap("(") >> (wrap(Name) /? Comma) << ")"
IgnoreKeyword = kw("ignored") | kw("ignore")
OverrideKeyword = kw("overrides") | kw("override")

class StringLiteral {
    value: (
        /(?s)[bB]?(\"\"\"([^\\\\]|\\\\.)*?\"\"\")[iI]?/
        | /(?s)[bB]?('''([^\\\\]|\\\\.)*?''')[iI]?/
        | /[bB]?("([^"\\\\]|\\\\.)*")[iI]?/
        | /[bB]?('([^'\\\\]|\\\\.)*')[iI]?/
    )
}

class RegexLiteral {
    value: /[bB]?\\/([^\\/\\\\]|\\\\.)*\\/[iI]?/
}

class PythonSection {
    # Strip the backticks and remove any common indentation.
    value: /(?s)```.*?```/ |> `lambda x: textwrap.dedent(x[3:-3])`
}

class PythonExpression {
    # Strip the backticks.
    value: /`.*?`/ |> `lambda x: x[1:-1]`
        | /\\d+/
        | "True"
        | "False"
        | "None"
}

class RuleDef {
    is_override: Opt(OverrideKeyword) |> `bool`
    is_ignored: Opt(IgnoreKeyword) |> `bool`
    name: Name
    params: Opt(Params) << wrap("=>" | "=" | ":")
    expr: Expr
}

class ClassDef {
    name: kw("class") >> Name
    params: Opt(Params)
    members: wrap("{") >> (ClassMember /? LineSep) << "}"
}

class ClassMember {
    is_omitted: Opt("let") |> `bool`
    name: Name << wrap("=>" | "=" | ":")
    expr: Expr
}

class IgnoreStmt {
    expr: IgnoreKeyword >> Expr
}

class GrammarDef {
    head: Opt(GrammarHead << Skip(Newline))
    body: ManyStmts | SingleExpr
}

class GrammarHead {
    name: kw("grammar") >> QualifiedName
    extends: Opt(kw("extends") >> QualifiedName)
}

Stmt = ClassDef
    | RuleDef
    | IgnoreStmt
    | PythonSection
    | PythonExpression

class LetExpression {
    name: kw("let") >> Name << wrap("=>" | "=" | ":")
    expr: Expr << wrap(kw("in"))
    body: Expr
}

class Ref {
    value: Name
}

class ListLiteral {
    elements: "[" >> (wrap(Expr) /? Comma) << "]"
}

class ByteLiteral {
    prefix: /0[xX]/
    value: /[0-9a-fA-F]{2}/ |> `lambda x: int(x, 16)`
}

Atom = StringLiteral
    | RegexLiteral
    | LetExpression
    | ListLiteral
    | ByteLiteral
    | PythonExpression
    | Ref

class KeywordArg {
    name: Name << ("=>" | "=" | ":")
    expr: Expr
}

class ArgList {
    args: "(" >> (wrap(KeywordArg | Expr) /? Comma) << ")"
}

Expr = Atom between {
    mixfix: "(" >> wrap(Expr) << ")"
    postfix: ArgList, FieldAccess
    postfix: "?", "*", "+", Repeat
    left: wrap("//" | "/?")
    left: wrap("<<" | ">>")
    left: wrap("<|" | "|>" | "where")
    left: wrap("|")
    postfix: OperatorTable
}

class FieldAccess {
    field: "." >> Name
}

class Repeat {
    open: "{"
    start: RepeatArg?
    stop: ("," >> RepeatArg) | ("," >> None) | `start`
    close: "}"
}

RepeatArg = PythonExpression | Ref

class OperatorTable {
    rows: wrap(kw("between"))
        >> "{"
        >> Skip(Newline)
        >> OperatorRow*
        << "}"
}

class OperatorRow {
    associativity: Associativity
    operators: wrap(":") >> (Operator /? Comma)
    tail: Opt(LineSep)
}

Operator = Expr << ExpectNot(wrap(":"))

Associativity = kw("left")
    | kw("right")
    | kw("infix")
    | kw("mixfix")
    | kw("postfix")
    | kw("prefix")

ManyStmts = Sep(Stmt, LineSep, allow_trailer=True, allow_empty=False)
SingleExpr = Expr << Opt(LineSep)
start = Skip(Newline) >> GrammarDef

"""

from collections import namedtuple as _nt
from re import compile as _compile_re, IGNORECASE as _IGNORECASE

class Node:
    _fields = ()

    def __init__(self):
        self._metadata = _Metadata()
        self._hash = None

    def __eq__(self, other):
        if self is other:
            return True
        if not isinstance(other, self.__class__):
            return False
        for field in self._fields:
            left = getattr(self, field)
            right = getattr(other, field)
            if left is not right and left != right:
                return False
        return True

    def __hash__(self):
        if self._hash is not None:
            return self._hash
        self._hash = 0
        result = 0
        for field in self._fields:
            result ^= _hash(getattr(self, field))
        self._hash = result
        return result

    def _asdict(self):
        return {k: getattr(self, k) for k in self._fields}

    def _replace(self, **kw):
        for field in self._fields:
            if field not in kw:
                kw[field] = getattr(self, field)
        result = self.__class__(**kw)
        result._metadata.update(self._metadata)
        return result


def _hash(value):
    try:
        return hash(value)
    except TypeError:
        if isinstance(value, (tuple, list)):
            result = 0
            for item in value:
                result ^= _hash(item)
            return result
        elif isinstance(value, dict):
            result = 0
            for pair in value.items():
                result ^= _hash(pair)
            return result
        else:
            raise


class _Metadata:
    def __init__(self, **fields):
        object.__setattr__(self, '_fields', fields)

    def __getattr__(self, name):
        return self._fields.get(name)

    def __setattr__(self, name, value):
        self._fields[name] = value

    def __len__(self):
        return len(self._fields)

    def copy(self):
        return _Metadata(**self._fields)

    def update(self, other):
        self._fields.update(other._fields)


class Rule:
    def __init__(self, name, parse, definition):
        self.name = name
        self.parse = parse
        self.definition = definition

    def __repr__(self):
        return (f'Rule(name={self.name!r}, parse={self.parse.__name__},'
            f' definition={self.definition!r})')


import textwrap


class InputError(Exception):
    """Common superclass for ParseError and PartialParseError."""


class ParseError(InputError):
    def __init__(self, message, index, line, column):
        super().__init__(message)
        self.position = _Position(index, line, column)


class PartialParseError(InputError):
    def __init__(self, partial_result, last_position, excerpt):
        super().__init__('Incomplete parse. Unexpected input on line'
            f' {last_position.line}, column {last_position.column}:\n{excerpt}')
        self.partial_result = partial_result
        self.last_position = last_position


class Infix(Node):
    _fields = ('left', 'operator', 'right')

    def __init__(self, left, operator, right):
        Node.__init__(self)
        self.left = left
        self.operator = operator
        self.right = right

    def __repr__(self):
        return f'Infix({self.left!r}, {self.operator!r}, {self.right!r})'


class Postfix(Node):
    _fields = ('left', 'operator')

    def __init__(self, left, operator):
        Node.__init__(self)
        self.left = left
        self.operator = operator

    def __repr__(self):
        return f'Postfix({self.left!r}, {self.operator!r})'


class Prefix(Node):
    _fields = ('operator', 'right')

    def __init__(self, operator, right):
        Node.__init__(self)
        self.operator = operator
        self.right = right

    def __repr__(self):
        return f'Prefix({self.operator!r}, {self.right!r})'


def parse(text, pos=0, fullparse=True):
    return _run(text, pos, _try_start, fullparse)


_PositionInfo = _nt('_PositionInfo', 'start, end')

_Position = _nt('_Position', 'index, line, column')


class _ParseFunction(_nt('_ParseFunction', 'func, args, kwargs')):
    def __call__(self, _text, _pos):
        return self.func(_text, _pos, *self.args, **dict(self.kwargs))


class _StringLiteral(str):
    def __call__(self, _text, _pos):
        return self._parse_function(_text, _pos)


def _wrap_string_literal(string_value, parse_function):
    result = _StringLiteral(string_value)
    result._parse_function = parse_function
    return result


class _ByteLiteral(int):
    def __call__(self, _text, _pos):
        return self._parse_function(_text, _pos)


def _wrap_byte_literal(byte_value, parse_function):
    result = _ByteLiteral(byte_value)
    result._parse_function = parse_function
    return result


def _run(text, pos, start, fullparse):
    memo = {}
    result = None

    key = (3, start, pos)
    gtor = start(text, pos)
    stack = [(key, gtor)]

    while stack:
        key, gtor = stack[-1]
        result = gtor.send(result)

        if result[0] != 3:
            stack.pop()
            memo[key] = result
        elif result in memo:
            result = memo[result]
        else:
            gtor = result[1](text, result[2])
            stack.append((result, gtor))
            result = None

    if result[0]:
        return _finalize_parse_info(text, result[1], result[2], fullparse)
    else:
        pos = result[2]
        message = result[1](text, pos)
        raise ParseError(message, pos)


def visit(node):
    visited = set()
    stack = [node]
    while stack:
        node = stack.pop()

        if isinstance(node, (list, tuple)):
            stack.extend(reversed(node))

        elif isinstance(node, dict):
            stack.extend(reversed(node.values()))

        elif isinstance(node, Node):
            node_id = id(node)
            if node_id in visited:
                continue
            visited.add(node_id)

            yield node

            if hasattr(node, '_fields'):
                stack.extend(getattr(node, x) for x in reversed(node._fields))


_Traversing = _nt('_Traversing', 'parent, field, child, is_finished')


def traverse(node):
    visited = set()
    stack = [_Traversing(parent=None, field=None, child=node, is_finished=False)]
    while stack:
        traversing = stack.pop()

        if traversing.is_finished:
            yield traversing
            continue

        child = traversing.child
        child_id = id(child)

        if child_id in visited:
            continue

        visited.add(child_id)
        stack.append(traversing._replace(is_finished=True))
        yield traversing

        def extend(items):
            stack.extend(reversed(list(items)))

        if isinstance(child, (list, tuple)):
            extend(
                _Traversing(parent=child, field=i, child=x, is_finished=False)
                for i, x in enumerate(child)
            )

        elif isinstance(child, dict):
            extend(
                _Traversing(parent=child, field=k, child=v, is_finished=False)
                for k, v in child.items()
            )

        elif isinstance(child, Node) and hasattr(child, '_fields'):
            extend(
                _Traversing(
                    parent=child,
                    field=x,
                    child=getattr(child, x),
                    is_finished=False,
                )
                for x in child._fields
            )


def transform(node, *callbacks):
    if not callbacks:
        return node

    def callback(node):
        for f in callbacks:
            prev = node
            node = f(prev)

            if node is not prev:
                if (
                    isinstance(prev, Node)
                    and isinstance(node, Node)
                    and not node._metadata
                ):
                    node._metadata.update(prev._metadata)

        return node

    return _transform(node, callback)


def _transform(node, callback):
    if isinstance(node, list):
        return [_transform(x, callback) for x in node]

    if not isinstance(node, Node):
        return node

    updates = {}
    for field in node._fields:
        was = getattr(node, field)
        now = _transform(was, callback)
        if now is not was:
            updates[field] = now

    if updates:
        node = node._replace(**updates)

    return callback(node)


def _finalize_parse_info(text, nodes, pos, fullparse):
    line_numbers, column_numbers = _map_index_to_line_and_column(text)

    for node in visit(nodes):
        pos_info = node._metadata.position_info
        if pos_info:
            start, end = pos_info
            end -= 1
            node._metadata.position_info = _PositionInfo(
                start=_Position(start, line_numbers[start], column_numbers[start]),
                end=_Position(end, line_numbers[end], column_numbers[end]),
            )

    if fullparse and pos < len(text):
        line, col = line_numbers[pos], column_numbers[pos]
        position = _Position(pos, line, col)
        excerpt = _extract_excerpt(text, pos, col)
        raise PartialParseError(nodes, position, excerpt)

    return nodes


def _extract_excerpt(text, pos, col):
    if isinstance(text, bytes):
        return repr(text[max(0, pos - 1) : pos + 2])

    start = pos - (col - 1)
    match = _compile_re('\n').search(text, pos + 1)
    end = len(text) if match is None else match.start()

    if end - start < 96:
        return text[start : end] + _caret_at(col - 1)

    if col < 60:
        # Chop the line off at the end.
        return text[start : start + 90] + ' ...' + _caret_at(col - 1)

    elif end - pos < 40:
        # Chop the line off at the start.
        return '... ' + text[end - 90 : end] + _caret_at(pos - (end - 90) + 4)

    else:
        # Chop the line off at both ends.
        return '... ' + text[pos - 42 : pos + 42] + ' ...' + _caret_at(42 + 4)


def _caret_at(index):
    return '\n' + (' ' * index) + '^'


def _get_line_and_column(text, pos):
    line_numbers, column_numbers = _map_index_to_line_and_column(text)
    return line_numbers[pos], column_numbers[pos]


def _map_index_to_line_and_column(text):
    line_numbers = []
    column_numbers = []

    current_line = 1
    current_column = 0

    for c in text:
        if c == '\n':
            current_line += 1
            current_column = 0
        else:
            current_column += 1
        line_numbers.append(current_line)
        column_numbers.append(current_column)

    return line_numbers, column_numbers

matcher1 = _compile_re('[ \\t]+', flags=0).match
matcher2 = _compile_re('#[^\\r\\n]*', flags=0).match
matcher3 = _compile_re('[\\r\\n][\\s]*', flags=0).match
matcher4 = _compile_re('[_a-zA-Z][_a-zA-Z0-9]*', flags=0).match
matcher5 = _compile_re('(?s)[bB]?("""([^\\\\]|\\\\.)*?""")[iI]?', flags=0).match
matcher6 = _compile_re("(?s)[bB]?('''([^\\\\]|\\\\.)*?''')[iI]?", flags=0).match
matcher7 = _compile_re('[bB]?("([^"\\\\]|\\\\.)*")[iI]?', flags=0).match
matcher8 = _compile_re("[bB]?('([^'\\\\]|\\\\.)*')[iI]?", flags=0).match
matcher9 = _compile_re('[bB]?\\/([^\\/\\\\]|\\\\.)*\\/[iI]?', flags=0).match
matcher10 = _compile_re('(?s)```.*?```', flags=0).match
matcher11 = _compile_re('`.*?`', flags=0).match
matcher12 = _compile_re('\\d+', flags=0).match
matcher13 = _compile_re('0[xX]', flags=0).match
matcher14 = _compile_re('[0-9a-fA-F]{2}', flags=0).match

def _try_Space(_text, _pos):
    # Rule 'Space'
    # Begin Regex
    # /[ \\t]+/
    match1 = matcher1(_text, _pos)
    if match1:
        _result = match1.group(0)
        _pos = (yield (3, _try__ignored, match1.end()))[2]
        _status = True
    else:
        _result = _raise_error2
        _status = False
    # End Regex
    yield (_status, _result, _pos)

def _parse_Space(text, pos=0, fullparse=True):
    return _run(text, pos, _try_Space, fullparse)

Space = Rule('Space', _parse_Space, """
    Space = /[ \\t]+/
""")
def _raise_error2(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Space' rule, at the expression:\n"
    '    /[ \\\\t]+/\n\n'
    'Expected to match the regular expression /[ \\t]+/'
    )
    raise ParseError((title + details), _pos, line, col)

def _try_Comment(_text, _pos):
    # Rule 'Comment'
    # Begin Regex
    # /#[^\\r\\n]*/
    match2 = matcher2(_text, _pos)
    if match2:
        _result = match2.group(0)
        _pos = (yield (3, _try__ignored, match2.end()))[2]
        _status = True
    else:
        _result = _raise_error4
        _status = False
    # End Regex
    yield (_status, _result, _pos)

def _parse_Comment(text, pos=0, fullparse=True):
    return _run(text, pos, _try_Comment, fullparse)

Comment = Rule('Comment', _parse_Comment, """
    Comment = /#[^\\r\\n]*/
""")
def _raise_error4(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Comment' rule, at the expression:\n"
    '    /#[^\\\\r\\\\n]*/\n\n'
    'Expected to match the regular expression /#[^\\r\\n]*/'
    )
    raise ParseError((title + details), _pos, line, col)

def _try_Newline(_text, _pos):
    # Rule 'Newline'
    # Begin Regex
    # /[\\r\\n][\\s]*/
    match3 = matcher3(_text, _pos)
    if match3:
        _result = match3.group(0)
        _pos = (yield (3, _try__ignored, match3.end()))[2]
        _status = True
    else:
        _result = _raise_error6
        _status = False
    # End Regex
    yield (_status, _result, _pos)

def _parse_Newline(text, pos=0, fullparse=True):
    return _run(text, pos, _try_Newline, fullparse)

Newline = Rule('Newline', _parse_Newline, """
    Newline = /[\\r\\n][\\s]*/
""")
def _raise_error6(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Newline' rule, at the expression:\n"
    '    /[\\\\r\\\\n][\\\\s]*/\n\n'
    'Expected to match the regular expression /[\\r\\n][\\s]*/'
    )
    raise ParseError((title + details), _pos, line, col)

def _try_LineSep(_text, _pos):
    # Rule 'LineSep'
    # Begin List
    # (Newline | ';')+
    staging1 = []
    while True:
        checkpoint1 = _pos
        # Begin Choice
        farthest_err1 = _raise_error9
        backtrack1 = farthest_pos1 = _pos
        while True:
            # Option 1:
            # Begin Ref
            (_status, _result, _pos) = (yield (3, _try_Newline, _pos))
            # End Ref
            if _status:
                break
            if (farthest_pos1 < _pos):
                farthest_pos1 = _pos
                farthest_err1 = _result
            _pos = backtrack1
            # Option 2:
            # Begin Str
            value1 = ';'
            end1 = (_pos + 1)
            if (_text[slice(_pos, end1, None)] == value1):
                _result = value1
                _pos = (yield (3, _try__ignored, end1))[2]
                _status = True
            else:
                _result = _raise_error11
                _status = False
            # End Str
            if _status:
                break
            _pos = farthest_pos1
            _result = farthest_err1
            break
        # End Choice
        if not (_status):
            _pos = checkpoint1
            break
        staging1.append(_result)
    if staging1:
        _result = staging1
        _status = True
    # End List
    yield (_status, _result, _pos)

def _parse_LineSep(text, pos=0, fullparse=True):
    return _run(text, pos, _try_LineSep, fullparse)

LineSep = Rule('LineSep', _parse_LineSep, """
    LineSep = (Newline | ';')+
""")
def _raise_error9(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'LineSep' rule, at the expression:\n"
    "    Newline | ';'\n\n"
    'Unexpected input'
    )
    raise ParseError((title + details), _pos, line, col)

def _raise_error11(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'LineSep' rule, at the expression:\n"
    "    ';'\n\n"
    "Expected to match the string ';'"
    )
    raise ParseError((title + details), _pos, line, col)

def _try_Name(_text, _pos):
    # Rule 'Name'
    # Begin Regex
    # /[_a-zA-Z][_a-zA-Z0-9]*/
    match4 = matcher4(_text, _pos)
    if match4:
        _result = match4.group(0)
        _pos = (yield (3, _try__ignored, match4.end()))[2]
        _status = True
    else:
        _result = _raise_error13
        _status = False
    # End Regex
    yield (_status, _result, _pos)

def _parse_Name(text, pos=0, fullparse=True):
    return _run(text, pos, _try_Name, fullparse)

Name = Rule('Name', _parse_Name, """
    Name = /[_a-zA-Z][_a-zA-Z0-9]*/
""")
def _raise_error13(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Name' rule, at the expression:\n"
    '    /[_a-zA-Z][_a-zA-Z0-9]*/\n\n'
    'Expected to match the regular expression /[_a-zA-Z][_a-zA-Z0-9]*/'
    )
    raise ParseError((title + details), _pos, line, col)

def _try_QualifiedName(_text, _pos):
    # Rule 'QualifiedName'
    # Begin Apply
    # (Name // '.') |> `lambda x: '.'.join(x)`
    # Begin Sep
    # Name // '.'
    staging2 = []
    checkpoint2 = _pos
    while True:
        # Begin Ref
        (_status, _result, _pos) = (yield (3, _try_Name, _pos))
        # End Ref
        if not (_status):
            break
        staging2.append(_result)
        checkpoint2 = _pos
        # Begin Str
        value2 = '.'
        end2 = (_pos + 1)
        if (_text[slice(_pos, end2, None)] == value2):
            _result = value2
            _pos = (yield (3, _try__ignored, end2))[2]
            _status = True
        else:
            _result = _raise_error18
            _status = False
        # End Str
        if not (_status):
            break
    _result = staging2
    _pos = checkpoint2
    _status = True
    # End Sep
    arg1 = _result
    _result = lambda x: '.'.join(x)
    _status = True
    _result = _result(arg1)
    # End Apply
    yield (_status, _result, _pos)

def _parse_QualifiedName(text, pos=0, fullparse=True):
    return _run(text, pos, _try_QualifiedName, fullparse)

QualifiedName = Rule('QualifiedName', _parse_QualifiedName, """
    QualifiedName = (Name // '.') |> `lambda x: '.'.join(x)`
""")
def _raise_error18(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'QualifiedName' rule, at the expression:\n"
    "    '.'\n\n"
    "Expected to match the string '.'"
    )
    raise ParseError((title + details), _pos, line, col)

def _parse_function_23(_text, _pos):
    # Begin Str
    value3 = ','
    end3 = (_pos + 1)
    if (_text[slice(_pos, end3, None)] == value3):
        _result = value3
        _pos = (yield (3, _try__ignored, end3))[2]
        _status = True
    else:
        _result = _raise_error23
        _status = False
    # End Str
    yield (_status, _result, _pos)

def _try_Comma(_text, _pos):
    # Rule 'Comma'
    # Begin Call
    # wrap(',')
    arg2 = _wrap_string_literal(',', _parse_function_23)
    func1 = _ParseFunction(_try_wrap, (arg2,), ())
    (_status, _result, _pos) = (yield (3, func1, _pos))
    # End Call
    yield (_status, _result, _pos)

def _parse_Comma(text, pos=0, fullparse=True):
    return _run(text, pos, _try_Comma, fullparse)

Comma = Rule('Comma', _parse_Comma, """
    Comma = wrap(',')
""")
def _raise_error23(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Comma' rule, at the expression:\n"
    "    ','\n\n"
    "Expected to match the string ','"
    )
    raise ParseError((title + details), _pos, line, col)

def _try_wrap(_text, _pos, x):
    # Rule 'wrap'
    # Begin Discard
    # (Skip(Newline) >> x) << Skip(Newline)
    while True:
        # Begin Discard
        # Skip(Newline) >> x
        while True:
            # Begin Skip
            # Skip(Newline)
            while True:
                checkpoint3 = _pos
                # Begin Ref
                (_status, _result, _pos) = (yield (3, _try_Newline, _pos))
                # End Ref
                if _status:
                    continue
                else:
                    _pos = checkpoint3
                break
            _result = None
            _status = True
            # End Skip
            # Begin Ref
            (_status, _result, _pos) = (yield (3, x, _pos))
            # End Ref
            break
        # End Discard
        if not (_status):
            break
        staging3 = _result
        # Begin Skip
        # Skip(Newline)
        while True:
            checkpoint4 = _pos
            # Begin Ref
            (_status, _result, _pos) = (yield (3, _try_Newline, _pos))
            # End Ref
            if _status:
                continue
            else:
                _pos = checkpoint4
            break
        _result = None
        _status = True
        # End Skip
        _result = staging3
        break
    # End Discard
    yield (_status, _result, _pos)

def _parse_wrap(text, pos=0, fullparse=True):
    return _run(text, pos, _try_wrap, fullparse)

wrap = Rule('wrap', _parse_wrap, """
    wrap(x) = (Skip(Newline) >> x) << Skip(Newline)
""")
def _try_kw(_text, _pos, word):
    # Rule 'kw'
    # Begin Where
    # Name where `lambda x: x == word`
    # Begin Ref
    (_status, _result, _pos) = (yield (3, _try_Name, _pos))
    # End Ref
    if _status:
        arg3 = _result
        _result = lambda x: x == word
        _status = True
        if _result(arg3):
            _result = arg3
        else:
            _result = _raise_error33
            _status = False
    # End Where
    yield (_status, _result, _pos)

def _parse_kw(text, pos=0, fullparse=True):
    return _run(text, pos, _try_kw, fullparse)

kw = Rule('kw', _parse_kw, """
    kw(word) = Name where `lambda x: x == word`
""")
def _raise_error33(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'kw' rule, at the expression:\n"
    '    Name where `lambda x: x == word`\n\n'
    'Expected to satisfy the predicate: `lambda x: x == word`'
    )
    raise ParseError((title + details), _pos, line, col)

def _parse_function_41(_text, _pos):
    # Begin Str
    value4 = '('
    end4 = (_pos + 1)
    if (_text[slice(_pos, end4, None)] == value4):
        _result = value4
        _pos = (yield (3, _try__ignored, end4))[2]
        _status = True
    else:
        _result = _raise_error41
        _status = False
    # End Str
    yield (_status, _result, _pos)

def _try_Params(_text, _pos):
    # Rule 'Params'
    # Begin Discard
    # (wrap('(') >> (wrap(Name) /? Comma)) << ')'
    while True:
        # Begin Discard
        # wrap('(') >> (wrap(Name) /? Comma)
        while True:
            # Begin Call
            # wrap('(')
            arg4 = _wrap_string_literal('(', _parse_function_41)
            func2 = _ParseFunction(_try_wrap, (arg4,), ())
            (_status, _result, _pos) = (yield (3, func2, _pos))
            # End Call
            if not (_status):
                break
            # Begin Sep
            # wrap(Name) /? Comma
            staging4 = []
            checkpoint5 = _pos
            while True:
                # Begin Call
                # wrap(Name)
                func3 = _ParseFunction(_try_wrap, (_try_Name,), ())
                (_status, _result, _pos) = (yield (3, func3, _pos))
                # End Call
                if not (_status):
                    break
                staging4.append(_result)
                checkpoint5 = _pos
                # Begin Ref
                (_status, _result, _pos) = (yield (3, _try_Comma, _pos))
                # End Ref
                if not (_status):
                    break
                checkpoint5 = _pos
            _result = staging4
            _pos = checkpoint5
            _status = True
            # End Sep
            break
        # End Discard
        if not (_status):
            break
        staging5 = _result
        # Begin Str
        value5 = ')'
        end5 = (_pos + 1)
        if (_text[slice(_pos, end5, None)] == value5):
            _result = value5
            _pos = (yield (3, _try__ignored, end5))[2]
            _status = True
        else:
            _result = _raise_error47
            _status = False
        # End Str
        if _status:
            _result = staging5
        break
    # End Discard
    yield (_status, _result, _pos)

def _parse_Params(text, pos=0, fullparse=True):
    return _run(text, pos, _try_Params, fullparse)

Params = Rule('Params', _parse_Params, """
    Params = (wrap('(') >> (wrap(Name) /? Comma)) << ')'
""")
def _raise_error41(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Params' rule, at the expression:\n"
    "    '('\n\n"
    "Expected to match the string '('"
    )
    raise ParseError((title + details), _pos, line, col)

def _raise_error47(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Params' rule, at the expression:\n"
    "    ')'\n\n"
    "Expected to match the string ')'"
    )
    raise ParseError((title + details), _pos, line, col)

def _parse_function_52(_text, _pos):
    # Begin Str
    value6 = 'ignored'
    end6 = (_pos + 7)
    if (_text[slice(_pos, end6, None)] == value6):
        _result = value6
        _pos = (yield (3, _try__ignored, end6))[2]
        _status = True
    else:
        _result = _raise_error52
        _status = False
    # End Str
    yield (_status, _result, _pos)

def _parse_function_55(_text, _pos):
    # Begin Str
    value7 = 'ignore'
    end7 = (_pos + 6)
    if (_text[slice(_pos, end7, None)] == value7):
        _result = value7
        _pos = (yield (3, _try__ignored, end7))[2]
        _status = True
    else:
        _result = _raise_error55
        _status = False
    # End Str
    yield (_status, _result, _pos)

def _try_IgnoreKeyword(_text, _pos):
    # Rule 'IgnoreKeyword'
    # Begin Choice
    farthest_err2 = _raise_error49
    backtrack2 = farthest_pos2 = _pos
    while True:
        # Option 1:
        # Begin Call
        # kw('ignored')
        arg5 = _wrap_string_literal('ignored', _parse_function_52)
        func4 = _ParseFunction(_try_kw, (arg5,), ())
        (_status, _result, _pos) = (yield (3, func4, _pos))
        # End Call
        if _status:
            break
        if (farthest_pos2 < _pos):
            farthest_pos2 = _pos
            farthest_err2 = _result
        _pos = backtrack2
        # Option 2:
        # Begin Call
        # kw('ignore')
        arg6 = _wrap_string_literal('ignore', _parse_function_55)
        func5 = _ParseFunction(_try_kw, (arg6,), ())
        (_status, _result, _pos) = (yield (3, func5, _pos))
        # End Call
        if _status:
            break
        if (farthest_pos2 < _pos):
            farthest_pos2 = _pos
            farthest_err2 = _result
        _pos = farthest_pos2
        _result = farthest_err2
        break
    # End Choice
    yield (_status, _result, _pos)

def _parse_IgnoreKeyword(text, pos=0, fullparse=True):
    return _run(text, pos, _try_IgnoreKeyword, fullparse)

IgnoreKeyword = Rule('IgnoreKeyword', _parse_IgnoreKeyword, """
    IgnoreKeyword = kw('ignored') | kw('ignore')
""")
def _raise_error49(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'IgnoreKeyword' rule, at the expression:\n"
    "    kw('ignored') | kw('ignore')\n\n"
    'Unexpected input'
    )
    raise ParseError((title + details), _pos, line, col)

def _raise_error52(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'IgnoreKeyword' rule, at the expression:\n"
    "    'ignored'\n\n"
    "Expected to match the string 'ignored'"
    )
    raise ParseError((title + details), _pos, line, col)

def _raise_error55(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'IgnoreKeyword' rule, at the expression:\n"
    "    'ignore'\n\n"
    "Expected to match the string 'ignore'"
    )
    raise ParseError((title + details), _pos, line, col)

def _parse_function_60(_text, _pos):
    # Begin Str
    value8 = 'overrides'
    end8 = (_pos + 9)
    if (_text[slice(_pos, end8, None)] == value8):
        _result = value8
        _pos = (yield (3, _try__ignored, end8))[2]
        _status = True
    else:
        _result = _raise_error60
        _status = False
    # End Str
    yield (_status, _result, _pos)

def _parse_function_63(_text, _pos):
    # Begin Str
    value9 = 'override'
    end9 = (_pos + 8)
    if (_text[slice(_pos, end9, None)] == value9):
        _result = value9
        _pos = (yield (3, _try__ignored, end9))[2]
        _status = True
    else:
        _result = _raise_error63
        _status = False
    # End Str
    yield (_status, _result, _pos)

def _try_OverrideKeyword(_text, _pos):
    # Rule 'OverrideKeyword'
    # Begin Choice
    farthest_err3 = _raise_error57
    backtrack3 = farthest_pos3 = _pos
    while True:
        # Option 1:
        # Begin Call
        # kw('overrides')
        arg7 = _wrap_string_literal('overrides', _parse_function_60)
        func6 = _ParseFunction(_try_kw, (arg7,), ())
        (_status, _result, _pos) = (yield (3, func6, _pos))
        # End Call
        if _status:
            break
        if (farthest_pos3 < _pos):
            farthest_pos3 = _pos
            farthest_err3 = _result
        _pos = backtrack3
        # Option 2:
        # Begin Call
        # kw('override')
        arg8 = _wrap_string_literal('override', _parse_function_63)
        func7 = _ParseFunction(_try_kw, (arg8,), ())
        (_status, _result, _pos) = (yield (3, func7, _pos))
        # End Call
        if _status:
            break
        if (farthest_pos3 < _pos):
            farthest_pos3 = _pos
            farthest_err3 = _result
        _pos = farthest_pos3
        _result = farthest_err3
        break
    # End Choice
    yield (_status, _result, _pos)

def _parse_OverrideKeyword(text, pos=0, fullparse=True):
    return _run(text, pos, _try_OverrideKeyword, fullparse)

OverrideKeyword = Rule('OverrideKeyword', _parse_OverrideKeyword, """
    OverrideKeyword = kw('overrides') | kw('override')
""")
def _raise_error57(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'OverrideKeyword' rule, at the expression:\n"
    "    kw('overrides') | kw('override')\n\n"
    'Unexpected input'
    )
    raise ParseError((title + details), _pos, line, col)

def _raise_error60(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'OverrideKeyword' rule, at the expression:\n"
    "    'overrides'\n\n"
    "Expected to match the string 'overrides'"
    )
    raise ParseError((title + details), _pos, line, col)

def _raise_error63(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'OverrideKeyword' rule, at the expression:\n"
    "    'override'\n\n"
    "Expected to match the string 'override'"
    )
    raise ParseError((title + details), _pos, line, col)

class StringLiteral(Node):
    """
    class StringLiteral {
        value: /(?s)[bB]?(\"\"\"([^\\\\\\\\]|\\\\\\\\.)*?\"\"\")[iI]?/ | /(?s)[bB]?('''([^\\\\\\\\]|\\\\\\\\.)*?''')[iI]?/ | /[bB]?("([^"\\\\\\\\]|\\\\\\\\.)*")[iI]?/ | /[bB]?('([^'\\\\\\\\]|\\\\\\\\.)*')[iI]?/
    }
    """
    _fields = ('value',)

    def __init__(self, value):
        Node.__init__(self)
        self.value = value

    def __repr__(self):
        return f'StringLiteral(value={self.value!r})'

    @staticmethod
    def parse(text, pos=0, fullparse=True):
        return _run(text, pos, _try_StringLiteral, fullparse)


def _try_StringLiteral(_text, _pos):
    # Begin Seq
    start_pos1 = _pos
    while True:
        # Begin Choice
        farthest_err4 = _raise_error67
        farthest_pos4 = _pos
        while True:
            # Option 1:
            # Begin Regex
            # /(?s)[bB]?("""([^\\\\]|\\\\.)*?""")[iI]?/
            match5 = matcher5(_text, _pos)
            if match5:
                _result = match5.group(0)
                _pos = (yield (3, _try__ignored, match5.end()))[2]
                _status = True
            else:
                _result = _raise_error68
                _status = False
            # End Regex
            if _status:
                break
            # Option 2:
            # Begin Regex
            # /(?s)[bB]?('''([^\\\\]|\\\\.)*?''')[iI]?/
            match6 = matcher6(_text, _pos)
            if match6:
                _result = match6.group(0)
                _pos = (yield (3, _try__ignored, match6.end()))[2]
                _status = True
            else:
                _result = _raise_error69
                _status = False
            # End Regex
            if _status:
                break
            # Option 3:
            # Begin Regex
            # /[bB]?("([^"\\\\]|\\\\.)*")[iI]?/
            match7 = matcher7(_text, _pos)
            if match7:
                _result = match7.group(0)
                _pos = (yield (3, _try__ignored, match7.end()))[2]
                _status = True
            else:
                _result = _raise_error70
                _status = False
            # End Regex
            if _status:
                break
            # Option 4:
            # Begin Regex
            # /[bB]?('([^'\\\\]|\\\\.)*')[iI]?/
            match8 = matcher8(_text, _pos)
            if match8:
                _result = match8.group(0)
                _pos = (yield (3, _try__ignored, match8.end()))[2]
                _status = True
            else:
                _result = _raise_error71
                _status = False
            # End Regex
            if _status:
                break
            _pos = farthest_pos4
            _result = farthest_err4
            break
        # End Choice
        if not (_status):
            break
        value = _result
        _result = StringLiteral(value)
        _result._metadata.position_info = (start_pos1, _pos)
        break
    # End Seq
    yield (_status, _result, _pos)

def _raise_error67(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'StringLiteral' rule, at the expression:\n"
    '    /(?s)[bB]?("""([^\\\\\\\\]|\\\\\\\\.)*?""")[iI]?/ | /(?s)[bB]?(\'\'\'([^\\\\\\\\]|\\\\\\\\.)*?\'\'\')[iI]?/ | /[bB]?("([^"\\\\\\\\]|\\\\\\\\.)*")[iI]?/ | /[bB]?(\'([^\'\\\\\\\\]|\\\\\\\\.)*\')[iI]?/\n\n'
    'Unexpected input'
    )
    raise ParseError((title + details), _pos, line, col)

def _raise_error68(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'StringLiteral' rule, at the expression:\n"
    '    /(?s)[bB]?("""([^\\\\\\\\]|\\\\\\\\.)*?""")[iI]?/\n\n'
    'Expected to match the regular expression /(?s)[bB]?("""([^\\\\]|\\\\.)*?""")[iI]?/'
    )
    raise ParseError((title + details), _pos, line, col)

def _raise_error69(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'StringLiteral' rule, at the expression:\n"
    "    /(?s)[bB]?('''([^\\\\\\\\]|\\\\\\\\.)*?''')[iI]?/\n\n"
    "Expected to match the regular expression /(?s)[bB]?('''([^\\\\]|\\\\.)*?''')[iI]?/"
    )
    raise ParseError((title + details), _pos, line, col)

def _raise_error70(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'StringLiteral' rule, at the expression:\n"
    '    /[bB]?("([^"\\\\\\\\]|\\\\\\\\.)*")[iI]?/\n\n'
    'Expected to match the regular expression /[bB]?("([^"\\\\]|\\\\.)*")[iI]?/'
    )
    raise ParseError((title + details), _pos, line, col)

def _raise_error71(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'StringLiteral' rule, at the expression:\n"
    "    /[bB]?('([^'\\\\\\\\]|\\\\\\\\.)*')[iI]?/\n\n"
    "Expected to match the regular expression /[bB]?('([^'\\\\]|\\\\.)*')[iI]?/"
    )
    raise ParseError((title + details), _pos, line, col)

class RegexLiteral(Node):
    """
    class RegexLiteral {
        value: /[bB]?\\\\/([^\\\\/\\\\\\\\]|\\\\\\\\.)*\\\\/[iI]?/
    }
    """
    _fields = ('value',)

    def __init__(self, value):
        Node.__init__(self)
        self.value = value

    def __repr__(self):
        return f'RegexLiteral(value={self.value!r})'

    @staticmethod
    def parse(text, pos=0, fullparse=True):
        return _run(text, pos, _try_RegexLiteral, fullparse)


def _try_RegexLiteral(_text, _pos):
    # Begin Seq
    start_pos2 = _pos
    while True:
        # Begin Regex
        # /[bB]?\\/([^\\/\\\\]|\\\\.)*\\/[iI]?/
        match9 = matcher9(_text, _pos)
        if match9:
            _result = match9.group(0)
            _pos = (yield (3, _try__ignored, match9.end()))[2]
            _status = True
        else:
            _result = _raise_error75
            _status = False
        # End Regex
        if not (_status):
            break
        value = _result
        _result = RegexLiteral(value)
        _result._metadata.position_info = (start_pos2, _pos)
        break
    # End Seq
    yield (_status, _result, _pos)

def _raise_error75(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'RegexLiteral' rule, at the expression:\n"
    '    /[bB]?\\\\/([^\\\\/\\\\\\\\]|\\\\\\\\.)*\\\\/[iI]?/\n\n'
    'Expected to match the regular expression /[bB]?\\/([^\\/\\\\]|\\\\.)*\\/[iI]?/'
    )
    raise ParseError((title + details), _pos, line, col)

class PythonSection(Node):
    """
    class PythonSection {
        value: /(?s)```.*?```/ |> `lambda x: textwrap.dedent(x[3:-3])`
    }
    """
    _fields = ('value',)

    def __init__(self, value):
        Node.__init__(self)
        self.value = value

    def __repr__(self):
        return f'PythonSection(value={self.value!r})'

    @staticmethod
    def parse(text, pos=0, fullparse=True):
        return _run(text, pos, _try_PythonSection, fullparse)


def _try_PythonSection(_text, _pos):
    # Begin Seq
    start_pos3 = _pos
    while True:
        # Begin Apply
        # /(?s)```.*?```/ |> `lambda x: textwrap.dedent(x[3:-3])`
        # Begin Regex
        # /(?s)```.*?```/
        match10 = matcher10(_text, _pos)
        if match10:
            _result = match10.group(0)
            _pos = (yield (3, _try__ignored, match10.end()))[2]
            _status = True
        else:
            _result = _raise_error80
            _status = False
        # End Regex
        if _status:
            arg9 = _result
            _result = lambda x: textwrap.dedent(x[3:-3])
            _status = True
            _result = _result(arg9)
        # End Apply
        if not (_status):
            break
        value = _result
        _result = PythonSection(value)
        _result._metadata.position_info = (start_pos3, _pos)
        break
    # End Seq
    yield (_status, _result, _pos)

def _raise_error80(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'PythonSection' rule, at the expression:\n"
    '    /(?s)```.*?```/\n\n'
    'Expected to match the regular expression /(?s)```.*?```/'
    )
    raise ParseError((title + details), _pos, line, col)

class PythonExpression(Node):
    """
    class PythonExpression {
        value: /`.*?`/ |> `lambda x: x[1:-1]` | /\\\\d+/ | 'True' | 'False' | 'None'
    }
    """
    _fields = ('value',)

    def __init__(self, value):
        Node.__init__(self)
        self.value = value

    def __repr__(self):
        return f'PythonExpression(value={self.value!r})'

    @staticmethod
    def parse(text, pos=0, fullparse=True):
        return _run(text, pos, _try_PythonExpression, fullparse)


def _try_PythonExpression(_text, _pos):
    # Begin Seq
    start_pos4 = _pos
    while True:
        # Begin Choice
        farthest_err5 = _raise_error85
        backtrack4 = farthest_pos5 = _pos
        while True:
            # Option 1:
            # Begin Apply
            # /`.*?`/ |> `lambda x: x[1:-1]`
            # Begin Regex
            # /`.*?`/
            match11 = matcher11(_text, _pos)
            if match11:
                _result = match11.group(0)
                _pos = (yield (3, _try__ignored, match11.end()))[2]
                _status = True
            else:
                _result = _raise_error87
                _status = False
            # End Regex
            if _status:
                arg10 = _result
                _result = lambda x: x[1:-1]
                _status = True
                _result = _result(arg10)
            # End Apply
            if _status:
                break
            if (farthest_pos5 < _pos):
                farthest_pos5 = _pos
                farthest_err5 = _result
            _pos = backtrack4
            # Option 2:
            # Begin Regex
            # /\\d+/
            match12 = matcher12(_text, _pos)
            if match12:
                _result = match12.group(0)
                _pos = (yield (3, _try__ignored, match12.end()))[2]
                _status = True
            else:
                _result = _raise_error89
                _status = False
            # End Regex
            if _status:
                break
            # Option 3:
            # Begin Str
            value10 = 'True'
            end10 = (_pos + 4)
            if (_text[slice(_pos, end10, None)] == value10):
                _result = value10
                _pos = (yield (3, _try__ignored, end10))[2]
                _status = True
            else:
                _result = _raise_error90
                _status = False
            # End Str
            if _status:
                break
            # Option 4:
            # Begin Str
            value11 = 'False'
            end11 = (_pos + 5)
            if (_text[slice(_pos, end11, None)] == value11):
                _result = value11
                _pos = (yield (3, _try__ignored, end11))[2]
                _status = True
            else:
                _result = _raise_error91
                _status = False
            # End Str
            if _status:
                break
            # Option 5:
            # Begin Str
            value12 = 'None'
            end12 = (_pos + 4)
            if (_text[slice(_pos, end12, None)] == value12):
                _result = value12
                _pos = (yield (3, _try__ignored, end12))[2]
                _status = True
            else:
                _result = _raise_error92
                _status = False
            # End Str
            if _status:
                break
            _pos = farthest_pos5
            _result = farthest_err5
            break
        # End Choice
        if not (_status):
            break
        value = _result
        _result = PythonExpression(value)
        _result._metadata.position_info = (start_pos4, _pos)
        break
    # End Seq
    yield (_status, _result, _pos)

def _raise_error85(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'PythonExpression' rule, at the expression:\n"
    "    /`.*?`/ |> `lambda x: x[1:-1]` | /\\\\d+/ | 'True' | 'False' | 'None'\n\n"
    'Unexpected input'
    )
    raise ParseError((title + details), _pos, line, col)

def _raise_error87(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'PythonExpression' rule, at the expression:\n"
    '    /`.*?`/\n\n'
    'Expected to match the regular expression /`.*?`/'
    )
    raise ParseError((title + details), _pos, line, col)

def _raise_error89(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'PythonExpression' rule, at the expression:\n"
    '    /\\\\d+/\n\n'
    'Expected to match the regular expression /\\d+/'
    )
    raise ParseError((title + details), _pos, line, col)

def _raise_error90(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'PythonExpression' rule, at the expression:\n"
    "    'True'\n\n"
    "Expected to match the string 'True'"
    )
    raise ParseError((title + details), _pos, line, col)

def _raise_error91(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'PythonExpression' rule, at the expression:\n"
    "    'False'\n\n"
    "Expected to match the string 'False'"
    )
    raise ParseError((title + details), _pos, line, col)

def _raise_error92(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'PythonExpression' rule, at the expression:\n"
    "    'None'\n\n"
    "Expected to match the string 'None'"
    )
    raise ParseError((title + details), _pos, line, col)

class RuleDef(Node):
    """
    class RuleDef {
        is_override: Opt(OverrideKeyword) |> `bool`
        is_ignored: Opt(IgnoreKeyword) |> `bool`
        name: Name
        params: Opt(Params) << wrap('=>' | '=' | ':')
        expr: Expr
    }
    """
    _fields = ('is_override', 'is_ignored', 'name', 'params', 'expr')

    def __init__(self, is_override, is_ignored, name, params, expr):
        Node.__init__(self)
        self.is_override = is_override
        self.is_ignored = is_ignored
        self.name = name
        self.params = params
        self.expr = expr

    def __repr__(self):
        return f'RuleDef(is_override={self.is_override!r}, is_ignored={self.is_ignored!r}, name={self.name!r}, params={self.params!r}, expr={self.expr!r})'

    @staticmethod
    def parse(text, pos=0, fullparse=True):
        return _run(text, pos, _try_RuleDef, fullparse)


def _parse_function_113(_text, _pos):
    # Begin Choice
    farthest_err6 = _raise_error113
    farthest_pos6 = _pos
    while True:
        # Option 1:
        # Begin Str
        value13 = '=>'
        end13 = (_pos + 2)
        if (_text[slice(_pos, end13, None)] == value13):
            _result = value13
            _pos = (yield (3, _try__ignored, end13))[2]
            _status = True
        else:
            _result = _raise_error114
            _status = False
        # End Str
        if _status:
            break
        # Option 2:
        # Begin Str
        value14 = '='
        end14 = (_pos + 1)
        if (_text[slice(_pos, end14, None)] == value14):
            _result = value14
            _pos = (yield (3, _try__ignored, end14))[2]
            _status = True
        else:
            _result = _raise_error115
            _status = False
        # End Str
        if _status:
            break
        # Option 3:
        # Begin Str
        value15 = ':'
        end15 = (_pos + 1)
        if (_text[slice(_pos, end15, None)] == value15):
            _result = value15
            _pos = (yield (3, _try__ignored, end15))[2]
            _status = True
        else:
            _result = _raise_error116
            _status = False
        # End Str
        if _status:
            break
        _pos = farthest_pos6
        _result = farthest_err6
        break
    # End Choice
    yield (_status, _result, _pos)

def _try_RuleDef(_text, _pos):
    # Begin Seq
    start_pos5 = _pos
    while True:
        # Begin Apply
        # Opt(OverrideKeyword) |> `bool`
        # Begin Opt
        # Opt(OverrideKeyword)
        backtrack5 = _pos
        # Begin Ref
        (_status, _result, _pos) = (yield (3, _try_OverrideKeyword, _pos))
        # End Ref
        if not (_status):
            _pos = backtrack5
            _result = None
            _status = True
        # End Opt
        arg11 = _result
        _result = bool
        _status = True
        _result = _result(arg11)
        # End Apply
        is_override = _result
        # Begin Apply
        # Opt(IgnoreKeyword) |> `bool`
        # Begin Opt
        # Opt(IgnoreKeyword)
        backtrack6 = _pos
        # Begin Ref
        (_status, _result, _pos) = (yield (3, _try_IgnoreKeyword, _pos))
        # End Ref
        if not (_status):
            _pos = backtrack6
            _result = None
            _status = True
        # End Opt
        arg12 = _result
        _result = bool
        _status = True
        _result = _result(arg12)
        # End Apply
        is_ignored = _result
        # Begin Ref
        (_status, _result, _pos) = (yield (3, _try_Name, _pos))
        # End Ref
        if not (_status):
            break
        name = _result
        # Begin Discard
        # Opt(Params) << wrap('=>' | '=' | ':')
        while True:
            # Begin Opt
            # Opt(Params)
            backtrack7 = _pos
            # Begin Ref
            (_status, _result, _pos) = (yield (3, _try_Params, _pos))
            # End Ref
            if not (_status):
                _pos = backtrack7
                _result = None
                _status = True
            # End Opt
            staging6 = _result
            # Begin Call
            # wrap('=>' | '=' | ':')
            func8 = _ParseFunction(_try_wrap, (_parse_function_113,), ())
            (_status, _result, _pos) = (yield (3, func8, _pos))
            # End Call
            if _status:
                _result = staging6
            break
        # End Discard
        if not (_status):
            break
        params = _result
        # Begin Ref
        (_status, _result, _pos) = (yield (3, _try_Expr, _pos))
        # End Ref
        if not (_status):
            break
        expr = _result
        _result = RuleDef(is_override, is_ignored, name, params, expr)
        _result._metadata.position_info = (start_pos5, _pos)
        break
    # End Seq
    yield (_status, _result, _pos)

def _raise_error113(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'RuleDef' rule, at the expression:\n"
    "    '=>' | '=' | ':'\n\n"
    'Unexpected input'
    )
    raise ParseError((title + details), _pos, line, col)

def _raise_error114(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'RuleDef' rule, at the expression:\n"
    "    '=>'\n\n"
    "Expected to match the string '=>'"
    )
    raise ParseError((title + details), _pos, line, col)

def _raise_error115(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'RuleDef' rule, at the expression:\n"
    "    '='\n\n"
    "Expected to match the string '='"
    )
    raise ParseError((title + details), _pos, line, col)

def _raise_error116(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'RuleDef' rule, at the expression:\n"
    "    ':'\n\n"
    "Expected to match the string ':'"
    )
    raise ParseError((title + details), _pos, line, col)

class ClassDef(Node):
    """
    class ClassDef {
        name: kw('class') >> Name
        params: Opt(Params)
        members: (wrap('{') >> (ClassMember /? LineSep)) << '}'
    }
    """
    _fields = ('name', 'params', 'members')

    def __init__(self, name, params, members):
        Node.__init__(self)
        self.name = name
        self.params = params
        self.members = members

    def __repr__(self):
        return f'ClassDef(name={self.name!r}, params={self.params!r}, members={self.members!r})'

    @staticmethod
    def parse(text, pos=0, fullparse=True):
        return _run(text, pos, _try_ClassDef, fullparse)


def _parse_function_125(_text, _pos):
    # Begin Str
    value16 = 'class'
    end16 = (_pos + 5)
    if (_text[slice(_pos, end16, None)] == value16):
        _result = value16
        _pos = (yield (3, _try__ignored, end16))[2]
        _status = True
    else:
        _result = _raise_error125
        _status = False
    # End Str
    yield (_status, _result, _pos)

def _parse_function_135(_text, _pos):
    # Begin Str
    value17 = '{'
    end17 = (_pos + 1)
    if (_text[slice(_pos, end17, None)] == value17):
        _result = value17
        _pos = (yield (3, _try__ignored, end17))[2]
        _status = True
    else:
        _result = _raise_error135
        _status = False
    # End Str
    yield (_status, _result, _pos)

def _try_ClassDef(_text, _pos):
    # Begin Seq
    start_pos6 = _pos
    while True:
        # Begin Discard
        # kw('class') >> Name
        while True:
            # Begin Call
            # kw('class')
            arg13 = _wrap_string_literal('class', _parse_function_125)
            func9 = _ParseFunction(_try_kw, (arg13,), ())
            (_status, _result, _pos) = (yield (3, func9, _pos))
            # End Call
            if not (_status):
                break
            # Begin Ref
            (_status, _result, _pos) = (yield (3, _try_Name, _pos))
            # End Ref
            break
        # End Discard
        if not (_status):
            break
        name = _result
        # Begin Opt
        # Opt(Params)
        backtrack8 = _pos
        # Begin Ref
        (_status, _result, _pos) = (yield (3, _try_Params, _pos))
        # End Ref
        if not (_status):
            _pos = backtrack8
            _result = None
            _status = True
        # End Opt
        params = _result
        # Begin Discard
        # (wrap('{') >> (ClassMember /? LineSep)) << '}'
        while True:
            # Begin Discard
            # wrap('{') >> (ClassMember /? LineSep)
            while True:
                # Begin Call
                # wrap('{')
                arg14 = _wrap_string_literal('{', _parse_function_135)
                func10 = _ParseFunction(_try_wrap, (arg14,), ())
                (_status, _result, _pos) = (yield (3, func10, _pos))
                # End Call
                if not (_status):
                    break
                # Begin Sep
                # ClassMember /? LineSep
                staging7 = []
                checkpoint6 = _pos
                while True:
                    # Begin Ref
                    (_status, _result, _pos) = (yield (3, _try_ClassMember, _pos))
                    # End Ref
                    if not (_status):
                        break
                    staging7.append(_result)
                    checkpoint6 = _pos
                    # Begin Ref
                    (_status, _result, _pos) = (yield (3, _try_LineSep, _pos))
                    # End Ref
                    if not (_status):
                        break
                    checkpoint6 = _pos
                _result = staging7
                _pos = checkpoint6
                _status = True
                # End Sep
                break
            # End Discard
            if not (_status):
                break
            staging8 = _result
            # Begin Str
            value18 = '}'
            end18 = (_pos + 1)
            if (_text[slice(_pos, end18, None)] == value18):
                _result = value18
                _pos = (yield (3, _try__ignored, end18))[2]
                _status = True
            else:
                _result = _raise_error139
                _status = False
            # End Str
            if _status:
                _result = staging8
            break
        # End Discard
        if not (_status):
            break
        members = _result
        _result = ClassDef(name, params, members)
        _result._metadata.position_info = (start_pos6, _pos)
        break
    # End Seq
    yield (_status, _result, _pos)

def _raise_error125(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'ClassDef' rule, at the expression:\n"
    "    'class'\n\n"
    "Expected to match the string 'class'"
    )
    raise ParseError((title + details), _pos, line, col)

def _raise_error135(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'ClassDef' rule, at the expression:\n"
    "    '{'\n\n"
    "Expected to match the string '{'"
    )
    raise ParseError((title + details), _pos, line, col)

def _raise_error139(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'ClassDef' rule, at the expression:\n"
    "    '}'\n\n"
    "Expected to match the string '}'"
    )
    raise ParseError((title + details), _pos, line, col)

class ClassMember(Node):
    """
    class ClassMember {
        is_omitted: Opt('let') |> `bool`
        name: Name << wrap('=>' | '=' | ':')
        expr: Expr
    }
    """
    _fields = ('is_omitted', 'name', 'expr')

    def __init__(self, is_omitted, name, expr):
        Node.__init__(self)
        self.is_omitted = is_omitted
        self.name = name
        self.expr = expr

    def __repr__(self):
        return f'ClassMember(is_omitted={self.is_omitted!r}, name={self.name!r}, expr={self.expr!r})'

    @staticmethod
    def parse(text, pos=0, fullparse=True):
        return _run(text, pos, _try_ClassMember, fullparse)


def _parse_function_152(_text, _pos):
    # Begin Choice
    farthest_err7 = _raise_error152
    farthest_pos7 = _pos
    while True:
        # Option 1:
        # Begin Str
        value20 = '=>'
        end20 = (_pos + 2)
        if (_text[slice(_pos, end20, None)] == value20):
            _result = value20
            _pos = (yield (3, _try__ignored, end20))[2]
            _status = True
        else:
            _result = _raise_error153
            _status = False
        # End Str
        if _status:
            break
        # Option 2:
        # Begin Str
        value21 = '='
        end21 = (_pos + 1)
        if (_text[slice(_pos, end21, None)] == value21):
            _result = value21
            _pos = (yield (3, _try__ignored, end21))[2]
            _status = True
        else:
            _result = _raise_error154
            _status = False
        # End Str
        if _status:
            break
        # Option 3:
        # Begin Str
        value22 = ':'
        end22 = (_pos + 1)
        if (_text[slice(_pos, end22, None)] == value22):
            _result = value22
            _pos = (yield (3, _try__ignored, end22))[2]
            _status = True
        else:
            _result = _raise_error155
            _status = False
        # End Str
        if _status:
            break
        _pos = farthest_pos7
        _result = farthest_err7
        break
    # End Choice
    yield (_status, _result, _pos)

def _try_ClassMember(_text, _pos):
    # Begin Seq
    start_pos7 = _pos
    while True:
        # Begin Apply
        # Opt('let') |> `bool`
        # Begin Opt
        # Opt('let')
        backtrack9 = _pos
        # Begin Str
        value19 = 'let'
        end19 = (_pos + 3)
        if (_text[slice(_pos, end19, None)] == value19):
            _result = value19
            _pos = (yield (3, _try__ignored, end19))[2]
            _status = True
        else:
            _result = _raise_error145
            _status = False
        # End Str
        if not (_status):
            _pos = backtrack9
            _result = None
            _status = True
        # End Opt
        arg15 = _result
        _result = bool
        _status = True
        _result = _result(arg15)
        # End Apply
        is_omitted = _result
        # Begin Discard
        # Name << wrap('=>' | '=' | ':')
        while True:
            # Begin Ref
            (_status, _result, _pos) = (yield (3, _try_Name, _pos))
            # End Ref
            if not (_status):
                break
            staging9 = _result
            # Begin Call
            # wrap('=>' | '=' | ':')
            func11 = _ParseFunction(_try_wrap, (_parse_function_152,), ())
            (_status, _result, _pos) = (yield (3, func11, _pos))
            # End Call
            if _status:
                _result = staging9
            break
        # End Discard
        if not (_status):
            break
        name = _result
        # Begin Ref
        (_status, _result, _pos) = (yield (3, _try_Expr, _pos))
        # End Ref
        if not (_status):
            break
        expr = _result
        _result = ClassMember(is_omitted, name, expr)
        _result._metadata.position_info = (start_pos7, _pos)
        break
    # End Seq
    yield (_status, _result, _pos)

def _raise_error145(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'ClassMember' rule, at the expression:\n"
    "    'let'\n\n"
    "Expected to match the string 'let'"
    )
    raise ParseError((title + details), _pos, line, col)

def _raise_error152(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'ClassMember' rule, at the expression:\n"
    "    '=>' | '=' | ':'\n\n"
    'Unexpected input'
    )
    raise ParseError((title + details), _pos, line, col)

def _raise_error153(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'ClassMember' rule, at the expression:\n"
    "    '=>'\n\n"
    "Expected to match the string '=>'"
    )
    raise ParseError((title + details), _pos, line, col)

def _raise_error154(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'ClassMember' rule, at the expression:\n"
    "    '='\n\n"
    "Expected to match the string '='"
    )
    raise ParseError((title + details), _pos, line, col)

def _raise_error155(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'ClassMember' rule, at the expression:\n"
    "    ':'\n\n"
    "Expected to match the string ':'"
    )
    raise ParseError((title + details), _pos, line, col)

class IgnoreStmt(Node):
    """
    class IgnoreStmt {
        expr: IgnoreKeyword >> Expr
    }
    """
    _fields = ('expr',)

    def __init__(self, expr):
        Node.__init__(self)
        self.expr = expr

    def __repr__(self):
        return f'IgnoreStmt(expr={self.expr!r})'

    @staticmethod
    def parse(text, pos=0, fullparse=True):
        return _run(text, pos, _try_IgnoreStmt, fullparse)


def _try_IgnoreStmt(_text, _pos):
    # Begin Seq
    start_pos8 = _pos
    while True:
        # Begin Discard
        # IgnoreKeyword >> Expr
        while True:
            # Begin Ref
            (_status, _result, _pos) = (yield (3, _try_IgnoreKeyword, _pos))
            # End Ref
            if not (_status):
                break
            # Begin Ref
            (_status, _result, _pos) = (yield (3, _try_Expr, _pos))
            # End Ref
            break
        # End Discard
        if not (_status):
            break
        expr = _result
        _result = IgnoreStmt(expr)
        _result._metadata.position_info = (start_pos8, _pos)
        break
    # End Seq
    yield (_status, _result, _pos)

class GrammarDef(Node):
    """
    class GrammarDef {
        head: Opt(GrammarHead << Skip(Newline))
        body: ManyStmts | SingleExpr
    }
    """
    _fields = ('head', 'body')

    def __init__(self, head, body):
        Node.__init__(self)
        self.head = head
        self.body = body

    def __repr__(self):
        return f'GrammarDef(head={self.head!r}, body={self.body!r})'

    @staticmethod
    def parse(text, pos=0, fullparse=True):
        return _run(text, pos, _try_GrammarDef, fullparse)


def _try_GrammarDef(_text, _pos):
    # Begin Seq
    start_pos9 = _pos
    while True:
        # Begin Opt
        # Opt(GrammarHead << Skip(Newline))
        backtrack10 = _pos
        # Begin Discard
        # GrammarHead << Skip(Newline)
        while True:
            # Begin Ref
            (_status, _result, _pos) = (yield (3, _try_GrammarHead, _pos))
            # End Ref
            if not (_status):
                break
            staging10 = _result
            # Begin Skip
            # Skip(Newline)
            while True:
                checkpoint7 = _pos
                # Begin Ref
                (_status, _result, _pos) = (yield (3, _try_Newline, _pos))
                # End Ref
                if _status:
                    continue
                else:
                    _pos = checkpoint7
                break
            _result = None
            _status = True
            # End Skip
            _result = staging10
            break
        # End Discard
        if not (_status):
            _pos = backtrack10
            _result = None
            _status = True
        # End Opt
        head = _result
        # Begin Choice
        farthest_err8 = _raise_error173
        backtrack11 = farthest_pos8 = _pos
        while True:
            # Option 1:
            # Begin Ref
            (_status, _result, _pos) = (yield (3, _try_ManyStmts, _pos))
            # End Ref
            if _status:
                break
            if (farthest_pos8 < _pos):
                farthest_pos8 = _pos
                farthest_err8 = _result
            _pos = backtrack11
            # Option 2:
            # Begin Ref
            (_status, _result, _pos) = (yield (3, _try_SingleExpr, _pos))
            # End Ref
            if _status:
                break
            if (farthest_pos8 < _pos):
                farthest_pos8 = _pos
                farthest_err8 = _result
            _pos = farthest_pos8
            _result = farthest_err8
            break
        # End Choice
        if not (_status):
            break
        body = _result
        _result = GrammarDef(head, body)
        _result._metadata.position_info = (start_pos9, _pos)
        break
    # End Seq
    yield (_status, _result, _pos)

def _raise_error173(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'GrammarDef' rule, at the expression:\n"
    '    ManyStmts | SingleExpr\n\n'
    'Unexpected input'
    )
    raise ParseError((title + details), _pos, line, col)

class GrammarHead(Node):
    """
    class GrammarHead {
        name: kw('grammar') >> QualifiedName
        extends: Opt(kw('extends') >> QualifiedName)
    }
    """
    _fields = ('name', 'extends')

    def __init__(self, name, extends):
        Node.__init__(self)
        self.name = name
        self.extends = extends

    def __repr__(self):
        return f'GrammarHead(name={self.name!r}, extends={self.extends!r})'

    @staticmethod
    def parse(text, pos=0, fullparse=True):
        return _run(text, pos, _try_GrammarHead, fullparse)


def _parse_function_182(_text, _pos):
    # Begin Str
    value23 = 'grammar'
    end23 = (_pos + 7)
    if (_text[slice(_pos, end23, None)] == value23):
        _result = value23
        _pos = (yield (3, _try__ignored, end23))[2]
        _status = True
    else:
        _result = _raise_error182
        _status = False
    # End Str
    yield (_status, _result, _pos)

def _parse_function_189(_text, _pos):
    # Begin Str
    value24 = 'extends'
    end24 = (_pos + 7)
    if (_text[slice(_pos, end24, None)] == value24):
        _result = value24
        _pos = (yield (3, _try__ignored, end24))[2]
        _status = True
    else:
        _result = _raise_error189
        _status = False
    # End Str
    yield (_status, _result, _pos)

def _try_GrammarHead(_text, _pos):
    # Begin Seq
    start_pos10 = _pos
    while True:
        # Begin Discard
        # kw('grammar') >> QualifiedName
        while True:
            # Begin Call
            # kw('grammar')
            arg16 = _wrap_string_literal('grammar', _parse_function_182)
            func12 = _ParseFunction(_try_kw, (arg16,), ())
            (_status, _result, _pos) = (yield (3, func12, _pos))
            # End Call
            if not (_status):
                break
            # Begin Ref
            (_status, _result, _pos) = (yield (3, _try_QualifiedName, _pos))
            # End Ref
            break
        # End Discard
        if not (_status):
            break
        name = _result
        # Begin Opt
        # Opt(kw('extends') >> QualifiedName)
        backtrack12 = _pos
        # Begin Discard
        # kw('extends') >> QualifiedName
        while True:
            # Begin Call
            # kw('extends')
            arg17 = _wrap_string_literal('extends', _parse_function_189)
            func13 = _ParseFunction(_try_kw, (arg17,), ())
            (_status, _result, _pos) = (yield (3, func13, _pos))
            # End Call
            if not (_status):
                break
            # Begin Ref
            (_status, _result, _pos) = (yield (3, _try_QualifiedName, _pos))
            # End Ref
            break
        # End Discard
        if not (_status):
            _pos = backtrack12
            _result = None
            _status = True
        # End Opt
        extends = _result
        _result = GrammarHead(name, extends)
        _result._metadata.position_info = (start_pos10, _pos)
        break
    # End Seq
    yield (_status, _result, _pos)

def _raise_error182(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'GrammarHead' rule, at the expression:\n"
    "    'grammar'\n\n"
    "Expected to match the string 'grammar'"
    )
    raise ParseError((title + details), _pos, line, col)

def _raise_error189(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'GrammarHead' rule, at the expression:\n"
    "    'extends'\n\n"
    "Expected to match the string 'extends'"
    )
    raise ParseError((title + details), _pos, line, col)

def _try_Stmt(_text, _pos):
    # Rule 'Stmt'
    # Begin Choice
    farthest_err9 = _raise_error192
    backtrack13 = farthest_pos9 = _pos
    while True:
        # Option 1:
        # Begin Ref
        (_status, _result, _pos) = (yield (3, _try_ClassDef, _pos))
        # End Ref
        if _status:
            break
        if (farthest_pos9 < _pos):
            farthest_pos9 = _pos
            farthest_err9 = _result
        _pos = backtrack13
        # Option 2:
        # Begin Ref
        (_status, _result, _pos) = (yield (3, _try_RuleDef, _pos))
        # End Ref
        if _status:
            break
        if (farthest_pos9 < _pos):
            farthest_pos9 = _pos
            farthest_err9 = _result
        _pos = backtrack13
        # Option 3:
        # Begin Ref
        (_status, _result, _pos) = (yield (3, _try_IgnoreStmt, _pos))
        # End Ref
        if _status:
            break
        if (farthest_pos9 < _pos):
            farthest_pos9 = _pos
            farthest_err9 = _result
        _pos = backtrack13
        # Option 4:
        # Begin Ref
        (_status, _result, _pos) = (yield (3, _try_PythonSection, _pos))
        # End Ref
        if _status:
            break
        if (farthest_pos9 < _pos):
            farthest_pos9 = _pos
            farthest_err9 = _result
        _pos = backtrack13
        # Option 5:
        # Begin Ref
        (_status, _result, _pos) = (yield (3, _try_PythonExpression, _pos))
        # End Ref
        if _status:
            break
        if (farthest_pos9 < _pos):
            farthest_pos9 = _pos
            farthest_err9 = _result
        _pos = farthest_pos9
        _result = farthest_err9
        break
    # End Choice
    yield (_status, _result, _pos)

def _parse_Stmt(text, pos=0, fullparse=True):
    return _run(text, pos, _try_Stmt, fullparse)

Stmt = Rule('Stmt', _parse_Stmt, """
    Stmt = ClassDef | RuleDef | IgnoreStmt | PythonSection | PythonExpression
""")
def _raise_error192(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Stmt' rule, at the expression:\n"
    '    ClassDef | RuleDef | IgnoreStmt | PythonSection | PythonExpression\n\n'
    'Unexpected input'
    )
    raise ParseError((title + details), _pos, line, col)

class LetExpression(Node):
    """
    class LetExpression {
        name: (kw('let') >> Name) << wrap('=>' | '=' | ':')
        expr: Expr << wrap(kw('in'))
        body: Expr
    }
    """
    _fields = ('name', 'expr', 'body')

    def __init__(self, name, expr, body):
        Node.__init__(self)
        self.name = name
        self.expr = expr
        self.body = body

    def __repr__(self):
        return f'LetExpression(name={self.name!r}, expr={self.expr!r}, body={self.body!r})'

    @staticmethod
    def parse(text, pos=0, fullparse=True):
        return _run(text, pos, _try_LetExpression, fullparse)


def _parse_function_205(_text, _pos):
    # Begin Str
    value25 = 'let'
    end25 = (_pos + 3)
    if (_text[slice(_pos, end25, None)] == value25):
        _result = value25
        _pos = (yield (3, _try__ignored, end25))[2]
        _status = True
    else:
        _result = _raise_error205
        _status = False
    # End Str
    yield (_status, _result, _pos)

def _parse_function_209(_text, _pos):
    # Begin Choice
    farthest_err10 = _raise_error209
    farthest_pos10 = _pos
    while True:
        # Option 1:
        # Begin Str
        value26 = '=>'
        end26 = (_pos + 2)
        if (_text[slice(_pos, end26, None)] == value26):
            _result = value26
            _pos = (yield (3, _try__ignored, end26))[2]
            _status = True
        else:
            _result = _raise_error210
            _status = False
        # End Str
        if _status:
            break
        # Option 2:
        # Begin Str
        value27 = '='
        end27 = (_pos + 1)
        if (_text[slice(_pos, end27, None)] == value27):
            _result = value27
            _pos = (yield (3, _try__ignored, end27))[2]
            _status = True
        else:
            _result = _raise_error211
            _status = False
        # End Str
        if _status:
            break
        # Option 3:
        # Begin Str
        value28 = ':'
        end28 = (_pos + 1)
        if (_text[slice(_pos, end28, None)] == value28):
            _result = value28
            _pos = (yield (3, _try__ignored, end28))[2]
            _status = True
        else:
            _result = _raise_error212
            _status = False
        # End Str
        if _status:
            break
        _pos = farthest_pos10
        _result = farthest_err10
        break
    # End Choice
    yield (_status, _result, _pos)

def _parse_function_220(_text, _pos):
    # Begin Str
    value29 = 'in'
    end29 = (_pos + 2)
    if (_text[slice(_pos, end29, None)] == value29):
        _result = value29
        _pos = (yield (3, _try__ignored, end29))[2]
        _status = True
    else:
        _result = _raise_error220
        _status = False
    # End Str
    yield (_status, _result, _pos)

def _parse_function_218(_text, _pos):
    # Begin Call
    # kw('in')
    arg19 = _wrap_string_literal('in', _parse_function_220)
    func16 = _ParseFunction(_try_kw, (arg19,), ())
    (_status, _result, _pos) = (yield (3, func16, _pos))
    # End Call
    yield (_status, _result, _pos)

def _try_LetExpression(_text, _pos):
    # Begin Seq
    start_pos11 = _pos
    while True:
        # Begin Discard
        # (kw('let') >> Name) << wrap('=>' | '=' | ':')
        while True:
            # Begin Discard
            # kw('let') >> Name
            while True:
                # Begin Call
                # kw('let')
                arg18 = _wrap_string_literal('let', _parse_function_205)
                func14 = _ParseFunction(_try_kw, (arg18,), ())
                (_status, _result, _pos) = (yield (3, func14, _pos))
                # End Call
                if not (_status):
                    break
                # Begin Ref
                (_status, _result, _pos) = (yield (3, _try_Name, _pos))
                # End Ref
                break
            # End Discard
            if not (_status):
                break
            staging11 = _result
            # Begin Call
            # wrap('=>' | '=' | ':')
            func15 = _ParseFunction(_try_wrap, (_parse_function_209,), ())
            (_status, _result, _pos) = (yield (3, func15, _pos))
            # End Call
            if _status:
                _result = staging11
            break
        # End Discard
        if not (_status):
            break
        name = _result
        # Begin Discard
        # Expr << wrap(kw('in'))
        while True:
            # Begin Ref
            (_status, _result, _pos) = (yield (3, _try_Expr, _pos))
            # End Ref
            if not (_status):
                break
            staging12 = _result
            # Begin Call
            # wrap(kw('in'))
            func17 = _ParseFunction(_try_wrap, (_parse_function_218,), ())
            (_status, _result, _pos) = (yield (3, func17, _pos))
            # End Call
            if _status:
                _result = staging12
            break
        # End Discard
        if not (_status):
            break
        expr = _result
        # Begin Ref
        (_status, _result, _pos) = (yield (3, _try_Expr, _pos))
        # End Ref
        if not (_status):
            break
        body = _result
        _result = LetExpression(name, expr, body)
        _result._metadata.position_info = (start_pos11, _pos)
        break
    # End Seq
    yield (_status, _result, _pos)

def _raise_error205(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'LetExpression' rule, at the expression:\n"
    "    'let'\n\n"
    "Expected to match the string 'let'"
    )
    raise ParseError((title + details), _pos, line, col)

def _raise_error209(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'LetExpression' rule, at the expression:\n"
    "    '=>' | '=' | ':'\n\n"
    'Unexpected input'
    )
    raise ParseError((title + details), _pos, line, col)

def _raise_error210(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'LetExpression' rule, at the expression:\n"
    "    '=>'\n\n"
    "Expected to match the string '=>'"
    )
    raise ParseError((title + details), _pos, line, col)

def _raise_error211(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'LetExpression' rule, at the expression:\n"
    "    '='\n\n"
    "Expected to match the string '='"
    )
    raise ParseError((title + details), _pos, line, col)

def _raise_error212(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'LetExpression' rule, at the expression:\n"
    "    ':'\n\n"
    "Expected to match the string ':'"
    )
    raise ParseError((title + details), _pos, line, col)

def _raise_error220(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'LetExpression' rule, at the expression:\n"
    "    'in'\n\n"
    "Expected to match the string 'in'"
    )
    raise ParseError((title + details), _pos, line, col)

class Ref(Node):
    """
    class Ref {
        value: Name
    }
    """
    _fields = ('value',)

    def __init__(self, value):
        Node.__init__(self)
        self.value = value

    def __repr__(self):
        return f'Ref(value={self.value!r})'

    @staticmethod
    def parse(text, pos=0, fullparse=True):
        return _run(text, pos, _try_Ref, fullparse)


def _try_Ref(_text, _pos):
    # Begin Seq
    start_pos12 = _pos
    while True:
        # Begin Ref
        (_status, _result, _pos) = (yield (3, _try_Name, _pos))
        # End Ref
        if not (_status):
            break
        value = _result
        _result = Ref(value)
        _result._metadata.position_info = (start_pos12, _pos)
        break
    # End Seq
    yield (_status, _result, _pos)

class ListLiteral(Node):
    """
    class ListLiteral {
        elements: ('[' >> (wrap(Expr) /? Comma)) << ']'
    }
    """
    _fields = ('elements',)

    def __init__(self, elements):
        Node.__init__(self)
        self.elements = elements

    def __repr__(self):
        return f'ListLiteral(elements={self.elements!r})'

    @staticmethod
    def parse(text, pos=0, fullparse=True):
        return _run(text, pos, _try_ListLiteral, fullparse)


def _try_ListLiteral(_text, _pos):
    # Begin Seq
    start_pos13 = _pos
    while True:
        # Begin Discard
        # ('[' >> (wrap(Expr) /? Comma)) << ']'
        while True:
            # Begin Discard
            # '[' >> (wrap(Expr) /? Comma)
            while True:
                # Begin Str
                value30 = '['
                end30 = (_pos + 1)
                if (_text[slice(_pos, end30, None)] == value30):
                    _result = value30
                    _pos = (yield (3, _try__ignored, end30))[2]
                    _status = True
                else:
                    _result = _raise_error232
                    _status = False
                # End Str
                if not (_status):
                    break
                # Begin Sep
                # wrap(Expr) /? Comma
                staging13 = []
                checkpoint8 = _pos
                while True:
                    # Begin Call
                    # wrap(Expr)
                    func18 = _ParseFunction(_try_wrap, (_try_Expr,), ())
                    (_status, _result, _pos) = (yield (3, func18, _pos))
                    # End Call
                    if not (_status):
                        break
                    staging13.append(_result)
                    checkpoint8 = _pos
                    # Begin Ref
                    (_status, _result, _pos) = (yield (3, _try_Comma, _pos))
                    # End Ref
                    if not (_status):
                        break
                    checkpoint8 = _pos
                _result = staging13
                _pos = checkpoint8
                _status = True
                # End Sep
                break
            # End Discard
            if not (_status):
                break
            staging14 = _result
            # Begin Str
            value31 = ']'
            end31 = (_pos + 1)
            if (_text[slice(_pos, end31, None)] == value31):
                _result = value31
                _pos = (yield (3, _try__ignored, end31))[2]
                _status = True
            else:
                _result = _raise_error238
                _status = False
            # End Str
            if _status:
                _result = staging14
            break
        # End Discard
        if not (_status):
            break
        elements = _result
        _result = ListLiteral(elements)
        _result._metadata.position_info = (start_pos13, _pos)
        break
    # End Seq
    yield (_status, _result, _pos)

def _raise_error232(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'ListLiteral' rule, at the expression:\n"
    "    '['\n\n"
    "Expected to match the string '['"
    )
    raise ParseError((title + details), _pos, line, col)

def _raise_error238(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'ListLiteral' rule, at the expression:\n"
    "    ']'\n\n"
    "Expected to match the string ']'"
    )
    raise ParseError((title + details), _pos, line, col)

class ByteLiteral(Node):
    """
    class ByteLiteral {
        prefix: /0[xX]/
        value: /[0-9a-fA-F]{2}/ |> `lambda x: int(x, 16)`
    }
    """
    _fields = ('prefix', 'value')

    def __init__(self, prefix, value):
        Node.__init__(self)
        self.prefix = prefix
        self.value = value

    def __repr__(self):
        return f'ByteLiteral(prefix={self.prefix!r}, value={self.value!r})'

    @staticmethod
    def parse(text, pos=0, fullparse=True):
        return _run(text, pos, _try_ByteLiteral, fullparse)


def _try_ByteLiteral(_text, _pos):
    # Begin Seq
    start_pos14 = _pos
    while True:
        # Begin Regex
        # /0[xX]/
        match13 = matcher13(_text, _pos)
        if match13:
            _result = match13.group(0)
            _pos = (yield (3, _try__ignored, match13.end()))[2]
            _status = True
        else:
            _result = _raise_error242
            _status = False
        # End Regex
        if not (_status):
            break
        prefix = _result
        # Begin Apply
        # /[0-9a-fA-F]{2}/ |> `lambda x: int(x, 16)`
        # Begin Regex
        # /[0-9a-fA-F]{2}/
        match14 = matcher14(_text, _pos)
        if match14:
            _result = match14.group(0)
            _pos = (yield (3, _try__ignored, match14.end()))[2]
            _status = True
        else:
            _result = _raise_error245
            _status = False
        # End Regex
        if _status:
            arg20 = _result
            _result = lambda x: int(x, 16)
            _status = True
            _result = _result(arg20)
        # End Apply
        if not (_status):
            break
        value = _result
        _result = ByteLiteral(prefix, value)
        _result._metadata.position_info = (start_pos14, _pos)
        break
    # End Seq
    yield (_status, _result, _pos)

def _raise_error242(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'ByteLiteral' rule, at the expression:\n"
    '    /0[xX]/\n\n'
    'Expected to match the regular expression /0[xX]/'
    )
    raise ParseError((title + details), _pos, line, col)

def _raise_error245(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'ByteLiteral' rule, at the expression:\n"
    '    /[0-9a-fA-F]{2}/\n\n'
    'Expected to match the regular expression /[0-9a-fA-F]{2}/'
    )
    raise ParseError((title + details), _pos, line, col)

def _try_Atom(_text, _pos):
    # Rule 'Atom'
    # Begin Choice
    farthest_err11 = _raise_error248
    backtrack14 = farthest_pos11 = _pos
    while True:
        # Option 1:
        # Begin Ref
        (_status, _result, _pos) = (yield (3, _try_StringLiteral, _pos))
        # End Ref
        if _status:
            break
        if (farthest_pos11 < _pos):
            farthest_pos11 = _pos
            farthest_err11 = _result
        _pos = backtrack14
        # Option 2:
        # Begin Ref
        (_status, _result, _pos) = (yield (3, _try_RegexLiteral, _pos))
        # End Ref
        if _status:
            break
        if (farthest_pos11 < _pos):
            farthest_pos11 = _pos
            farthest_err11 = _result
        _pos = backtrack14
        # Option 3:
        # Begin Ref
        (_status, _result, _pos) = (yield (3, _try_LetExpression, _pos))
        # End Ref
        if _status:
            break
        if (farthest_pos11 < _pos):
            farthest_pos11 = _pos
            farthest_err11 = _result
        _pos = backtrack14
        # Option 4:
        # Begin Ref
        (_status, _result, _pos) = (yield (3, _try_ListLiteral, _pos))
        # End Ref
        if _status:
            break
        if (farthest_pos11 < _pos):
            farthest_pos11 = _pos
            farthest_err11 = _result
        _pos = backtrack14
        # Option 5:
        # Begin Ref
        (_status, _result, _pos) = (yield (3, _try_ByteLiteral, _pos))
        # End Ref
        if _status:
            break
        if (farthest_pos11 < _pos):
            farthest_pos11 = _pos
            farthest_err11 = _result
        _pos = backtrack14
        # Option 6:
        # Begin Ref
        (_status, _result, _pos) = (yield (3, _try_PythonExpression, _pos))
        # End Ref
        if _status:
            break
        if (farthest_pos11 < _pos):
            farthest_pos11 = _pos
            farthest_err11 = _result
        _pos = backtrack14
        # Option 7:
        # Begin Ref
        (_status, _result, _pos) = (yield (3, _try_Ref, _pos))
        # End Ref
        if _status:
            break
        if (farthest_pos11 < _pos):
            farthest_pos11 = _pos
            farthest_err11 = _result
        _pos = farthest_pos11
        _result = farthest_err11
        break
    # End Choice
    yield (_status, _result, _pos)

def _parse_Atom(text, pos=0, fullparse=True):
    return _run(text, pos, _try_Atom, fullparse)

Atom = Rule('Atom', _parse_Atom, """
    Atom = StringLiteral | RegexLiteral | LetExpression | ListLiteral | ByteLiteral | PythonExpression | Ref
""")
def _raise_error248(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Atom' rule, at the expression:\n"
    '    StringLiteral | RegexLiteral | LetExpression | ListLiteral | ByteLiteral | PythonExpression | Ref\n\n'
    'Unexpected input'
    )
    raise ParseError((title + details), _pos, line, col)

class KeywordArg(Node):
    """
    class KeywordArg {
        name: Name << ('=>' | '=' | ':')
        expr: Expr
    }
    """
    _fields = ('name', 'expr')

    def __init__(self, name, expr):
        Node.__init__(self)
        self.name = name
        self.expr = expr

    def __repr__(self):
        return f'KeywordArg(name={self.name!r}, expr={self.expr!r})'

    @staticmethod
    def parse(text, pos=0, fullparse=True):
        return _run(text, pos, _try_KeywordArg, fullparse)


def _try_KeywordArg(_text, _pos):
    # Begin Seq
    start_pos15 = _pos
    while True:
        # Begin Discard
        # Name << ('=>' | '=' | ':')
        while True:
            # Begin Ref
            (_status, _result, _pos) = (yield (3, _try_Name, _pos))
            # End Ref
            if not (_status):
                break
            staging15 = _result
            # Begin Choice
            farthest_err12 = _raise_error261
            farthest_pos12 = _pos
            while True:
                # Option 1:
                # Begin Str
                value32 = '=>'
                end32 = (_pos + 2)
                if (_text[slice(_pos, end32, None)] == value32):
                    _result = value32
                    _pos = (yield (3, _try__ignored, end32))[2]
                    _status = True
                else:
                    _result = _raise_error262
                    _status = False
                # End Str
                if _status:
                    break
                # Option 2:
                # Begin Str
                value33 = '='
                end33 = (_pos + 1)
                if (_text[slice(_pos, end33, None)] == value33):
                    _result = value33
                    _pos = (yield (3, _try__ignored, end33))[2]
                    _status = True
                else:
                    _result = _raise_error263
                    _status = False
                # End Str
                if _status:
                    break
                # Option 3:
                # Begin Str
                value34 = ':'
                end34 = (_pos + 1)
                if (_text[slice(_pos, end34, None)] == value34):
                    _result = value34
                    _pos = (yield (3, _try__ignored, end34))[2]
                    _status = True
                else:
                    _result = _raise_error264
                    _status = False
                # End Str
                if _status:
                    break
                _pos = farthest_pos12
                _result = farthest_err12
                break
            # End Choice
            if _status:
                _result = staging15
            break
        # End Discard
        if not (_status):
            break
        name = _result
        # Begin Ref
        (_status, _result, _pos) = (yield (3, _try_Expr, _pos))
        # End Ref
        if not (_status):
            break
        expr = _result
        _result = KeywordArg(name, expr)
        _result._metadata.position_info = (start_pos15, _pos)
        break
    # End Seq
    yield (_status, _result, _pos)

def _raise_error261(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'KeywordArg' rule, at the expression:\n"
    "    '=>' | '=' | ':'\n\n"
    'Unexpected input'
    )
    raise ParseError((title + details), _pos, line, col)

def _raise_error262(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'KeywordArg' rule, at the expression:\n"
    "    '=>'\n\n"
    "Expected to match the string '=>'"
    )
    raise ParseError((title + details), _pos, line, col)

def _raise_error263(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'KeywordArg' rule, at the expression:\n"
    "    '='\n\n"
    "Expected to match the string '='"
    )
    raise ParseError((title + details), _pos, line, col)

def _raise_error264(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'KeywordArg' rule, at the expression:\n"
    "    ':'\n\n"
    "Expected to match the string ':'"
    )
    raise ParseError((title + details), _pos, line, col)

class ArgList(Node):
    """
    class ArgList {
        args: ('(' >> (wrap(KeywordArg | Expr) /? Comma)) << ')'
    }
    """
    _fields = ('args',)

    def __init__(self, args):
        Node.__init__(self)
        self.args = args

    def __repr__(self):
        return f'ArgList(args={self.args!r})'

    @staticmethod
    def parse(text, pos=0, fullparse=True):
        return _run(text, pos, _try_ArgList, fullparse)


def _parse_function_276(_text, _pos):
    # Begin Choice
    farthest_err13 = _raise_error276
    backtrack15 = farthest_pos13 = _pos
    while True:
        # Option 1:
        # Begin Ref
        (_status, _result, _pos) = (yield (3, _try_KeywordArg, _pos))
        # End Ref
        if _status:
            break
        if (farthest_pos13 < _pos):
            farthest_pos13 = _pos
            farthest_err13 = _result
        _pos = backtrack15
        # Option 2:
        # Begin Ref
        (_status, _result, _pos) = (yield (3, _try_Expr, _pos))
        # End Ref
        if _status:
            break
        if (farthest_pos13 < _pos):
            farthest_pos13 = _pos
            farthest_err13 = _result
        _pos = farthest_pos13
        _result = farthest_err13
        break
    # End Choice
    yield (_status, _result, _pos)

def _try_ArgList(_text, _pos):
    # Begin Seq
    start_pos16 = _pos
    while True:
        # Begin Discard
        # ('(' >> (wrap(KeywordArg | Expr) /? Comma)) << ')'
        while True:
            # Begin Discard
            # '(' >> (wrap(KeywordArg | Expr) /? Comma)
            while True:
                # Begin Str
                value35 = '('
                end35 = (_pos + 1)
                if (_text[slice(_pos, end35, None)] == value35):
                    _result = value35
                    _pos = (yield (3, _try__ignored, end35))[2]
                    _status = True
                else:
                    _result = _raise_error272
                    _status = False
                # End Str
                if not (_status):
                    break
                # Begin Sep
                # wrap(KeywordArg | Expr) /? Comma
                staging16 = []
                checkpoint9 = _pos
                while True:
                    # Begin Call
                    # wrap(KeywordArg | Expr)
                    func19 = _ParseFunction(_try_wrap, (_parse_function_276,), ())
                    (_status, _result, _pos) = (yield (3, func19, _pos))
                    # End Call
                    if not (_status):
                        break
                    staging16.append(_result)
                    checkpoint9 = _pos
                    # Begin Ref
                    (_status, _result, _pos) = (yield (3, _try_Comma, _pos))
                    # End Ref
                    if not (_status):
                        break
                    checkpoint9 = _pos
                _result = staging16
                _pos = checkpoint9
                _status = True
                # End Sep
                break
            # End Discard
            if not (_status):
                break
            staging17 = _result
            # Begin Str
            value36 = ')'
            end36 = (_pos + 1)
            if (_text[slice(_pos, end36, None)] == value36):
                _result = value36
                _pos = (yield (3, _try__ignored, end36))[2]
                _status = True
            else:
                _result = _raise_error280
                _status = False
            # End Str
            if _status:
                _result = staging17
            break
        # End Discard
        if not (_status):
            break
        args = _result
        _result = ArgList(args)
        _result._metadata.position_info = (start_pos16, _pos)
        break
    # End Seq
    yield (_status, _result, _pos)

def _raise_error272(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'ArgList' rule, at the expression:\n"
    "    '('\n\n"
    "Expected to match the string '('"
    )
    raise ParseError((title + details), _pos, line, col)

def _raise_error276(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'ArgList' rule, at the expression:\n"
    '    KeywordArg | Expr\n\n'
    'Unexpected input'
    )
    raise ParseError((title + details), _pos, line, col)

def _raise_error280(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'ArgList' rule, at the expression:\n"
    "    ')'\n\n"
    "Expected to match the string ')'"
    )
    raise ParseError((title + details), _pos, line, col)

def _parse_function_312(_text, _pos):
    # Begin Choice
    farthest_err16 = _raise_error312
    farthest_pos16 = _pos
    while True:
        # Option 1:
        # Begin Str
        value42 = '//'
        end42 = (_pos + 2)
        if (_text[slice(_pos, end42, None)] == value42):
            _result = value42
            _pos = (yield (3, _try__ignored, end42))[2]
            _status = True
        else:
            _result = _raise_error313
            _status = False
        # End Str
        if _status:
            break
        # Option 2:
        # Begin Str
        value43 = '/?'
        end43 = (_pos + 2)
        if (_text[slice(_pos, end43, None)] == value43):
            _result = value43
            _pos = (yield (3, _try__ignored, end43))[2]
            _status = True
        else:
            _result = _raise_error314
            _status = False
        # End Str
        if _status:
            break
        _pos = farthest_pos16
        _result = farthest_err16
        break
    # End Choice
    yield (_status, _result, _pos)

def _parse_function_319(_text, _pos):
    # Begin Choice
    farthest_err17 = _raise_error319
    farthest_pos17 = _pos
    while True:
        # Option 1:
        # Begin Str
        value44 = '<<'
        end44 = (_pos + 2)
        if (_text[slice(_pos, end44, None)] == value44):
            _result = value44
            _pos = (yield (3, _try__ignored, end44))[2]
            _status = True
        else:
            _result = _raise_error320
            _status = False
        # End Str
        if _status:
            break
        # Option 2:
        # Begin Str
        value45 = '>>'
        end45 = (_pos + 2)
        if (_text[slice(_pos, end45, None)] == value45):
            _result = value45
            _pos = (yield (3, _try__ignored, end45))[2]
            _status = True
        else:
            _result = _raise_error321
            _status = False
        # End Str
        if _status:
            break
        _pos = farthest_pos17
        _result = farthest_err17
        break
    # End Choice
    yield (_status, _result, _pos)

def _parse_function_326(_text, _pos):
    # Begin Choice
    farthest_err18 = _raise_error326
    farthest_pos18 = _pos
    while True:
        # Option 1:
        # Begin Str
        value46 = '<|'
        end46 = (_pos + 2)
        if (_text[slice(_pos, end46, None)] == value46):
            _result = value46
            _pos = (yield (3, _try__ignored, end46))[2]
            _status = True
        else:
            _result = _raise_error327
            _status = False
        # End Str
        if _status:
            break
        # Option 2:
        # Begin Str
        value47 = '|>'
        end47 = (_pos + 2)
        if (_text[slice(_pos, end47, None)] == value47):
            _result = value47
            _pos = (yield (3, _try__ignored, end47))[2]
            _status = True
        else:
            _result = _raise_error328
            _status = False
        # End Str
        if _status:
            break
        # Option 3:
        # Begin Str
        value48 = 'where'
        end48 = (_pos + 5)
        if (_text[slice(_pos, end48, None)] == value48):
            _result = value48
            _pos = (yield (3, _try__ignored, end48))[2]
            _status = True
        else:
            _result = _raise_error329
            _status = False
        # End Str
        if _status:
            break
        _pos = farthest_pos18
        _result = farthest_err18
        break
    # End Choice
    yield (_status, _result, _pos)

def _parse_function_334(_text, _pos):
    # Begin Str
    value49 = '|'
    end49 = (_pos + 1)
    if (_text[slice(_pos, end49, None)] == value49):
        _result = value49
        _pos = (yield (3, _try__ignored, end49))[2]
        _status = True
    else:
        _result = _raise_error334
        _status = False
    # End Str
    yield (_status, _result, _pos)

def _try_Expr(_text, _pos):
    # Rule 'Expr'
    # Begin OperatorTable
    # Atom with operators {
    #     mixfix: ('(' >> wrap(Expr)) << ')'
    #     postfix: ArgList, FieldAccess
    #     postfix: '?', '*', '+', Repeat
    #     left: wrap('//' | '/?')
    #     left: wrap('<<' | '>>')
    #     left: wrap('<|' | '|>' | 'where')
    #     left: wrap('|')
    #     postfix: OperatorTable
    # }
    _outer_checkpoint1 = _pos
    _operand_stack1 = []
    _operator_stack1 = []
    _operator_marker1 = 0
    while True:
        _inner_checkpoint1 = _pos
        # Begin Longest
        has_result1 = False
        farthest_error_result1 = _raise_error283
        farthest_error_position1 = _raise_error283
        backtrack16 = farthest_position1 = farthest_error_position1 = _pos
        # Option 1:
        # Begin Ref
        (_status, _result, _pos) = (yield (3, _try_Atom, _pos))
        # End Ref
        if _status:
            farthest_result1 = _result
            farthest_position1 = _pos
            has_result1 = True
        elif 'not has_result1 and ((farthest_error_position1 < _pos))':
            farthest_error_position1 = _pos
            farthest_error_result1 = _result
        _pos = backtrack16
        # Option 2:
        # Begin Discard
        # ('(' >> wrap(Expr)) << ')'
        while True:
            # Begin Discard
            # '(' >> wrap(Expr)
            while True:
                # Begin Str
                value37 = '('
                end37 = (_pos + 1)
                if (_text[slice(_pos, end37, None)] == value37):
                    _result = value37
                    _pos = (yield (3, _try__ignored, end37))[2]
                    _status = True
                else:
                    _result = _raise_error287
                    _status = False
                # End Str
                if not (_status):
                    break
                # Begin Call
                # wrap(Expr)
                func20 = _ParseFunction(_try_wrap, (_try_Expr,), ())
                (_status, _result, _pos) = (yield (3, func20, _pos))
                # End Call
                break
            # End Discard
            if not (_status):
                break
            staging18 = _result
            # Begin Str
            value38 = ')'
            end38 = (_pos + 1)
            if (_text[slice(_pos, end38, None)] == value38):
                _result = value38
                _pos = (yield (3, _try__ignored, end38))[2]
                _status = True
            else:
                _result = _raise_error291
                _status = False
            # End Str
            if _status:
                _result = staging18
            break
        # End Discard
        if _status:
            if not (has_result1):
                farthest_result1 = _result
                farthest_position1 = _pos
                has_result1 = True
            elif (farthest_position1 < _pos):
                farthest_result1 = _result
                farthest_position1 = _pos
        elif 'not has_result1 and ((farthest_error_position1 < _pos))':
            farthest_error_position1 = _pos
            farthest_error_result1 = _result
        if has_result1:
            _result = farthest_result1
            _pos = farthest_position1
            _status = True
        else:
            _result = farthest_error_result1
            _pos = farthest_error_position1
        # End Longest
        if not (_status):
            if _operand_stack1:
                _pos = _outer_checkpoint1
            break
        _operand_stack1.append(_result)
        while True:
            _inner_checkpoint1 = _pos
            # Begin Longest
            has_result2 = False
            farthest_error_result2 = _raise_error292
            farthest_error_position2 = _raise_error292
            backtrack17 = farthest_position2 = farthest_error_position2 = _pos
            # Option 1:
            # Begin Apply
            # (ArgList | FieldAccess) |> `lambda x: (1, x)`
            # Begin Choice
            farthest_err14 = _raise_error294
            backtrack18 = farthest_pos14 = _pos
            while True:
                # Option 1:
                # Begin Ref
                (_status, _result, _pos) = (yield (3, _try_ArgList, _pos))
                # End Ref
                if _status:
                    break
                if (farthest_pos14 < _pos):
                    farthest_pos14 = _pos
                    farthest_err14 = _result
                _pos = backtrack18
                # Option 2:
                # Begin Ref
                (_status, _result, _pos) = (yield (3, _try_FieldAccess, _pos))
                # End Ref
                if _status:
                    break
                if (farthest_pos14 < _pos):
                    farthest_pos14 = _pos
                    farthest_err14 = _result
                _pos = farthest_pos14
                _result = farthest_err14
                break
            # End Choice
            if _status:
                arg21 = _result
                _result = lambda x: (1, x)
                _status = True
                _result = _result(arg21)
            # End Apply
            if _status:
                farthest_result2 = _result
                farthest_position2 = _pos
                has_result2 = True
            elif 'not has_result2 and ((farthest_error_position2 < _pos))':
                farthest_error_position2 = _pos
                farthest_error_result2 = _result
            _pos = backtrack17
            # Option 2:
            # Begin Apply
            # ('?' | '*' | '+' | Repeat) |> `lambda x: (2, x)`
            # Begin Choice
            farthest_err15 = _raise_error299
            backtrack19 = farthest_pos15 = _pos
            while True:
                # Option 1:
                # Begin Str
                value39 = '?'
                end39 = (_pos + 1)
                if (_text[slice(_pos, end39, None)] == value39):
                    _result = value39
                    _pos = (yield (3, _try__ignored, end39))[2]
                    _status = True
                else:
                    _result = _raise_error300
                    _status = False
                # End Str
                if _status:
                    break
                # Option 2:
                # Begin Str
                value40 = '*'
                end40 = (_pos + 1)
                if (_text[slice(_pos, end40, None)] == value40):
                    _result = value40
                    _pos = (yield (3, _try__ignored, end40))[2]
                    _status = True
                else:
                    _result = _raise_error301
                    _status = False
                # End Str
                if _status:
                    break
                # Option 3:
                # Begin Str
                value41 = '+'
                end41 = (_pos + 1)
                if (_text[slice(_pos, end41, None)] == value41):
                    _result = value41
                    _pos = (yield (3, _try__ignored, end41))[2]
                    _status = True
                else:
                    _result = _raise_error302
                    _status = False
                # End Str
                if _status:
                    break
                # Option 4:
                # Begin Ref
                (_status, _result, _pos) = (yield (3, _try_Repeat, _pos))
                # End Ref
                if _status:
                    break
                if (farthest_pos15 < _pos):
                    farthest_pos15 = _pos
                    farthest_err15 = _result
                _pos = farthest_pos15
                _result = farthest_err15
                break
            # End Choice
            if _status:
                arg22 = _result
                _result = lambda x: (2, x)
                _status = True
                _result = _result(arg22)
            # End Apply
            if _status:
                if not (has_result2):
                    farthest_result2 = _result
                    farthest_position2 = _pos
                    has_result2 = True
                elif (farthest_position2 < _pos):
                    farthest_result2 = _result
                    farthest_position2 = _pos
            elif 'not has_result2 and ((farthest_error_position2 < _pos))':
                farthest_error_position2 = _pos
                farthest_error_result2 = _result
            _pos = backtrack17
            # Option 3:
            # Begin Apply
            # OperatorTable |> `lambda x: (7, x)`
            # Begin Ref
            (_status, _result, _pos) = (yield (3, _try_OperatorTable, _pos))
            # End Ref
            if _status:
                arg23 = _result
                _result = lambda x: (7, x)
                _status = True
                _result = _result(arg23)
            # End Apply
            if _status:
                if not (has_result2):
                    farthest_result2 = _result
                    farthest_position2 = _pos
                    has_result2 = True
                elif (farthest_position2 < _pos):
                    farthest_result2 = _result
                    farthest_position2 = _pos
            elif 'not has_result2 and ((farthest_error_position2 < _pos))':
                farthest_error_position2 = _pos
                farthest_error_result2 = _result
            if has_result2:
                _result = farthest_result2
                _pos = farthest_position2
                _status = True
            else:
                _result = farthest_error_result2
                _pos = farthest_error_position2
            # End Longest
            if not (_status):
                _pos = _inner_checkpoint1
                break
            while _operator_stack1 and _operator_stack1[-1][0] < _result[0]:
                _, _is_infix, _operator = _operator_stack1.pop()
                _right = _operand_stack1.pop()
                if _is_infix:
                    _left = _operand_stack1.pop()
                    _operand_stack1.append(Infix(_left, _operator, _right))
                else:
                    _operand_stack1.append(Prefix(_operator, _right))
            _operand = _operand_stack1.pop()
            _operand_stack1.append(Postfix(_operand, _result[1]))
        _operator_marker1 = len(_operator_stack1)
        _outer_checkpoint1 = _pos
        # Begin Longest
        has_result3 = False
        farthest_error_result3 = _raise_error308
        farthest_error_position3 = _raise_error308
        backtrack20 = farthest_position3 = farthest_error_position3 = _pos
        # Option 1:
        # Begin Apply
        # wrap('//' | '/?') |> `lambda x: (3, 1, x)`
        # Begin Call
        # wrap('//' | '/?')
        func21 = _ParseFunction(_try_wrap, (_parse_function_312,), ())
        (_status, _result, _pos) = (yield (3, func21, _pos))
        # End Call
        if _status:
            arg24 = _result
            _result = lambda x: (3, 1, x)
            _status = True
            _result = _result(arg24)
        # End Apply
        if _status:
            farthest_result3 = _result
            farthest_position3 = _pos
            has_result3 = True
        elif 'not has_result3 and ((farthest_error_position3 < _pos))':
            farthest_error_position3 = _pos
            farthest_error_result3 = _result
        _pos = backtrack20
        # Option 2:
        # Begin Apply
        # wrap('<<' | '>>') |> `lambda x: (4, 1, x)`
        # Begin Call
        # wrap('<<' | '>>')
        func22 = _ParseFunction(_try_wrap, (_parse_function_319,), ())
        (_status, _result, _pos) = (yield (3, func22, _pos))
        # End Call
        if _status:
            arg25 = _result
            _result = lambda x: (4, 1, x)
            _status = True
            _result = _result(arg25)
        # End Apply
        if _status:
            if not (has_result3):
                farthest_result3 = _result
                farthest_position3 = _pos
                has_result3 = True
            elif (farthest_position3 < _pos):
                farthest_result3 = _result
                farthest_position3 = _pos
        elif 'not has_result3 and ((farthest_error_position3 < _pos))':
            farthest_error_position3 = _pos
            farthest_error_result3 = _result
        _pos = backtrack20
        # Option 3:
        # Begin Apply
        # wrap('<|' | '|>' | 'where') |> `lambda x: (5, 1, x)`
        # Begin Call
        # wrap('<|' | '|>' | 'where')
        func23 = _ParseFunction(_try_wrap, (_parse_function_326,), ())
        (_status, _result, _pos) = (yield (3, func23, _pos))
        # End Call
        if _status:
            arg26 = _result
            _result = lambda x: (5, 1, x)
            _status = True
            _result = _result(arg26)
        # End Apply
        if _status:
            if not (has_result3):
                farthest_result3 = _result
                farthest_position3 = _pos
                has_result3 = True
            elif (farthest_position3 < _pos):
                farthest_result3 = _result
                farthest_position3 = _pos
        elif 'not has_result3 and ((farthest_error_position3 < _pos))':
            farthest_error_position3 = _pos
            farthest_error_result3 = _result
        _pos = backtrack20
        # Option 4:
        # Begin Apply
        # wrap('|') |> `lambda x: (6, 1, x)`
        # Begin Call
        # wrap('|')
        arg27 = _wrap_string_literal('|', _parse_function_334)
        func24 = _ParseFunction(_try_wrap, (arg27,), ())
        (_status, _result, _pos) = (yield (3, func24, _pos))
        # End Call
        if _status:
            arg28 = _result
            _result = lambda x: (6, 1, x)
            _status = True
            _result = _result(arg28)
        # End Apply
        if _status:
            if not (has_result3):
                farthest_result3 = _result
                farthest_position3 = _pos
                has_result3 = True
            elif (farthest_position3 < _pos):
                farthest_result3 = _result
                farthest_position3 = _pos
        elif 'not has_result3 and ((farthest_error_position3 < _pos))':
            farthest_error_position3 = _pos
            farthest_error_result3 = _result
        if has_result3:
            _result = farthest_result3
            _pos = farthest_position3
            _status = True
        else:
            _result = farthest_error_result3
            _pos = farthest_error_position3
        # End Longest
        if not (_status):
            if _operand_stack1:
                _pos = _outer_checkpoint1
            break
        _prec = _result[0]
        while _operator_stack1:
            _top_prec, _top_assoc, _ = _operator_stack1[-1]
            if _top_prec < _prec or (_top_prec == _prec and _top_assoc == 1):
                _, _is_infix, _operator = _operator_stack1.pop()
                _right = _operand_stack1.pop()
                if _is_infix:
                    _left = _operand_stack1.pop()
                    _operand_stack1.append(Infix(_left, _operator, _right))
                else:
                    _operand_stack1.append(Prefix(_operator, _right))
            elif _top_prec == _prec and _top_assoc == 3:
                _pos = _outer_checkpoint1
                break
            else:
                break
        _operator_marker1 = len(_operator_stack1)
        _operator_stack1.append(_result)
    if _operand_stack1:
        _operator_stack1 = _operator_stack1[:_operator_marker1]
        while _operator_stack1:
            _, _is_infix, _operator = _operator_stack1.pop()
            _right = _operand_stack1.pop()
            if _is_infix:
                _left = _operand_stack1.pop()
                _operand_stack1.append(Infix(_left, _operator, _right))
            else:
                _operand_stack1.append(Prefix(_operator, _right))
        _result = _operand_stack1[0]
        _status = True
    # End OperatorTable
    yield (_status, _result, _pos)

def _parse_Expr(text, pos=0, fullparse=True):
    return _run(text, pos, _try_Expr, fullparse)

Expr = Rule('Expr', _parse_Expr, """
    Expr = Atom with operators {
        mixfix: ('(' >> wrap(Expr)) << ')'
        postfix: ArgList, FieldAccess
        postfix: '?', '*', '+', Repeat
        left: wrap('//' | '/?')
        left: wrap('<<' | '>>')
        left: wrap('<|' | '|>' | 'where')
        left: wrap('|')
        postfix: OperatorTable
    }
""")
def _raise_error282(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Expr' rule, at the expression:\n"
    "    Atom with operators {\n    mixfix: ('(' >> wrap(Expr)) << ')'\n    postfix: ArgList, FieldAccess\n    postfix: '?', '*', '+', Repeat\n    left: wrap('//' | '/?')\n    left: wrap('<<' | '>>')\n    left: wrap('<|' | '|>' | 'where')\n    left: wrap('|')\n    postfix: OperatorTable\n}\n\n"
    'Unexpected input'
    )
    raise ParseError((title + details), _pos, line, col)

def _raise_error283(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Expr' rule, at the expression:\n"
    "    Longest(Atom, ('(' >> wrap(Expr)) << ')')\n\n"
    'Unexpected input'
    )
    raise ParseError((title + details), _pos, line, col)

def _raise_error287(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Expr' rule, at the expression:\n"
    "    '('\n\n"
    "Expected to match the string '('"
    )
    raise ParseError((title + details), _pos, line, col)

def _raise_error291(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Expr' rule, at the expression:\n"
    "    ')'\n\n"
    "Expected to match the string ')'"
    )
    raise ParseError((title + details), _pos, line, col)

def _raise_error292(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Expr' rule, at the expression:\n"
    "    Longest((ArgList | FieldAccess) |> `lambda x: (1, x)`, ('?' | '*' | '+' | Repeat) |> `lambda x: (2, x)`, OperatorTable |> `lambda x: (7, x)`)\n\n"
    'Unexpected input'
    )
    raise ParseError((title + details), _pos, line, col)

def _raise_error294(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Expr' rule, at the expression:\n"
    '    ArgList | FieldAccess\n\n'
    'Unexpected input'
    )
    raise ParseError((title + details), _pos, line, col)

def _raise_error299(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Expr' rule, at the expression:\n"
    "    '?' | '*' | '+' | Repeat\n\n"
    'Unexpected input'
    )
    raise ParseError((title + details), _pos, line, col)

def _raise_error300(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Expr' rule, at the expression:\n"
    "    '?'\n\n"
    "Expected to match the string '?'"
    )
    raise ParseError((title + details), _pos, line, col)

def _raise_error301(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Expr' rule, at the expression:\n"
    "    '*'\n\n"
    "Expected to match the string '*'"
    )
    raise ParseError((title + details), _pos, line, col)

def _raise_error302(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Expr' rule, at the expression:\n"
    "    '+'\n\n"
    "Expected to match the string '+'"
    )
    raise ParseError((title + details), _pos, line, col)

def _raise_error308(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Expr' rule, at the expression:\n"
    "    Longest(wrap('//' | '/?') |> `lambda x: (3, 1, x)`, wrap('<<' | '>>') |> `lambda x: (4, 1, x)`, wrap('<|' | '|>' | 'where') |> `lambda x: (5, 1, x)`, wrap('|') |> `lambda x: (6, 1, x)`)\n\n"
    'Unexpected input'
    )
    raise ParseError((title + details), _pos, line, col)

def _raise_error312(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Expr' rule, at the expression:\n"
    "    '//' | '/?'\n\n"
    'Unexpected input'
    )
    raise ParseError((title + details), _pos, line, col)

def _raise_error313(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Expr' rule, at the expression:\n"
    "    '//'\n\n"
    "Expected to match the string '//'"
    )
    raise ParseError((title + details), _pos, line, col)

def _raise_error314(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Expr' rule, at the expression:\n"
    "    '/?'\n\n"
    "Expected to match the string '/?'"
    )
    raise ParseError((title + details), _pos, line, col)

def _raise_error319(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Expr' rule, at the expression:\n"
    "    '<<' | '>>'\n\n"
    'Unexpected input'
    )
    raise ParseError((title + details), _pos, line, col)

def _raise_error320(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Expr' rule, at the expression:\n"
    "    '<<'\n\n"
    "Expected to match the string '<<'"
    )
    raise ParseError((title + details), _pos, line, col)

def _raise_error321(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Expr' rule, at the expression:\n"
    "    '>>'\n\n"
    "Expected to match the string '>>'"
    )
    raise ParseError((title + details), _pos, line, col)

def _raise_error326(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Expr' rule, at the expression:\n"
    "    '<|' | '|>' | 'where'\n\n"
    'Unexpected input'
    )
    raise ParseError((title + details), _pos, line, col)

def _raise_error327(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Expr' rule, at the expression:\n"
    "    '<|'\n\n"
    "Expected to match the string '<|'"
    )
    raise ParseError((title + details), _pos, line, col)

def _raise_error328(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Expr' rule, at the expression:\n"
    "    '|>'\n\n"
    "Expected to match the string '|>'"
    )
    raise ParseError((title + details), _pos, line, col)

def _raise_error329(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Expr' rule, at the expression:\n"
    "    'where'\n\n"
    "Expected to match the string 'where'"
    )
    raise ParseError((title + details), _pos, line, col)

def _raise_error334(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Expr' rule, at the expression:\n"
    "    '|'\n\n"
    "Expected to match the string '|'"
    )
    raise ParseError((title + details), _pos, line, col)

class FieldAccess(Node):
    """
    class FieldAccess {
        field: '.' >> Name
    }
    """
    _fields = ('field',)

    def __init__(self, field):
        Node.__init__(self)
        self.field = field

    def __repr__(self):
        return f'FieldAccess(field={self.field!r})'

    @staticmethod
    def parse(text, pos=0, fullparse=True):
        return _run(text, pos, _try_FieldAccess, fullparse)


def _try_FieldAccess(_text, _pos):
    # Begin Seq
    start_pos17 = _pos
    while True:
        # Begin Discard
        # '.' >> Name
        while True:
            # Begin Str
            value50 = '.'
            end50 = (_pos + 1)
            if (_text[slice(_pos, end50, None)] == value50):
                _result = value50
                _pos = (yield (3, _try__ignored, end50))[2]
                _status = True
            else:
                _result = _raise_error340
                _status = False
            # End Str
            if not (_status):
                break
            # Begin Ref
            (_status, _result, _pos) = (yield (3, _try_Name, _pos))
            # End Ref
            break
        # End Discard
        if not (_status):
            break
        field = _result
        _result = FieldAccess(field)
        _result._metadata.position_info = (start_pos17, _pos)
        break
    # End Seq
    yield (_status, _result, _pos)

def _raise_error340(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'FieldAccess' rule, at the expression:\n"
    "    '.'\n\n"
    "Expected to match the string '.'"
    )
    raise ParseError((title + details), _pos, line, col)

class Repeat(Node):
    """
    class Repeat {
        open: '{'
        start: Opt(RepeatArg)
        stop: ',' >> RepeatArg | ',' >> `None` | `start`
        close: '}'
    }
    """
    _fields = ('open', 'start', 'stop', 'close')

    def __init__(self, open, start, stop, close):
        Node.__init__(self)
        self.open = open
        self.start = start
        self.stop = stop
        self.close = close

    def __repr__(self):
        return f'Repeat(open={self.open!r}, start={self.start!r}, stop={self.stop!r}, close={self.close!r})'

    @staticmethod
    def parse(text, pos=0, fullparse=True):
        return _run(text, pos, _try_Repeat, fullparse)


def _try_Repeat(_text, _pos):
    # Begin Seq
    start_pos18 = _pos
    while True:
        # Begin Str
        value51 = '{'
        end51 = (_pos + 1)
        if (_text[slice(_pos, end51, None)] == value51):
            _result = value51
            _pos = (yield (3, _try__ignored, end51))[2]
            _status = True
        else:
            _result = _raise_error345
            _status = False
        # End Str
        if not (_status):
            break
        open = _result
        # Begin Opt
        # Opt(RepeatArg)
        backtrack21 = _pos
        # Begin Ref
        (_status, _result, _pos) = (yield (3, _try_RepeatArg, _pos))
        # End Ref
        if not (_status):
            _pos = backtrack21
            _result = None
            _status = True
        # End Opt
        start = _result
        # Begin Choice
        backtrack22 = _pos
        while True:
            # Option 1:
            # Begin Discard
            # ',' >> RepeatArg
            while True:
                # Begin Str
                value52 = ','
                end52 = (_pos + 1)
                if (_text[slice(_pos, end52, None)] == value52):
                    _result = value52
                    _pos = (yield (3, _try__ignored, end52))[2]
                    _status = True
                else:
                    _result = _raise_error352
                    _status = False
                # End Str
                if not (_status):
                    break
                # Begin Ref
                (_status, _result, _pos) = (yield (3, _try_RepeatArg, _pos))
                # End Ref
                break
            # End Discard
            if _status:
                break
            _pos = backtrack22
            # Option 2:
            # Begin Discard
            # ',' >> `None`
            while True:
                # Begin Str
                value53 = ','
                end53 = (_pos + 1)
                if (_text[slice(_pos, end53, None)] == value53):
                    _result = value53
                    _pos = (yield (3, _try__ignored, end53))[2]
                    _status = True
                else:
                    _result = _raise_error355
                    _status = False
                # End Str
                if not (_status):
                    break
                _result = None
                _status = True
                break
            # End Discard
            if _status:
                break
            _pos = backtrack22
            # Option 3: (always_succeeds)
            _result = start
            _status = True
            break
        # End Choice
        stop = _result
        # Begin Str
        value54 = '}'
        end54 = (_pos + 1)
        if (_text[slice(_pos, end54, None)] == value54):
            _result = value54
            _pos = (yield (3, _try__ignored, end54))[2]
            _status = True
        else:
            _result = _raise_error359
            _status = False
        # End Str
        if not (_status):
            break
        close = _result
        _result = Repeat(open, start, stop, close)
        _result._metadata.position_info = (start_pos18, _pos)
        break
    # End Seq
    yield (_status, _result, _pos)

def _raise_error345(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Repeat' rule, at the expression:\n"
    "    '{'\n\n"
    "Expected to match the string '{'"
    )
    raise ParseError((title + details), _pos, line, col)

def _raise_error352(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Repeat' rule, at the expression:\n"
    "    ','\n\n"
    "Expected to match the string ','"
    )
    raise ParseError((title + details), _pos, line, col)

def _raise_error355(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Repeat' rule, at the expression:\n"
    "    ','\n\n"
    "Expected to match the string ','"
    )
    raise ParseError((title + details), _pos, line, col)

def _raise_error359(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Repeat' rule, at the expression:\n"
    "    '}'\n\n"
    "Expected to match the string '}'"
    )
    raise ParseError((title + details), _pos, line, col)

def _try_RepeatArg(_text, _pos):
    # Rule 'RepeatArg'
    # Begin Choice
    farthest_err19 = _raise_error361
    backtrack23 = farthest_pos19 = _pos
    while True:
        # Option 1:
        # Begin Ref
        (_status, _result, _pos) = (yield (3, _try_PythonExpression, _pos))
        # End Ref
        if _status:
            break
        if (farthest_pos19 < _pos):
            farthest_pos19 = _pos
            farthest_err19 = _result
        _pos = backtrack23
        # Option 2:
        # Begin Ref
        (_status, _result, _pos) = (yield (3, _try_Ref, _pos))
        # End Ref
        if _status:
            break
        if (farthest_pos19 < _pos):
            farthest_pos19 = _pos
            farthest_err19 = _result
        _pos = farthest_pos19
        _result = farthest_err19
        break
    # End Choice
    yield (_status, _result, _pos)

def _parse_RepeatArg(text, pos=0, fullparse=True):
    return _run(text, pos, _try_RepeatArg, fullparse)

RepeatArg = Rule('RepeatArg', _parse_RepeatArg, """
    RepeatArg = PythonExpression | Ref
""")
def _raise_error361(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'RepeatArg' rule, at the expression:\n"
    '    PythonExpression | Ref\n\n'
    'Unexpected input'
    )
    raise ParseError((title + details), _pos, line, col)

class OperatorTable(Node):
    """
    class OperatorTable {
        rows: (((wrap(kw('between')) >> '{') >> Skip(Newline)) >> OperatorRow*) << '}'
    }
    """
    _fields = ('rows',)

    def __init__(self, rows):
        Node.__init__(self)
        self.rows = rows

    def __repr__(self):
        return f'OperatorTable(rows={self.rows!r})'

    @staticmethod
    def parse(text, pos=0, fullparse=True):
        return _run(text, pos, _try_OperatorTable, fullparse)


def _parse_function_375(_text, _pos):
    # Begin Str
    value55 = 'between'
    end55 = (_pos + 7)
    if (_text[slice(_pos, end55, None)] == value55):
        _result = value55
        _pos = (yield (3, _try__ignored, end55))[2]
        _status = True
    else:
        _result = _raise_error375
        _status = False
    # End Str
    yield (_status, _result, _pos)

def _parse_function_373(_text, _pos):
    # Begin Call
    # kw('between')
    arg29 = _wrap_string_literal('between', _parse_function_375)
    func25 = _ParseFunction(_try_kw, (arg29,), ())
    (_status, _result, _pos) = (yield (3, func25, _pos))
    # End Call
    yield (_status, _result, _pos)

def _try_OperatorTable(_text, _pos):
    # Begin Seq
    start_pos19 = _pos
    while True:
        # Begin Discard
        # (((wrap(kw('between')) >> '{') >> Skip(Newline)) >> OperatorRow*) << '}'
        while True:
            # Begin Discard
            # ((wrap(kw('between')) >> '{') >> Skip(Newline)) >> OperatorRow*
            while True:
                # Begin Discard
                # (wrap(kw('between')) >> '{') >> Skip(Newline)
                while True:
                    # Begin Discard
                    # wrap(kw('between')) >> '{'
                    while True:
                        # Begin Call
                        # wrap(kw('between'))
                        func26 = _ParseFunction(_try_wrap, (_parse_function_373,), ())
                        (_status, _result, _pos) = (yield (3, func26, _pos))
                        # End Call
                        if not (_status):
                            break
                        # Begin Str
                        value56 = '{'
                        end56 = (_pos + 1)
                        if (_text[slice(_pos, end56, None)] == value56):
                            _result = value56
                            _pos = (yield (3, _try__ignored, end56))[2]
                            _status = True
                        else:
                            _result = _raise_error376
                            _status = False
                        # End Str
                        break
                    # End Discard
                    if not (_status):
                        break
                    # Begin Skip
                    # Skip(Newline)
                    while True:
                        checkpoint10 = _pos
                        # Begin Ref
                        (_status, _result, _pos) = (yield (3, _try_Newline, _pos))
                        # End Ref
                        if _status:
                            continue
                        else:
                            _pos = checkpoint10
                        break
                    _result = None
                    _status = True
                    # End Skip
                    break
                # End Discard
                if not (_status):
                    break
                # Begin List
                # OperatorRow*
                staging19 = []
                while True:
                    checkpoint11 = _pos
                    # Begin Ref
                    (_status, _result, _pos) = (yield (3, _try_OperatorRow, _pos))
                    # End Ref
                    if not (_status):
                        _pos = checkpoint11
                        break
                    staging19.append(_result)
                _result = staging19
                _status = True
                # End List
                break
            # End Discard
            if not (_status):
                break
            staging20 = _result
            # Begin Str
            value57 = '}'
            end57 = (_pos + 1)
            if (_text[slice(_pos, end57, None)] == value57):
                _result = value57
                _pos = (yield (3, _try__ignored, end57))[2]
                _status = True
            else:
                _result = _raise_error381
                _status = False
            # End Str
            if _status:
                _result = staging20
            break
        # End Discard
        if not (_status):
            break
        rows = _result
        _result = OperatorTable(rows)
        _result._metadata.position_info = (start_pos19, _pos)
        break
    # End Seq
    yield (_status, _result, _pos)

def _raise_error375(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'OperatorTable' rule, at the expression:\n"
    "    'between'\n\n"
    "Expected to match the string 'between'"
    )
    raise ParseError((title + details), _pos, line, col)

def _raise_error376(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'OperatorTable' rule, at the expression:\n"
    "    '{'\n\n"
    "Expected to match the string '{'"
    )
    raise ParseError((title + details), _pos, line, col)

def _raise_error381(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'OperatorTable' rule, at the expression:\n"
    "    '}'\n\n"
    "Expected to match the string '}'"
    )
    raise ParseError((title + details), _pos, line, col)

class OperatorRow(Node):
    """
    class OperatorRow {
        associativity: Associativity
        operators: wrap(':') >> (Operator /? Comma)
        tail: Opt(LineSep)
    }
    """
    _fields = ('associativity', 'operators', 'tail')

    def __init__(self, associativity, operators, tail):
        Node.__init__(self)
        self.associativity = associativity
        self.operators = operators
        self.tail = tail

    def __repr__(self):
        return f'OperatorRow(associativity={self.associativity!r}, operators={self.operators!r}, tail={self.tail!r})'

    @staticmethod
    def parse(text, pos=0, fullparse=True):
        return _run(text, pos, _try_OperatorRow, fullparse)


def _parse_function_390(_text, _pos):
    # Begin Str
    value58 = ':'
    end58 = (_pos + 1)
    if (_text[slice(_pos, end58, None)] == value58):
        _result = value58
        _pos = (yield (3, _try__ignored, end58))[2]
        _status = True
    else:
        _result = _raise_error390
        _status = False
    # End Str
    yield (_status, _result, _pos)

def _try_OperatorRow(_text, _pos):
    # Begin Seq
    start_pos20 = _pos
    while True:
        # Begin Ref
        (_status, _result, _pos) = (yield (3, _try_Associativity, _pos))
        # End Ref
        if not (_status):
            break
        associativity = _result
        # Begin Discard
        # wrap(':') >> (Operator /? Comma)
        while True:
            # Begin Call
            # wrap(':')
            arg30 = _wrap_string_literal(':', _parse_function_390)
            func27 = _ParseFunction(_try_wrap, (arg30,), ())
            (_status, _result, _pos) = (yield (3, func27, _pos))
            # End Call
            if not (_status):
                break
            # Begin Sep
            # Operator /? Comma
            staging21 = []
            checkpoint12 = _pos
            while True:
                # Begin Ref
                (_status, _result, _pos) = (yield (3, _try_Operator, _pos))
                # End Ref
                if not (_status):
                    break
                staging21.append(_result)
                checkpoint12 = _pos
                # Begin Ref
                (_status, _result, _pos) = (yield (3, _try_Comma, _pos))
                # End Ref
                if not (_status):
                    break
                checkpoint12 = _pos
            _result = staging21
            _pos = checkpoint12
            _status = True
            # End Sep
            break
        # End Discard
        if not (_status):
            break
        operators = _result
        # Begin Opt
        # Opt(LineSep)
        backtrack24 = _pos
        # Begin Ref
        (_status, _result, _pos) = (yield (3, _try_LineSep, _pos))
        # End Ref
        if not (_status):
            _pos = backtrack24
            _result = None
            _status = True
        # End Opt
        tail = _result
        _result = OperatorRow(associativity, operators, tail)
        _result._metadata.position_info = (start_pos20, _pos)
        break
    # End Seq
    yield (_status, _result, _pos)

def _raise_error390(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'OperatorRow' rule, at the expression:\n"
    "    ':'\n\n"
    "Expected to match the string ':'"
    )
    raise ParseError((title + details), _pos, line, col)

def _parse_function_403(_text, _pos):
    # Begin Str
    value59 = ':'
    end59 = (_pos + 1)
    if (_text[slice(_pos, end59, None)] == value59):
        _result = value59
        _pos = (yield (3, _try__ignored, end59))[2]
        _status = True
    else:
        _result = _raise_error403
        _status = False
    # End Str
    yield (_status, _result, _pos)

def _try_Operator(_text, _pos):
    # Rule 'Operator'
    # Begin Discard
    # Expr << ExpectNot(wrap(':'))
    while True:
        # Begin Ref
        (_status, _result, _pos) = (yield (3, _try_Expr, _pos))
        # End Ref
        if not (_status):
            break
        staging22 = _result
        # Begin ExpectNot
        # ExpectNot(wrap(':'))
        backtrack25 = _pos
        # Begin Call
        # wrap(':')
        arg31 = _wrap_string_literal(':', _parse_function_403)
        func28 = _ParseFunction(_try_wrap, (arg31,), ())
        (_status, _result, _pos) = (yield (3, func28, _pos))
        # End Call
        _pos = backtrack25
        if _status:
            _status = False
            _result = _raise_error400
        else:
            _status = True
            _result = None
        # End ExpectNot
        if _status:
            _result = staging22
        break
    # End Discard
    yield (_status, _result, _pos)

def _parse_Operator(text, pos=0, fullparse=True):
    return _run(text, pos, _try_Operator, fullparse)

Operator = Rule('Operator', _parse_Operator, """
    Operator = Expr << ExpectNot(wrap(':'))
""")
def _raise_error400(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Operator' rule, at the expression:\n"
    "    ExpectNot(wrap(':'))\n\n"
    "Did not expect to match: wrap(':')"
    )
    raise ParseError((title + details), _pos, line, col)

def _raise_error403(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Operator' rule, at the expression:\n"
    "    ':'\n\n"
    "Expected to match the string ':'"
    )
    raise ParseError((title + details), _pos, line, col)

def _parse_function_408(_text, _pos):
    # Begin Str
    value60 = 'left'
    end60 = (_pos + 4)
    if (_text[slice(_pos, end60, None)] == value60):
        _result = value60
        _pos = (yield (3, _try__ignored, end60))[2]
        _status = True
    else:
        _result = _raise_error408
        _status = False
    # End Str
    yield (_status, _result, _pos)

def _parse_function_411(_text, _pos):
    # Begin Str
    value61 = 'right'
    end61 = (_pos + 5)
    if (_text[slice(_pos, end61, None)] == value61):
        _result = value61
        _pos = (yield (3, _try__ignored, end61))[2]
        _status = True
    else:
        _result = _raise_error411
        _status = False
    # End Str
    yield (_status, _result, _pos)

def _parse_function_414(_text, _pos):
    # Begin Str
    value62 = 'infix'
    end62 = (_pos + 5)
    if (_text[slice(_pos, end62, None)] == value62):
        _result = value62
        _pos = (yield (3, _try__ignored, end62))[2]
        _status = True
    else:
        _result = _raise_error414
        _status = False
    # End Str
    yield (_status, _result, _pos)

def _parse_function_417(_text, _pos):
    # Begin Str
    value63 = 'mixfix'
    end63 = (_pos + 6)
    if (_text[slice(_pos, end63, None)] == value63):
        _result = value63
        _pos = (yield (3, _try__ignored, end63))[2]
        _status = True
    else:
        _result = _raise_error417
        _status = False
    # End Str
    yield (_status, _result, _pos)

def _parse_function_420(_text, _pos):
    # Begin Str
    value64 = 'postfix'
    end64 = (_pos + 7)
    if (_text[slice(_pos, end64, None)] == value64):
        _result = value64
        _pos = (yield (3, _try__ignored, end64))[2]
        _status = True
    else:
        _result = _raise_error420
        _status = False
    # End Str
    yield (_status, _result, _pos)

def _parse_function_423(_text, _pos):
    # Begin Str
    value65 = 'prefix'
    end65 = (_pos + 6)
    if (_text[slice(_pos, end65, None)] == value65):
        _result = value65
        _pos = (yield (3, _try__ignored, end65))[2]
        _status = True
    else:
        _result = _raise_error423
        _status = False
    # End Str
    yield (_status, _result, _pos)

def _try_Associativity(_text, _pos):
    # Rule 'Associativity'
    # Begin Choice
    farthest_err20 = _raise_error405
    backtrack26 = farthest_pos20 = _pos
    while True:
        # Option 1:
        # Begin Call
        # kw('left')
        arg32 = _wrap_string_literal('left', _parse_function_408)
        func29 = _ParseFunction(_try_kw, (arg32,), ())
        (_status, _result, _pos) = (yield (3, func29, _pos))
        # End Call
        if _status:
            break
        if (farthest_pos20 < _pos):
            farthest_pos20 = _pos
            farthest_err20 = _result
        _pos = backtrack26
        # Option 2:
        # Begin Call
        # kw('right')
        arg33 = _wrap_string_literal('right', _parse_function_411)
        func30 = _ParseFunction(_try_kw, (arg33,), ())
        (_status, _result, _pos) = (yield (3, func30, _pos))
        # End Call
        if _status:
            break
        if (farthest_pos20 < _pos):
            farthest_pos20 = _pos
            farthest_err20 = _result
        _pos = backtrack26
        # Option 3:
        # Begin Call
        # kw('infix')
        arg34 = _wrap_string_literal('infix', _parse_function_414)
        func31 = _ParseFunction(_try_kw, (arg34,), ())
        (_status, _result, _pos) = (yield (3, func31, _pos))
        # End Call
        if _status:
            break
        if (farthest_pos20 < _pos):
            farthest_pos20 = _pos
            farthest_err20 = _result
        _pos = backtrack26
        # Option 4:
        # Begin Call
        # kw('mixfix')
        arg35 = _wrap_string_literal('mixfix', _parse_function_417)
        func32 = _ParseFunction(_try_kw, (arg35,), ())
        (_status, _result, _pos) = (yield (3, func32, _pos))
        # End Call
        if _status:
            break
        if (farthest_pos20 < _pos):
            farthest_pos20 = _pos
            farthest_err20 = _result
        _pos = backtrack26
        # Option 5:
        # Begin Call
        # kw('postfix')
        arg36 = _wrap_string_literal('postfix', _parse_function_420)
        func33 = _ParseFunction(_try_kw, (arg36,), ())
        (_status, _result, _pos) = (yield (3, func33, _pos))
        # End Call
        if _status:
            break
        if (farthest_pos20 < _pos):
            farthest_pos20 = _pos
            farthest_err20 = _result
        _pos = backtrack26
        # Option 6:
        # Begin Call
        # kw('prefix')
        arg37 = _wrap_string_literal('prefix', _parse_function_423)
        func34 = _ParseFunction(_try_kw, (arg37,), ())
        (_status, _result, _pos) = (yield (3, func34, _pos))
        # End Call
        if _status:
            break
        if (farthest_pos20 < _pos):
            farthest_pos20 = _pos
            farthest_err20 = _result
        _pos = farthest_pos20
        _result = farthest_err20
        break
    # End Choice
    yield (_status, _result, _pos)

def _parse_Associativity(text, pos=0, fullparse=True):
    return _run(text, pos, _try_Associativity, fullparse)

Associativity = Rule('Associativity', _parse_Associativity, """
    Associativity = kw('left') | kw('right') | kw('infix') | kw('mixfix') | kw('postfix') | kw('prefix')
""")
def _raise_error405(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Associativity' rule, at the expression:\n"
    "    kw('left') | kw('right') | kw('infix') | kw('mixfix') | kw('postfix') | kw('prefix')\n\n"
    'Unexpected input'
    )
    raise ParseError((title + details), _pos, line, col)

def _raise_error408(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Associativity' rule, at the expression:\n"
    "    'left'\n\n"
    "Expected to match the string 'left'"
    )
    raise ParseError((title + details), _pos, line, col)

def _raise_error411(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Associativity' rule, at the expression:\n"
    "    'right'\n\n"
    "Expected to match the string 'right'"
    )
    raise ParseError((title + details), _pos, line, col)

def _raise_error414(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Associativity' rule, at the expression:\n"
    "    'infix'\n\n"
    "Expected to match the string 'infix'"
    )
    raise ParseError((title + details), _pos, line, col)

def _raise_error417(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Associativity' rule, at the expression:\n"
    "    'mixfix'\n\n"
    "Expected to match the string 'mixfix'"
    )
    raise ParseError((title + details), _pos, line, col)

def _raise_error420(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Associativity' rule, at the expression:\n"
    "    'postfix'\n\n"
    "Expected to match the string 'postfix'"
    )
    raise ParseError((title + details), _pos, line, col)

def _raise_error423(_text, _pos):
    if (len(_text) <= _pos):
        title = 'Unexpected end of input.'
        line = None
        col = None
    else:
        (line, col) = _get_line_and_column(_text, _pos)
        excerpt = _extract_excerpt(_text, _pos, col)
        title = f'Error on line {line}, column {col}:\n{excerpt}\n'
    details = (
    "Failed to parse the 'Associativity' rule, at the expression:\n"
    "    'prefix'\n\n"
    "Expected to match the string 'prefix'"
    )
    raise ParseError((title + details), _pos, line, col)

def _try_ManyStmts(_text, _pos):
    # Rule 'ManyStmts'
    # Begin Sep
    # Stmt /? LineSep
    staging23 = []
    checkpoint13 = _pos
    while True:
        # Begin Ref
        (_status, _result, _pos) = (yield (3, _try_Stmt, _pos))
        # End Ref
        if not (_status):
            break
        staging23.append(_result)
        checkpoint13 = _pos
        # Begin Ref
        (_status, _result, _pos) = (yield (3, _try_LineSep, _pos))
        # End Ref
        if not (_status):
            break
        checkpoint13 = _pos
    if staging23:
        _result = staging23
        _pos = checkpoint13
        _status = True
    # End Sep
    yield (_status, _result, _pos)

def _parse_ManyStmts(text, pos=0, fullparse=True):
    return _run(text, pos, _try_ManyStmts, fullparse)

ManyStmts = Rule('ManyStmts', _parse_ManyStmts, """
    ManyStmts = Stmt /? LineSep
""")
def _try_SingleExpr(_text, _pos):
    # Rule 'SingleExpr'
    # Begin Discard
    # Expr << Opt(LineSep)
    while True:
        # Begin Ref
        (_status, _result, _pos) = (yield (3, _try_Expr, _pos))
        # End Ref
        if not (_status):
            break
        staging24 = _result
        # Begin Opt
        # Opt(LineSep)
        backtrack27 = _pos
        # Begin Ref
        (_status, _result, _pos) = (yield (3, _try_LineSep, _pos))
        # End Ref
        if not (_status):
            _pos = backtrack27
            _result = None
            _status = True
        # End Opt
        _result = staging24
        break
    # End Discard
    yield (_status, _result, _pos)

def _parse_SingleExpr(text, pos=0, fullparse=True):
    return _run(text, pos, _try_SingleExpr, fullparse)

SingleExpr = Rule('SingleExpr', _parse_SingleExpr, """
    SingleExpr = Expr << Opt(LineSep)
""")
def _try_start(_text, _pos):
    # Rule 'start'
    # Begin Discard
    # _try__ignored >> (Skip(Newline) >> GrammarDef)
    while True:
        # Begin Ref
        (_status, _result, _pos) = (yield (3, _try__ignored, _pos))
        # End Ref
        if not (_status):
            break
        # Begin Discard
        # Skip(Newline) >> GrammarDef
        while True:
            # Begin Skip
            # Skip(Newline)
            while True:
                checkpoint14 = _pos
                # Begin Ref
                (_status, _result, _pos) = (yield (3, _try_Newline, _pos))
                # End Ref
                if _status:
                    continue
                else:
                    _pos = checkpoint14
                break
            _result = None
            _status = True
            # End Skip
            # Begin Ref
            (_status, _result, _pos) = (yield (3, _try_GrammarDef, _pos))
            # End Ref
            break
        # End Discard
        break
    # End Discard
    yield (_status, _result, _pos)

def _parse_start(text, pos=0, fullparse=True):
    return _run(text, pos, _try_start, fullparse)

start = Rule('start', _parse_start, """
    start = _try__ignored >> (Skip(Newline) >> GrammarDef)
""")
def _try__ignored(_text, _pos):
    # Rule '_ignored'
    # Begin Skip
    # Skip(Space, Comment)
    while True:
        checkpoint15 = _pos
        # Begin Ref
        (_status, _result, _pos) = (yield (3, _try_Space, _pos))
        # End Ref
        if _status:
            continue
        else:
            _pos = checkpoint15
        # Begin Ref
        (_status, _result, _pos) = (yield (3, _try_Comment, _pos))
        # End Ref
        if _status:
            continue
        else:
            _pos = checkpoint15
        break
    _result = None
    _status = True
    # End Skip
    yield (_status, _result, _pos)

def _parse__ignored(text, pos=0, fullparse=True):
    return _run(text, pos, _try__ignored, fullparse)

_ignored = Rule('_ignored', _parse__ignored, """
    _ignored = Skip(Space, Comment)
""")
