# coding: utf-8

"""
    Tator REST API

    Interface to the Tator backend.  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ..configuration import Configuration


class ArchiveConfig(object):
    """
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'encode': 'EncodeConfig',
        'name': 'str',
        's3_storage': 'S3StorageConfig'
    }

    attribute_map = {
        'encode': 'encode',
        'name': 'name',
        's3_storage': 's3_storage'
    }

    def __init__(self, encode=None, name=None, s3_storage=None, local_vars_configuration=None):  # noqa: E501
        """ArchiveConfig - a model defined in OpenAPI"""
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._encode = None
        self._name = None
        self._s3_storage = None
        self.discriminator = None

        if encode is not None:
            self.encode = encode
        if name is not None:
            self.name = name
        if s3_storage is not None:
            self.s3_storage = s3_storage

    @property
    def encode(self):
        """

        :return: The encode of this ArchiveConfig. 
        :rtype: EncodeConfig
        """
        return self._encode

    @encode.setter
    def encode(self, encode):
        """

        :param encode: The encode of this ArchiveConfig.
        :type: EncodeConfig
        """

        self._encode = encode

    @property
    def name(self):
        """
        Name of this archive config, used for retrieval in case of multiple archive configs.

        :return: The name of this ArchiveConfig. 
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Name of this archive config, used for retrieval in case of multiple archive configs.

        :param name: The name of this ArchiveConfig.
        :type: str
        """

        self._name = name

    @property
    def s3_storage(self):
        """

        :return: The s3_storage of this ArchiveConfig. 
        :rtype: S3StorageConfig
        """
        return self._s3_storage

    @s3_storage.setter
    def s3_storage(self, s3_storage):
        """

        :param s3_storage: The s3_storage of this ArchiveConfig.
        :type: S3StorageConfig
        """

        self._s3_storage = s3_storage

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ArchiveConfig):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ArchiveConfig):
            return True

        return self.to_dict() != other.to_dict()
