# coding: utf-8

"""
    Tator REST API

    Interface to the Tator backend.  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ..configuration import Configuration


class FavoriteSpec(object):
    """
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'name': 'str',
        'page': 'int',
        'type': 'int',
        'values': 'dict(str, object)'
    }

    attribute_map = {
        'name': 'name',
        'page': 'page',
        'type': 'type',
        'values': 'values'
    }

    def __init__(self, name=None, page=1, type=None, values=None, local_vars_configuration=None):  # noqa: E501
        """FavoriteSpec - a model defined in OpenAPI"""
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._name = None
        self._page = None
        self._type = None
        self._values = None
        self.discriminator = None

        if name is not None:
            self.name = name
        if page is not None:
            self.page = page
        if type is not None:
            self.type = type
        if values is not None:
            self.values = values

    @property
    def name(self):
        """
        Name of the favorite.

        :return: The name of this FavoriteSpec. 
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Name of the favorite.

        :param name: The name of this FavoriteSpec.
        :type: str
        """

        self._name = name

    @property
    def page(self):
        """
        Integer specifying page to display on. Should be 1-10.

        :return: The page of this FavoriteSpec. 
        :rtype: int
        """
        return self._page

    @page.setter
    def page(self, page):
        """
        Integer specifying page to display on. Should be 1-10.

        :param page: The page of this FavoriteSpec.
        :type: int
        """
        if (self.local_vars_configuration.client_side_validation and
                page is not None and page > 10):  # noqa: E501
            raise ValueError("Invalid value for `page`, must be a value less than or equal to `10`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                page is not None and page < 1):  # noqa: E501
            raise ValueError("Invalid value for `page`, must be a value greater than or equal to `1`")  # noqa: E501

        self._page = page

    @property
    def type(self):
        """
        Unique integer identifying a localization type.

        :return: The type of this FavoriteSpec. 
        :rtype: int
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Unique integer identifying a localization type.

        :param type: The type of this FavoriteSpec.
        :type: int
        """
        if (self.local_vars_configuration.client_side_validation and
                type is not None and type < 1):  # noqa: E501
            raise ValueError("Invalid value for `type`, must be a value greater than or equal to `1`")  # noqa: E501

        self._type = type

    @property
    def values(self):
        """
        Attribute name/value pairs.

        :return: The values of this FavoriteSpec. 
        :rtype: dict(str, object)
        """
        return self._values

    @values.setter
    def values(self, values):
        """
        Attribute name/value pairs.

        :param values: The values of this FavoriteSpec.
        :type: dict(str, object)
        """

        self._values = values

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, FavoriteSpec):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, FavoriteSpec):
            return True

        return self.to_dict() != other.to_dict()
