# coding: utf-8

"""
    Tator REST API

    Interface to the Tator backend.  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ..configuration import Configuration


class Media(object):
    """
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'attributes': 'dict(str, object)',
        'codec': 'str',
        'created_by': 'int',
        'created_datetime': 'str',
        'fps': 'int',
        'gid': 'str',
        'height': 'int',
        'id': 'int',
        'last_edit_end': 'datetime',
        'last_edit_start': 'datetime',
        'md5': 'str',
        'media_files': 'MediaFiles',
        'meta': 'int',
        'modified_by': 'int',
        'modified_datetime': 'str',
        'name': 'str',
        'num_frames': 'int',
        'project': 'int',
        'uid': 'str',
        'width': 'int'
    }

    attribute_map = {
        'attributes': 'attributes',
        'codec': 'codec',
        'created_by': 'created_by',
        'created_datetime': 'created_datetime',
        'fps': 'fps',
        'gid': 'gid',
        'height': 'height',
        'id': 'id',
        'last_edit_end': 'last_edit_end',
        'last_edit_start': 'last_edit_start',
        'md5': 'md5',
        'media_files': 'media_files',
        'meta': 'meta',
        'modified_by': 'modified_by',
        'modified_datetime': 'modified_datetime',
        'name': 'name',
        'num_frames': 'num_frames',
        'project': 'project',
        'uid': 'uid',
        'width': 'width'
    }

    def __init__(self, attributes=None, codec=None, created_by=None, created_datetime=None, fps=None, gid=None, height=None, id=None, last_edit_end=None, last_edit_start=None, md5=None, media_files=None, meta=None, modified_by=None, modified_datetime=None, name=None, num_frames=None, project=None, uid=None, width=None, local_vars_configuration=None):  # noqa: E501
        """Media - a model defined in OpenAPI"""
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._attributes = None
        self._codec = None
        self._created_by = None
        self._created_datetime = None
        self._fps = None
        self._gid = None
        self._height = None
        self._id = None
        self._last_edit_end = None
        self._last_edit_start = None
        self._md5 = None
        self._media_files = None
        self._meta = None
        self._modified_by = None
        self._modified_datetime = None
        self._name = None
        self._num_frames = None
        self._project = None
        self._uid = None
        self._width = None
        self.discriminator = None

        if attributes is not None:
            self.attributes = attributes
        if codec is not None:
            self.codec = codec
        if created_by is not None:
            self.created_by = created_by
        if created_datetime is not None:
            self.created_datetime = created_datetime
        if fps is not None:
            self.fps = fps
        if gid is not None:
            self.gid = gid
        if height is not None:
            self.height = height
        if id is not None:
            self.id = id
        if last_edit_end is not None:
            self.last_edit_end = last_edit_end
        if last_edit_start is not None:
            self.last_edit_start = last_edit_start
        if md5 is not None:
            self.md5 = md5
        if media_files is not None:
            self.media_files = media_files
        if meta is not None:
            self.meta = meta
        if modified_by is not None:
            self.modified_by = modified_by
        if modified_datetime is not None:
            self.modified_datetime = modified_datetime
        if name is not None:
            self.name = name
        if num_frames is not None:
            self.num_frames = num_frames
        if project is not None:
            self.project = project
        if uid is not None:
            self.uid = uid
        if width is not None:
            self.width = width

    @property
    def attributes(self):
        """
        Object containing attribute values.

        :return: The attributes of this Media. 
        :rtype: dict(str, object)
        """
        return self._attributes

    @attributes.setter
    def attributes(self, attributes):
        """
        Object containing attribute values.

        :param attributes: The attributes of this Media.
        :type: dict(str, object)
        """

        self._attributes = attributes

    @property
    def codec(self):
        """
        Codec for videos.

        :return: The codec of this Media. 
        :rtype: str
        """
        return self._codec

    @codec.setter
    def codec(self, codec):
        """
        Codec for videos.

        :param codec: The codec of this Media.
        :type: str
        """

        self._codec = codec

    @property
    def created_by(self):
        """
        Unique integer identifying user who created this media.

        :return: The created_by of this Media. 
        :rtype: int
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by):
        """
        Unique integer identifying user who created this media.

        :param created_by: The created_by of this Media.
        :type: int
        """

        self._created_by = created_by

    @property
    def created_datetime(self):
        """
        Datetime when this media was created.

        :return: The created_datetime of this Media. 
        :rtype: str
        """
        return self._created_datetime

    @created_datetime.setter
    def created_datetime(self, created_datetime):
        """
        Datetime when this media was created.

        :param created_datetime: The created_datetime of this Media.
        :type: str
        """

        self._created_datetime = created_datetime

    @property
    def fps(self):
        """
        Frame rate for videos.

        :return: The fps of this Media. 
        :rtype: int
        """
        return self._fps

    @fps.setter
    def fps(self, fps):
        """
        Frame rate for videos.

        :param fps: The fps of this Media.
        :type: int
        """

        self._fps = fps

    @property
    def gid(self):
        """
        Group ID for the upload group of this media.

        :return: The gid of this Media. 
        :rtype: str
        """
        return self._gid

    @gid.setter
    def gid(self, gid):
        """
        Group ID for the upload group of this media.

        :param gid: The gid of this Media.
        :type: str
        """

        self._gid = gid

    @property
    def height(self):
        """
        Vertical resolution in pixels.

        :return: The height of this Media. 
        :rtype: int
        """
        return self._height

    @height.setter
    def height(self, height):
        """
        Vertical resolution in pixels.

        :param height: The height of this Media.
        :type: int
        """

        self._height = height

    @property
    def id(self):
        """
        Unique integer identifying this media.

        :return: The id of this Media. 
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Unique integer identifying this media.

        :param id: The id of this Media.
        :type: int
        """

        self._id = id

    @property
    def last_edit_end(self):
        """
        Datetime of the end of the session when this media or its annotations were last edited.

        :return: The last_edit_end of this Media. 
        :rtype: datetime
        """
        return self._last_edit_end

    @last_edit_end.setter
    def last_edit_end(self, last_edit_end):
        """
        Datetime of the end of the session when this media or its annotations were last edited.

        :param last_edit_end: The last_edit_end of this Media.
        :type: datetime
        """

        self._last_edit_end = last_edit_end

    @property
    def last_edit_start(self):
        """
        Datetime of the start of the session when this media or its annotations were last edited.

        :return: The last_edit_start of this Media. 
        :rtype: datetime
        """
        return self._last_edit_start

    @last_edit_start.setter
    def last_edit_start(self, last_edit_start):
        """
        Datetime of the start of the session when this media or its annotations were last edited.

        :param last_edit_start: The last_edit_start of this Media.
        :type: datetime
        """

        self._last_edit_start = last_edit_start

    @property
    def md5(self):
        """
        MD5 checksum of the media file.

        :return: The md5 of this Media. 
        :rtype: str
        """
        return self._md5

    @md5.setter
    def md5(self, md5):
        """
        MD5 checksum of the media file.

        :param md5: The md5 of this Media.
        :type: str
        """

        self._md5 = md5

    @property
    def media_files(self):
        """

        :return: The media_files of this Media. 
        :rtype: MediaFiles
        """
        return self._media_files

    @media_files.setter
    def media_files(self, media_files):
        """

        :param media_files: The media_files of this Media.
        :type: MediaFiles
        """

        self._media_files = media_files

    @property
    def meta(self):
        """
        Unique integer identifying entity type of this media.

        :return: The meta of this Media. 
        :rtype: int
        """
        return self._meta

    @meta.setter
    def meta(self, meta):
        """
        Unique integer identifying entity type of this media.

        :param meta: The meta of this Media.
        :type: int
        """

        self._meta = meta

    @property
    def modified_by(self):
        """
        Unique integer identifying user who last modified this media.

        :return: The modified_by of this Media. 
        :rtype: int
        """
        return self._modified_by

    @modified_by.setter
    def modified_by(self, modified_by):
        """
        Unique integer identifying user who last modified this media.

        :param modified_by: The modified_by of this Media.
        :type: int
        """

        self._modified_by = modified_by

    @property
    def modified_datetime(self):
        """
        Datetime when this media was last modified.

        :return: The modified_datetime of this Media. 
        :rtype: str
        """
        return self._modified_datetime

    @modified_datetime.setter
    def modified_datetime(self, modified_datetime):
        """
        Datetime when this media was last modified.

        :param modified_datetime: The modified_datetime of this Media.
        :type: str
        """

        self._modified_datetime = modified_datetime

    @property
    def name(self):
        """
        Name of the media.

        :return: The name of this Media. 
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Name of the media.

        :param name: The name of this Media.
        :type: str
        """

        self._name = name

    @property
    def num_frames(self):
        """
        Number of frames for videos.

        :return: The num_frames of this Media. 
        :rtype: int
        """
        return self._num_frames

    @num_frames.setter
    def num_frames(self, num_frames):
        """
        Number of frames for videos.

        :param num_frames: The num_frames of this Media.
        :type: int
        """

        self._num_frames = num_frames

    @property
    def project(self):
        """
        Unique integer identifying project of this media.

        :return: The project of this Media. 
        :rtype: int
        """
        return self._project

    @project.setter
    def project(self, project):
        """
        Unique integer identifying project of this media.

        :param project: The project of this Media.
        :type: int
        """

        self._project = project

    @property
    def uid(self):
        """
        Unique ID for the upload of this media.

        :return: The uid of this Media. 
        :rtype: str
        """
        return self._uid

    @uid.setter
    def uid(self, uid):
        """
        Unique ID for the upload of this media.

        :param uid: The uid of this Media.
        :type: str
        """

        self._uid = uid

    @property
    def width(self):
        """
        Horizontal resolution in pixels.

        :return: The width of this Media. 
        :rtype: int
        """
        return self._width

    @width.setter
    def width(self, width):
        """
        Horizontal resolution in pixels.

        :param width: The width of this Media.
        :type: int
        """

        self._width = width

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Media):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Media):
            return True

        return self.to_dict() != other.to_dict()
