# coding: utf-8

"""
    Tator REST API

    Interface to the Tator backend.  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ..configuration import Configuration


class MediaTypeUpdate(object):
    """
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'archive_config': 'list[ArchiveConfig]',
        'default_volume': 'int',
        'description': 'str',
        'file_format': 'str',
        'name': 'str',
        'streaming_config': 'list[ResolutionConfig]',
        'visible': 'bool'
    }

    attribute_map = {
        'archive_config': 'archive_config',
        'default_volume': 'default_volume',
        'description': 'description',
        'file_format': 'file_format',
        'name': 'name',
        'streaming_config': 'streaming_config',
        'visible': 'visible'
    }

    def __init__(self, archive_config=None, default_volume=None, description='', file_format=None, name=None, streaming_config=None, visible=None, local_vars_configuration=None):  # noqa: E501
        """MediaTypeUpdate - a model defined in OpenAPI"""
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._archive_config = None
        self._default_volume = None
        self._description = None
        self._file_format = None
        self._name = None
        self._streaming_config = None
        self._visible = None
        self.discriminator = None

        if archive_config is not None:
            self.archive_config = archive_config
        if default_volume is not None:
            self.default_volume = default_volume
        if description is not None:
            self.description = description
        if file_format is not None:
            self.file_format = file_format
        if name is not None:
            self.name = name
        if streaming_config is not None:
            self.streaming_config = streaming_config
        if visible is not None:
            self.visible = visible

    @property
    def archive_config(self):
        """
        Archive config definitions. If null, the raw file will be uploaded to Tator.

        :return: The archive_config of this MediaTypeUpdate. 
        :rtype: list[ArchiveConfig]
        """
        return self._archive_config

    @archive_config.setter
    def archive_config(self, archive_config):
        """
        Archive config definitions. If null, the raw file will be uploaded to Tator.

        :param archive_config: The archive_config of this MediaTypeUpdate.
        :type: list[ArchiveConfig]
        """

        self._archive_config = archive_config

    @property
    def default_volume(self):
        """
        Default audio volume for this media type.

        :return: The default_volume of this MediaTypeUpdate. 
        :rtype: int
        """
        return self._default_volume

    @default_volume.setter
    def default_volume(self, default_volume):
        """
        Default audio volume for this media type.

        :param default_volume: The default_volume of this MediaTypeUpdate.
        :type: int
        """
        if (self.local_vars_configuration.client_side_validation and
                default_volume is not None and default_volume > 100):  # noqa: E501
            raise ValueError("Invalid value for `default_volume`, must be a value less than or equal to `100`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                default_volume is not None and default_volume < 0):  # noqa: E501
            raise ValueError("Invalid value for `default_volume`, must be a value greater than or equal to `0`")  # noqa: E501

        self._default_volume = default_volume

    @property
    def description(self):
        """
        Description of the media type.

        :return: The description of this MediaTypeUpdate. 
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Description of the media type.

        :param description: The description of this MediaTypeUpdate.
        :type: str
        """

        self._description = description

    @property
    def file_format(self):
        """
        File extension. If omitted, any recognized file extension for the given dtype is accepted for upload. Do not include a dot prefix.

        :return: The file_format of this MediaTypeUpdate. 
        :rtype: str
        """
        return self._file_format

    @file_format.setter
    def file_format(self, file_format):
        """
        File extension. If omitted, any recognized file extension for the given dtype is accepted for upload. Do not include a dot prefix.

        :param file_format: The file_format of this MediaTypeUpdate.
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                file_format is not None and len(file_format) > 4):
            raise ValueError("Invalid value for `file_format`, length must be less than or equal to `4`")  # noqa: E501

        self._file_format = file_format

    @property
    def name(self):
        """
        Name of the media type.

        :return: The name of this MediaTypeUpdate. 
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Name of the media type.

        :param name: The name of this MediaTypeUpdate.
        :type: str
        """

        self._name = name

    @property
    def streaming_config(self):
        """
        Streaming config defintion. If null, the default will be used.

        :return: The streaming_config of this MediaTypeUpdate. 
        :rtype: list[ResolutionConfig]
        """
        return self._streaming_config

    @streaming_config.setter
    def streaming_config(self, streaming_config):
        """
        Streaming config defintion. If null, the default will be used.

        :param streaming_config: The streaming_config of this MediaTypeUpdate.
        :type: list[ResolutionConfig]
        """

        self._streaming_config = streaming_config

    @property
    def visible(self):
        """
        Visible configuration

        :return: The visible of this MediaTypeUpdate. 
        :rtype: bool
        """
        return self._visible

    @visible.setter
    def visible(self, visible):
        """
        Visible configuration

        :param visible: The visible of this MediaTypeUpdate.
        :type: bool
        """

        self._visible = visible

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MediaTypeUpdate):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, MediaTypeUpdate):
            return True

        return self.to_dict() != other.to_dict()
