# coding: utf-8

"""
    Tator REST API

    Interface to the Tator backend.  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ..configuration import Configuration


class State(object):
    """
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'attributes': 'dict(str, object)',
        'created_by': 'int',
        'created_datetime': 'datetime',
        'frame': 'int',
        'id': 'int',
        'localizations': 'list[int]',
        'media': 'list[int]',
        'meta': 'int',
        'modified_by': 'int',
        'modified_datetime': 'datetime',
        'segments': 'list[list[int]]',
        'version': 'int'
    }

    attribute_map = {
        'attributes': 'attributes',
        'created_by': 'created_by',
        'created_datetime': 'created_datetime',
        'frame': 'frame',
        'id': 'id',
        'localizations': 'localizations',
        'media': 'media',
        'meta': 'meta',
        'modified_by': 'modified_by',
        'modified_datetime': 'modified_datetime',
        'segments': 'segments',
        'version': 'version'
    }

    def __init__(self, attributes=None, created_by=None, created_datetime=None, frame=None, id=None, localizations=None, media=None, meta=None, modified_by=None, modified_datetime=None, segments=None, version=None, local_vars_configuration=None):  # noqa: E501
        """State - a model defined in OpenAPI"""
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._attributes = None
        self._created_by = None
        self._created_datetime = None
        self._frame = None
        self._id = None
        self._localizations = None
        self._media = None
        self._meta = None
        self._modified_by = None
        self._modified_datetime = None
        self._segments = None
        self._version = None
        self.discriminator = None

        if attributes is not None:
            self.attributes = attributes
        if created_by is not None:
            self.created_by = created_by
        if created_datetime is not None:
            self.created_datetime = created_datetime
        if frame is not None:
            self.frame = frame
        if id is not None:
            self.id = id
        if localizations is not None:
            self.localizations = localizations
        if media is not None:
            self.media = media
        if meta is not None:
            self.meta = meta
        if modified_by is not None:
            self.modified_by = modified_by
        if modified_datetime is not None:
            self.modified_datetime = modified_datetime
        if segments is not None:
            self.segments = segments
        if version is not None:
            self.version = version

    @property
    def attributes(self):
        """
        Object containing attribute values.

        :return: The attributes of this State. 
        :rtype: dict(str, object)
        """
        return self._attributes

    @attributes.setter
    def attributes(self, attributes):
        """
        Object containing attribute values.

        :param attributes: The attributes of this State.
        :type: dict(str, object)
        """

        self._attributes = attributes

    @property
    def created_by(self):
        """
        Unique integer identifying the user who created this state.

        :return: The created_by of this State. 
        :rtype: int
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by):
        """
        Unique integer identifying the user who created this state.

        :param created_by: The created_by of this State.
        :type: int
        """

        self._created_by = created_by

    @property
    def created_datetime(self):
        """
        Datetime this state was created.

        :return: The created_datetime of this State. 
        :rtype: datetime
        """
        return self._created_datetime

    @created_datetime.setter
    def created_datetime(self, created_datetime):
        """
        Datetime this state was created.

        :param created_datetime: The created_datetime of this State.
        :type: datetime
        """

        self._created_datetime = created_datetime

    @property
    def frame(self):
        """
        Frame number this state applies to.

        :return: The frame of this State. 
        :rtype: int
        """
        return self._frame

    @frame.setter
    def frame(self, frame):
        """
        Frame number this state applies to.

        :param frame: The frame of this State.
        :type: int
        """

        self._frame = frame

    @property
    def id(self):
        """
        Unique integer identifying the state.

        :return: The id of this State. 
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Unique integer identifying the state.

        :param id: The id of this State.
        :type: int
        """

        self._id = id

    @property
    def localizations(self):
        """
        List of localization IDs that this state applies to.

        :return: The localizations of this State. 
        :rtype: list[int]
        """
        return self._localizations

    @localizations.setter
    def localizations(self, localizations):
        """
        List of localization IDs that this state applies to.

        :param localizations: The localizations of this State.
        :type: list[int]
        """

        self._localizations = localizations

    @property
    def media(self):
        """
        List of media IDs that this state applies to.

        :return: The media of this State. 
        :rtype: list[int]
        """
        return self._media

    @media.setter
    def media(self, media):
        """
        List of media IDs that this state applies to.

        :param media: The media of this State.
        :type: list[int]
        """

        self._media = media

    @property
    def meta(self):
        """
        Unique integer identifying the entity type.

        :return: The meta of this State. 
        :rtype: int
        """
        return self._meta

    @meta.setter
    def meta(self, meta):
        """
        Unique integer identifying the entity type.

        :param meta: The meta of this State.
        :type: int
        """

        self._meta = meta

    @property
    def modified_by(self):
        """
        Unique integer identifying the user who last modified this state.

        :return: The modified_by of this State. 
        :rtype: int
        """
        return self._modified_by

    @modified_by.setter
    def modified_by(self, modified_by):
        """
        Unique integer identifying the user who last modified this state.

        :param modified_by: The modified_by of this State.
        :type: int
        """

        self._modified_by = modified_by

    @property
    def modified_datetime(self):
        """
        Datetime this state was last modified.

        :return: The modified_datetime of this State. 
        :rtype: datetime
        """
        return self._modified_datetime

    @modified_datetime.setter
    def modified_datetime(self, modified_datetime):
        """
        Datetime this state was last modified.

        :param modified_datetime: The modified_datetime of this State.
        :type: datetime
        """

        self._modified_datetime = modified_datetime

    @property
    def segments(self):
        """
        List of contiguous frame ranges where a localization associated state has localization data.

        :return: The segments of this State. 
        :rtype: list[list[int]]
        """
        return self._segments

    @segments.setter
    def segments(self, segments):
        """
        List of contiguous frame ranges where a localization associated state has localization data.

        :param segments: The segments of this State.
        :type: list[list[int]]
        """

        self._segments = segments

    @property
    def version(self):
        """
        Unique integer identifying the version.

        :return: The version of this State. 
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version):
        """
        Unique integer identifying the version.

        :param version: The version of this State.
        :type: int
        """

        self._version = version

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, State):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, State):
            return True

        return self.to_dict() != other.to_dict()
