# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables

class Mount(pulumi.CustomResource):
    accessor: pulumi.Output[str]
    """
    The accessor for this mount.
    """
    default_lease_ttl_seconds: pulumi.Output[float]
    """
    Default lease duration for tokens and secrets in seconds
    """
    description: pulumi.Output[str]
    """
    Human-friendly description of the mount
    """
    local: pulumi.Output[bool]
    """
    Boolean flag that can be explicitly set to true to enforce local mount in HA environment
    """
    max_lease_ttl_seconds: pulumi.Output[float]
    """
    Maximum possible lease duration for tokens and secrets in seconds
    """
    options: pulumi.Output[dict]
    """
    Specifies mount type specific options that are passed to the backend
    """
    path: pulumi.Output[str]
    """
    Where the secret backend will be mounted
    """
    seal_wrap: pulumi.Output[bool]
    """
    Boolean flag that can be explicitly set to true to enable seal wrapping for the mount, causing values stored by the mount to be wrapped by the seal's encryption capability
    """
    type: pulumi.Output[str]
    """
    Type of the backend, such as "aws"
    """
    def __init__(__self__, resource_name, opts=None, default_lease_ttl_seconds=None, description=None, local=None, max_lease_ttl_seconds=None, options=None, path=None, seal_wrap=None, type=None, __props__=None, __name__=None, __opts__=None):
        """


        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[float] default_lease_ttl_seconds: Default lease duration for tokens and secrets in seconds
        :param pulumi.Input[str] description: Human-friendly description of the mount
        :param pulumi.Input[bool] local: Boolean flag that can be explicitly set to true to enforce local mount in HA environment
        :param pulumi.Input[float] max_lease_ttl_seconds: Maximum possible lease duration for tokens and secrets in seconds
        :param pulumi.Input[dict] options: Specifies mount type specific options that are passed to the backend
        :param pulumi.Input[str] path: Where the secret backend will be mounted
        :param pulumi.Input[bool] seal_wrap: Boolean flag that can be explicitly set to true to enable seal wrapping for the mount, causing values stored by the mount to be wrapped by the seal's encryption capability
        :param pulumi.Input[str] type: Type of the backend, such as "aws"
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['default_lease_ttl_seconds'] = default_lease_ttl_seconds
            __props__['description'] = description
            __props__['local'] = local
            __props__['max_lease_ttl_seconds'] = max_lease_ttl_seconds
            __props__['options'] = options
            if path is None:
                raise TypeError("Missing required property 'path'")
            __props__['path'] = path
            __props__['seal_wrap'] = seal_wrap
            if type is None:
                raise TypeError("Missing required property 'type'")
            __props__['type'] = type
            __props__['accessor'] = None
        super(Mount, __self__).__init__(
            'vault:index/mount:Mount',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, accessor=None, default_lease_ttl_seconds=None, description=None, local=None, max_lease_ttl_seconds=None, options=None, path=None, seal_wrap=None, type=None):
        """
        Get an existing Mount resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] accessor: The accessor for this mount.
        :param pulumi.Input[float] default_lease_ttl_seconds: Default lease duration for tokens and secrets in seconds
        :param pulumi.Input[str] description: Human-friendly description of the mount
        :param pulumi.Input[bool] local: Boolean flag that can be explicitly set to true to enforce local mount in HA environment
        :param pulumi.Input[float] max_lease_ttl_seconds: Maximum possible lease duration for tokens and secrets in seconds
        :param pulumi.Input[dict] options: Specifies mount type specific options that are passed to the backend
        :param pulumi.Input[str] path: Where the secret backend will be mounted
        :param pulumi.Input[bool] seal_wrap: Boolean flag that can be explicitly set to true to enable seal wrapping for the mount, causing values stored by the mount to be wrapped by the seal's encryption capability
        :param pulumi.Input[str] type: Type of the backend, such as "aws"
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["accessor"] = accessor
        __props__["default_lease_ttl_seconds"] = default_lease_ttl_seconds
        __props__["description"] = description
        __props__["local"] = local
        __props__["max_lease_ttl_seconds"] = max_lease_ttl_seconds
        __props__["options"] = options
        __props__["path"] = path
        __props__["seal_wrap"] = seal_wrap
        __props__["type"] = type
        return Mount(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

